/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.ConfigManager;

public abstract class BaseConfigManager
implements ConfigManager {
    protected Hashtable dds = new Hashtable();
    protected String[] serviceNamesCache;
    protected ServletContext context = null;

    public void setContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public void init() throws SOAPException {
        this.loadRegistry();
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        String string = deploymentDescriptor.getID();
        this.dds.put(string, deploymentDescriptor);
        this.saveRegistry();
        this.serviceNamesCache = null;
    }

    public DeploymentDescriptor undeploy(String string) throws SOAPException {
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.dds.remove(string);
        if (deploymentDescriptor == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service '" + string + "' unknown");
        }
        this.saveRegistry();
        this.serviceNamesCache = null;
        return deploymentDescriptor;
    }

    public String[] list() throws SOAPException {
        if (this.serviceNamesCache != null) {
            return this.serviceNamesCache;
        }
        Enumeration enumeration = this.dds.keys();
        int n = this.dds.size();
        this.serviceNamesCache = new String[n];
        for (int i = 0; i < n; ++i) {
            this.serviceNamesCache[i] = (String)enumeration.nextElement();
        }
        return this.serviceNamesCache;
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.dds.get(string);
        return deploymentDescriptor;
    }

    public abstract void loadRegistry() throws SOAPException;

    public abstract void saveRegistry() throws SOAPException;
}

