/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.component.VariableMapImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfigImpl;
import com.ibm.ws.runtime.service.ComponentManagerImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.util.ImplFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.emf.ecore.EObject;

public class WsServer {
    private static final String SERVER_TYPE = "process.Server";
    private static TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ws$runtime$WsServer;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ComponentManager;

    protected WsServer() {
    }

    protected boolean start(String[] stringArray) {
        ComponentManagerImpl componentManagerImpl;
        if (stringArray.length < 4) {
            throw new IllegalArgumentException("<config root> <cell> <node> <process>");
        }
        ContainerImpl containerImpl = new ContainerImpl();
        RepositoryImpl repositoryImpl = new RepositoryImpl("ws-server", stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        containerImpl.addService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = WsServer.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository, (BeanContextServiceProvider)repositoryImpl);
        VariableMapImpl variableMapImpl = new VariableMapImpl();
        containerImpl.add(variableMapImpl);
        variableMapImpl.initialize(null);
        ConfigLocator[] configLocatorArray = this.getConfigLocators();
        if (configLocatorArray == null) {
            return false;
        }
        for (int i = 0; i < configLocatorArray.length; ++i) {
            try {
                configLocatorArray[i].initialize(repositoryImpl);
                continue;
            }
            catch (ConfigurationWarning configurationWarning) {
                continue;
            }
            catch (ConfigurationError configurationError) {
                Tr.error(tc, "WSVR0100W", new Object[]{configLocatorArray[i], configurationError});
                return false;
            }
        }
        Server server = this.readConfig(configLocatorArray, repositoryImpl, stringArray[1]);
        if (server != null && !server.getName().equals(repositoryImpl.getServerName())) {
            Tr.error(tc, "WSVR0004E", repositoryImpl.getServerName());
            server = null;
        }
        if (server == null) {
            return false;
        }
        repositoryImpl.setClusterName(server.getClusterName());
        variableMapImpl.addVariable("CLUSTER", server.getClusterName());
        try {
            componentManagerImpl = new ComponentManagerImpl("META-INF/ws-server-components.xml", Thread.currentThread().getContextClassLoader());
            containerImpl.addService(class$com$ibm$ws$runtime$service$ComponentManager == null ? (class$com$ibm$ws$runtime$service$ComponentManager = WsServer.class$("com.ibm.ws.runtime.service.ComponentManager")) : class$com$ibm$ws$runtime$service$ComponentManager, (BeanContextServiceProvider)componentManagerImpl);
        }
        catch (ConfigurationError configurationError) {
            Tr.error(tc, "WSVR0008E", new Object[]{"META-INF/ws-server-components.xml", configurationError});
            return false;
        }
        Component component = (Component)componentManagerImpl.getComponent((EObject)server);
        containerImpl.add(component);
        try {
            boolean bl = false;
            try {
                component.initialize(new ContainerConfigImpl(server, configLocatorArray));
            }
            catch (ConfigurationWarning configurationWarning) {
                bl = true;
            }
            catch (Throwable throwable) {
                component.destroy();
                throw throwable;
            }
            try {
                component.start();
            }
            catch (RuntimeWarning runtimeWarning) {
                bl = true;
            }
            catch (Throwable throwable) {
                component.stop();
                component.destroy();
                throw throwable;
            }
            finally {
                repositoryImpl.stopSharing();
            }
            if (bl) {
                Tr.audit(tc, "WSVR0002I", component.getName());
            } else {
                Tr.audit(tc, "WSVR0001I", component.getName());
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0003E", new Object[]{stringArray[3], throwable});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ConfigLocator[] getConfigLocators() {
        ConfigLocator[] configLocatorArray;
        ArrayList<ConfigLocator> arrayList = new ArrayList<ConfigLocator>(3);
        Enumeration<URL> enumeration = null;
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources("META-INF/ws-server.config");
        }
        catch (IOException iOException) {
            Tr.error(tc, "WSVR0100W", new Object[]{"WsServer", iOException});
            return null;
        }
        while (enumeration.hasMoreElements()) {
            String string;
            configLocatorArray = enumeration.nextElement();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader(configLocatorArray.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    ConfigLocator configLocator = (ConfigLocator)ImplFactory.loadImplFromClass(string);
                    arrayList.add(configLocator);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WSVR0100W", new Object[]{string, throwable});
                }
            }
            Object var8_10 = null;
            if (bufferedReader == null) continue;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {}
            continue;
            {
                catch (IOException iOException) {
                    Tr.service(tc, "WSVR0100W", new Object[]{configLocatorArray.toString(), iOException});
                    var8_10 = null;
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_10 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        configLocatorArray = new ConfigLocator[arrayList.size()];
        arrayList.toArray(configLocatorArray);
        return configLocatorArray;
    }

    protected Server readConfig(ConfigLocator[] configLocatorArray, Repository repository, String string) {
        Server server = null;
        try {
            for (int i = 0; server == null && i < configLocatorArray.length; ++i) {
                server = (Server)configLocatorArray[i].getConfig(null, SERVER_TYPE);
            }
            if (server == null) {
                Tr.error(tc, "WSVR0007E", new Object[]{SERVER_TYPE, string});
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0008E", new Object[]{string, throwable});
            return null;
        }
        return server;
    }

    public static void main(String[] stringArray) {
        WsServer wsServer = new WsServer();
        boolean bl = true;
        try {
            bl = wsServer.start(stringArray);
            if (!bl) {
                Tr.error(tc, "WSVR0009E", "");
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0009E", throwable);
            bl = false;
        }
        if (!bl) {
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        RasHelper.setServer();
        tc = Tr.register(class$com$ibm$ws$runtime$WsServer == null ? (class$com$ibm$ws$runtime$WsServer = WsServer.class$("com.ibm.ws.runtime.WsServer")) : class$com$ibm$ws$runtime$WsServer, "Runtime", "com.ibm.ws.runtime.runtime");
    }
}

