/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ContainerConfigImpl;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProvider;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.EObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ContainerImpl
extends ComponentImpl
implements BeanContextServices {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$component$ContainerImpl == null ? (class$com$ibm$ws$runtime$component$ContainerImpl = ContainerImpl.class$("com.ibm.ws.runtime.component.ContainerImpl")) : class$com$ibm$ws$runtime$component$ContainerImpl, "Runtime", "com.ibm.ws.runtime.runtime");
    protected List components = Collections.EMPTY_LIST;
    protected ArrayList bcmListeners;
    protected ArrayList children = new ArrayList(3);
    protected ArrayList bcsListeners;
    protected HashMap services;
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$ContainerImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ComponentManager;

    public ContainerImpl() {
        this.bcmListeners = new ArrayList(1);
        this.bcsListeners = new ArrayList(1);
        this.services = new HashMap(3);
    }

    protected BeanContextServices getOuterBCS() {
        return this.getBeanContextServices();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResourceAsStream(string);
    }

    public URL getResource(String string, BeanContextChild beanContextChild) throws IllegalArgumentException {
        return beanContextChild.getClass().getClassLoader().getResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(beanContextMembershipListener)) {
                this.bcmListeners.add(beanContextMembershipListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        BeanContextMembershipListener beanContextMembershipListener2 = beanContextMembershipListener;
        synchronized (beanContextMembershipListener2) {
            this.bcmListeners.remove(beanContextMembershipListener);
        }
    }

    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        Object v = this.services.remove(clazz);
        if (v != null) {
            this.fireServiceRevoked(new BeanContextServiceRevokedEvent(this, clazz, bl));
        }
    }

    public boolean hasService(Class clazz) {
        if (this.services.get(clazz) == null) {
            BeanContextServices beanContextServices = this.getBeanContextServices();
            return beanContextServices == null ? false : beanContextServices.hasService(clazz);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        BeanContextServiceProvider beanContextServiceProvider = null;
        Object object3 = this.services;
        synchronized (object3) {
            beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        }
        if (beanContextServiceProvider != null) {
            return beanContextServiceProvider.getService(this, object, clazz, object2);
        }
        object3 = this.getBeanContextServices();
        if (object3 != null) {
            return object3.getService(this, object, clazz, object2, beanContextServiceRevokedListener);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        BeanContextServiceProvider beanContextServiceProvider2 = null;
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            beanContextServiceProvider2 = this.services.put(clazz, beanContextServiceProvider);
            if (beanContextServiceProvider2 != null) {
                this.services.put(clazz, beanContextServiceProvider2);
            }
        }
        return beanContextServiceProvider2 == null;
    }

    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        BeanContextServices beanContextServices;
        if (this.services.get(object2) == null && (beanContextServices = this.getBeanContextServices()) != null) {
            beanContextServices.releaseService(this, object, object2);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return this.services.keySet().iterator();
    }

    public Iterator getCurrentServiceSelectors(Class clazz) {
        BeanContextServiceProvider beanContextServiceProvider = (BeanContextServiceProvider)this.services.get(clazz);
        return beanContextServiceProvider == null ? null : beanContextServiceProvider.getCurrentServiceSelectors(this, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                this.bcsListeners.add(beanContextServicesListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        if (this.services.containsKey(beanContextServiceAvailableEvent.getServiceClass())) {
            return;
        }
        this.fireServiceAdded(beanContextServiceAvailableEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e).serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        if (this.services.containsKey(beanContextServiceRevokedEvent.getServiceClass())) {
            return;
        }
        this.fireServiceRevoked(beanContextServiceRevokedEvent);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof BeanContextServicesListener)) continue;
            ((BeanContextServicesListener)e).serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    public boolean needsGui() {
        return false;
    }

    public void dontUseGui() {
    }

    public void okToUseGui() {
    }

    public boolean avoidingGui() {
        return true;
    }

    public void setDesignTime(boolean bl) {
    }

    public boolean isDesignTime() {
        return false;
    }

    public int size() {
        return this.children.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean contains(Object object) {
        return this.children.contains(object);
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.children.toArray(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (this.children.contains(object)) {
                return false;
            }
            this.children.add(object);
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                ArrayList arrayList = this.children;
                synchronized (arrayList) {
                    this.children.remove(object);
                }
                throw new IllegalStateException();
            }
        }
        this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this.children;
        synchronized (object2) {
            if (!this.children.contains(object)) {
                return false;
            }
        }
        if (object instanceof BeanContextChild) {
            object2 = (BeanContextChild)object;
            try {
                object2.setBeanContext(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new IllegalStateException();
            }
        }
        object2 = this.children;
        synchronized (object2) {
            this.children.remove(object);
        }
        this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            return this.children.containsAll(collection);
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    protected void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        BeanContextServicesListener[] beanContextServicesListenerArray = new BeanContextServicesListener[this.bcsListeners.size()];
        this.bcsListeners.toArray(beanContextServicesListenerArray);
        for (int i = 0; i < beanContextServicesListenerArray.length; ++i) {
            beanContextServicesListenerArray[i].serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    protected void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenAdded(beanContextMembershipEvent);
        }
    }

    protected void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        BeanContextMembershipListener[] beanContextMembershipListenerArray = new BeanContextMembershipListener[this.bcmListeners.size()];
        this.bcmListeners.toArray(beanContextMembershipListenerArray);
        for (int i = 0; i < beanContextMembershipListenerArray.length; ++i) {
            beanContextMembershipListenerArray[i].childrenRemoved(beanContextMembershipEvent);
        }
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
    }

    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String string) throws ConfigurationError {
        Object object;
        Enumeration<URL> enumeration;
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationError(iOException);
        }
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigurationError(factoryConfigurationError);
        }
        object = new StartupHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler((ErrorHandler)object);
        ArrayList<ComponentStartup> arrayList = new ArrayList<ComponentStartup>();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", this);
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parsing", uRL);
            }
            try {
                xMLReader.parse(uRL.toExternalForm());
                List list = ((StartupHandler)object).getComponents();
                for (int i = 0; i < list.size(); ++i) {
                    ComponentStartup componentStartup = (ComponentStartup)list.get(i);
                    if (arrayList.contains(componentStartup)) {
                        String string2 = componentStartup.type != null ? componentStartup.type : componentStartup.clazz;
                        Tr.warning(tc, "WSVR0107W", new Object[]{string2, uRL});
                        continue;
                    }
                    arrayList.add(componentStartup);
                }
            }
            catch (SAXParseException sAXParseException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception == null) {
                    exception = sAXException;
                }
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", exception});
            }
            catch (IOException iOException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", iOException});
            }
        }
        Collections.sort(arrayList, new StartupCompartor());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + arrayList.size(), this);
            for (int i = 0; i < arrayList.size(); ++i) {
                Tr.debug(tc, " component " + i, arrayList.get(i));
            }
        }
        return arrayList;
    }

    protected void startComponents() throws RuntimeWarning, RuntimeError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "startComponents " + this.components.size(), this);
        }
        RuntimeWarning runtimeWarning = null;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "starting " + i, component);
                }
                component.start();
                continue;
            }
            catch (RuntimeWarning runtimeWarning2) {
                runtimeWarning = runtimeWarning2;
                Tr.error(tc, "WSVR0501E", new Object[]{component, runtimeWarning2});
                continue;
            }
            catch (RuntimeError runtimeError) {
                throw runtimeError;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "546");
                Tr.error(tc, "WSVR0501E", new Object[]{component, throwable});
                runtimeWarning = new RuntimeWarning(throwable);
            }
        }
        if (runtimeWarning != null) {
            throw runtimeWarning;
        }
    }

    protected void stopComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stopComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = (Component)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopping " + i, component);
                }
                component.stop();
                continue;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0102E", new Object[]{component, throwable});
            }
        }
    }

    protected void destroyComponents() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroyComponents " + this.components.size(), this);
        }
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = (Component)this.components.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "destroying " + i, component);
                }
                component.destroy();
                continue;
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WSVR0103E", new Object[]{component, throwable});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(EObject eObject, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initializeComponents", this);
        }
        ComponentManager componentManager = null;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        ConfigurationWarning configurationWarning = null;
        try {
            componentManager = (ComponentManager)this.getService(class$com$ibm$ws$runtime$service$ComponentManager == null ? (class$com$ibm$ws$runtime$service$ComponentManager = ContainerImpl.class$("com.ibm.ws.runtime.service.ComponentManager")) : class$com$ibm$ws$runtime$service$ComponentManager);
            for (int i = 0; i < this.components.size(); ++i) {
                ComponentStartup componentStartup = (ComponentStartup)this.components.get(i);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing ", componentStartup);
                    }
                    if (componentStartup.clazz != null) {
                        this.initializeComponent(componentStartup.clazz, null, null, componentManager, hashMap, arrayList, configLocatorArray);
                        continue;
                    }
                    Object object = null;
                    for (int j = 0; object == null && j < configLocatorArray.length; ++j) {
                        object = configLocatorArray[j].getConfig(eObject, componentStartup.type);
                    }
                    if (object == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "config data is", object);
                    }
                    if (object instanceof List) {
                        List list = (List)object;
                        for (int j = 0; j < list.size(); ++j) {
                            EObject eObject2 = (EObject)list.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "next config element is", eObject2);
                            }
                            this.initializeComponent(null, eObject2, (EObject)eObject2.eClass(), componentManager, hashMap, arrayList, configLocatorArray);
                        }
                        continue;
                    }
                    EObject eObject3 = (EObject)object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "single config element is", eObject3);
                    }
                    this.initializeComponent(componentStartup.type, eObject3, (EObject)eObject3.eClass(), componentManager, hashMap, arrayList, configLocatorArray);
                    continue;
                }
                catch (ConfigurationWarning configurationWarning2) {
                    configurationWarning = configurationWarning2;
                }
            }
        }
        catch (Throwable throwable) {
            this.releaseService(componentManager);
            this.components = arrayList;
            throw throwable;
        }
        this.releaseService(componentManager);
        this.components = arrayList;
        if (configurationWarning != null) {
            throw configurationWarning;
        }
    }

    protected void initializeComponent(String string, Object object, EObject eObject, ComponentManager componentManager, Map map, List list, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "initializeComponent", new Object[]{string, object, eObject});
        }
        if (object == null) {
            object = string;
        }
        if (map.get(object) != null) {
            return;
        }
        map.put(object, object);
        Object object2 = componentManager.getInstance(object);
        if (object2 instanceof Component) {
            ConfigurationWarning configurationWarning = null;
            Component component = (Component)object2;
            if (this.add(component)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initializing", component);
                    }
                    if (object2 instanceof ContainerImpl) {
                        object = new ContainerConfigImpl(object, configLocatorArray);
                    }
                    component.initialize(object);
                }
                catch (ComponentDisabledException componentDisabledException) {
                    component = null;
                }
                catch (ConfigurationWarning configurationWarning2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Component, " + component + " failed to initialize", (Object)configurationWarning2);
                    }
                    configurationWarning = configurationWarning2;
                    if (configurationWarning2.getCause() instanceof ComponentDisabledException) {
                        component = null;
                        configurationWarning = new ConfigurationWarning(configurationWarning2.getMessage(), (Throwable)((Object)configurationWarning2));
                    }
                }
                catch (ConfigurationError configurationError) {
                    throw configurationError;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName(), "707");
                    component = null;
                    configurationWarning = new ConfigurationWarning("Exception caught when initializing component", throwable);
                    Tr.error(tc, "WSVR0501E", new Object[]{string, throwable});
                }
                if (component != null) {
                    list.add(component);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Component, " + object2 + " is disabled");
                    }
                    this.remove(object2);
                }
                if (configurationWarning != null) {
                    throw configurationWarning;
                }
            }
        } else if (object2 instanceof ServiceProvider) {
            ((ServiceProvider)object2).initialize(this.getBeanContextServices());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class StartupCompartor
    implements Comparator {
        StartupCompartor() {
        }

        public int compare(Object object, Object object2) {
            ComponentStartup componentStartup = (ComponentStartup)object;
            ComponentStartup componentStartup2 = (ComponentStartup)object2;
            return componentStartup.order - componentStartup2.order;
        }
    }

    static class StartupHandler
    extends DefaultHandler {
        Locator locator;
        List components = new ArrayList();
        ComponentStartup currentComponent;
        StringBuffer value = new StringBuffer();

        public List getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (string3.equals("component")) {
                this.currentComponent = new ComponentStartup();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentComponent == null) {
                return;
            }
            if (string3.equals("component")) {
                if (this.currentComponent.type == null && this.currentComponent.clazz == null) {
                    Tr.error(tc, "WSVR0104E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
                } else if (this.currentComponent.type != null && this.currentComponent.clazz != null) {
                    Tr.error(tc, "WSVR0105E", new Object[]{this.currentComponent.type, this.currentComponent.clazz, this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
                } else {
                    this.components.add(this.currentComponent);
                }
                this.currentComponent = null;
            } else if (string3.equals("class")) {
                if (this.currentComponent.clazz != null) throw new SAXParseException("Class already defined", this.locator);
                this.currentComponent.clazz = this.value.toString();
            } else if (string3.equals("type")) {
                if (this.currentComponent.type != null) throw new SAXParseException("Type already defined", this.locator);
                this.currentComponent.type = this.value.toString();
            } else {
                if (!string3.equals("startup")) throw new SAXParseException("Invalid tag: " + string3, this.locator);
                try {
                    int n;
                    this.currentComponent.order = n = Integer.parseInt(this.value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.error(tc, "WSVR0106E", new Object[]{this.locator.getSystemId(), new Integer(this.locator.getLineNumber())});
                }
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    protected static class ComponentStartup {
        public int order = Integer.MAX_VALUE;
        public String type;
        public String clazz;

        protected ComponentStartup() {
        }

        public String toString() {
            return (this.type != null ? this.type : this.clazz) + " [" + this.order + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof ComponentStartup) {
                boolean bl;
                ComponentStartup componentStartup = (ComponentStartup)object;
                boolean bl2 = this.type == null ? this.type == componentStartup.type : (bl = this.type.equals(componentStartup.type));
                boolean bl3 = this.clazz == null ? this.clazz == componentStartup.type : this.clazz.equals(componentStartup.clazz);
                return bl && bl3;
            }
            return false;
        }
    }
}

