/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ComponentFactory;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ServiceProviderImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentManagerImpl
extends ServiceProviderImpl
implements ComponentManager {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$runtime$service$ComponentManagerImpl == null ? (class$com$ibm$ws$runtime$service$ComponentManagerImpl = ComponentManagerImpl.class$("com.ibm.ws.runtime.service.ComponentManagerImpl")) : class$com$ibm$ws$runtime$service$ComponentManagerImpl, "Runtime", "com.ibm.ws.runtime.runtime");
    protected Map components = new HashMap();
    protected ClassLoader classLoader;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ComponentManagerImpl;

    public ComponentManagerImpl(String string, ClassLoader classLoader) throws ConfigurationError {
        this.classLoader = classLoader;
        this.load(string, classLoader);
    }

    protected void load(String string, ClassLoader classLoader) throws ConfigurationError {
        Object object;
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationError(iOException);
        }
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigurationError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigurationError(factoryConfigurationError);
        }
        object = new ComponentHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setDTDHandler((DTDHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler((ErrorHandler)object);
        while (enumeration.hasMoreElements()) {
            Object object2;
            URL uRL = enumeration.nextElement();
            try {
                xMLReader.parse(uRL.toExternalForm());
            }
            catch (SAXParseException sAXParseException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException});
            }
            catch (SAXException sAXException) {
                object2 = sAXException.getException();
                if (object2 == null) {
                    object2 = sAXException;
                }
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", object2});
            }
            catch (IOException iOException) {
                Tr.error(tc, "WSVR0500E", new Object[]{uRL.getFile(), "?", "?", iOException});
            }
            Iterator iterator = ((ComponentHandler)object).getComponents().values().iterator();
            while (iterator.hasNext()) {
                object2 = (ComponentInfo)iterator.next();
                try {
                    this.addComponent((ComponentInfo)object2);
                }
                catch (ConfigurationWarning configurationWarning) {
                    Tr.error(tc, "WSVR0501E", new Object[]{((ComponentInfo)object2).name, configurationWarning});
                }
            }
        }
    }

    private void addComponent(ComponentInfo componentInfo) throws ConfigurationWarning {
        Object object;
        EClass eClass = null;
        String string = componentInfo.name;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            object = string.substring(0, n);
            String string2 = string.substring(n + 1);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(componentInfo.getPackageUri((String)object));
            if (ePackage == null) {
                throw new ConfigurationWarning("Invalid namespace, " + (String)object + ", for " + string, null);
            }
            eClass = (EClass)ePackage.getEClassifier(string2);
        }
        if (eClass == null) {
            throw new ConfigurationWarning("Invalid component name, " + string);
        }
        object = (ComponentInfo)this.components.get(eClass);
        if (object == null) {
            this.components.put(eClass, componentInfo);
        } else {
            if (componentInfo.implClazz != null) {
                ((ComponentInfo)object).setImplementationClass(componentInfo.implClazz);
            }
            if (componentInfo.factories != null) {
                ((ComponentInfo)object).addFactories(componentInfo.factories);
            }
        }
    }

    public Object getComponent(EObject eObject) {
        Object object = null;
        EClass eClass = eObject.eClass();
        object = this.createInstance((EObject)eClass);
        if (object == null) {
            EList eList = eClass.getEAllSuperTypes();
            for (int i = 0; object == null && i < eList.size(); ++i) {
                object = this.createInstance((EObject)eList.get(i));
            }
        }
        return object;
    }

    public Object getInstance(Object object) {
        if (object instanceof EObject) {
            return this.getComponent((EObject)object);
        }
        try {
            Class<?> clazz = this.classLoader.loadClass(object.toString());
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "WSVR0501E", new Object[]{object, throwable});
            return null;
        }
    }

    protected Object createInstance(EObject eObject) {
        ComponentInfo componentInfo = (ComponentInfo)this.components.get(eObject);
        if (componentInfo != null) {
            return componentInfo.instantiate(this.classLoader, eObject);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ComponentHandler
    extends DefaultHandler {
        Locator locator;
        Map components = new HashMap();
        ComponentInfo currentComponent;
        StringBuffer value = new StringBuffer();
        static final String DEFAULT_PREFIX = "http://www.ibm.com/websphere/appserver/schemas/5.0/";
        String currentPrefix;

        public Map getComponents() {
            return this.components;
        }

        public void startDocument() throws SAXException {
            this.components.clear();
            this.currentPrefix = DEFAULT_PREFIX;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (string3.equals("component")) {
                this.currentComponent = new ComponentInfo();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentComponent == null) {
                if (!string3.equals("prefix")) return;
                this.currentPrefix = this.value.toString();
                return;
            }
            if (string3.equals("component")) {
                if (this.currentComponent.name != null) {
                    ComponentInfo componentInfo;
                    if (this.currentComponent.prefix == null) {
                        this.currentComponent.prefix = this.currentPrefix;
                    }
                    if ((componentInfo = this.components.put(this.currentComponent.name, this.currentComponent)) != null) {
                        System.out.println("Duplicate component entry, " + this.currentComponent.name + ", found in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber());
                    }
                } else {
                    System.out.println("Missing name in " + this.locator.getSystemId() + " at line " + this.locator.getLineNumber());
                }
                this.currentComponent = null;
            } else if (string3.equals("name")) {
                if (this.currentComponent.name != null) throw new SAXParseException("Name already defined", this.locator);
                this.currentComponent.name = this.value.toString();
            } else if (string3.equals("prefix")) {
                if (this.currentComponent.prefix != null) throw new SAXParseException("Prefix already defined", this.locator);
                this.currentComponent.prefix = this.value.toString();
            } else if (string3.equals("class")) {
                if (this.currentComponent.implClazz != null) throw new SAXParseException("Class already defined", this.locator);
                this.currentComponent.implClazz = this.value.toString();
            } else {
                if (!string3.equals("factory")) throw new SAXParseException("Invalid tag: " + string3, this.locator);
                this.currentComponent.addFactory(this.value.toString());
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.currentComponent = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.components.clear();
            this.currentComponent = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    static class ComponentInfo {
        public String name;
        public Object implClazz;
        List factories;
        String prefix;

        ComponentInfo() {
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setImplementationClass(Object object) {
            this.implClazz = object;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getPackageUri(String string) {
            return this.prefix + string + ".xmi";
        }

        public void addFactories(Collection collection) {
            if (collection == null) {
                this.factories = new ArrayList(collection.size());
            }
            this.factories.addAll(collection);
        }

        public void addFactory(String string) {
            if (this.factories == null) {
                this.factories = new ArrayList(1);
            }
            this.factories.add(string);
        }

        public Component instantiate(ClassLoader classLoader, EObject eObject) {
            Class<?> clazz = null;
            try {
                if (this.implClazz instanceof Class) {
                    clazz = (Class<?>)this.implClazz;
                } else if (this.implClazz != null) {
                    this.implClazz = clazz = classLoader.loadClass((String)this.implClazz);
                }
                Component component = (Component)clazz.newInstance();
                return component;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName(), "276");
                Tr.error(tc, "WSVR0501E", new Object[]{this.implClazz, throwable});
                if (this.factories != null) {
                    for (int i = 0; i < this.factories.size(); ++i) {
                        Object object;
                        Object e = this.factories.get(i);
                        if (e instanceof String) {
                            try {
                                object = classLoader.loadClass((String)e);
                                ComponentFactory componentFactory = (ComponentFactory)((Class)object).newInstance();
                                this.factories.set(i, componentFactory);
                            }
                            catch (Throwable throwable2) {
                                this.factories.set(i, null);
                            }
                        }
                        if (!(e instanceof ComponentFactory) || (object = ((ComponentFactory)e).createComponent(eObject)) == null) continue;
                        return object;
                    }
                }
                return null;
            }
        }
    }
}

