/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import com.ibm.xslt4j.bcel.generic.ALOAD;
import com.ibm.xslt4j.bcel.generic.ASTORE;
import com.ibm.xslt4j.bcel.generic.ConstantPoolGen;
import com.ibm.xslt4j.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xslt4j.bcel.generic.InstructionConstants;
import com.ibm.xslt4j.bcel.generic.InstructionList;
import com.ibm.xslt4j.bcel.generic.LocalVariableGen;
import java.util.Vector;
import org.apache.xalan.xsltc.compiler.BooleanExpr;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralExpr;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.WithParam;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class CallTemplate
extends Instruction {
    private QName _name;
    private Object[] _parameters = null;
    private boolean _createTempVar = false;
    private Template _calleeTemplate = null;
    private com.ibm.xslt4j.bcel.generic.Instruction[] _oldLoadInstructions;

    CallTemplate() {
    }

    public void display(int indent) {
        this.indent(indent);
        System.out.print("CallTemplate");
        Util.println(" name " + this._name);
        this.displayContents(indent + 4);
    }

    public boolean hasWithParams() {
        return this.elementCount() > 0;
    }

    public void parseContents(Parser parser) {
        this._name = parser.getQNameIgnoreDefaultNs(this.getAttribute("name"));
        this.parseChildren(parser);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Template template = stable.lookupTemplate(this._name);
        if (template == null) {
            ErrorMsg err = new ErrorMsg("TEMPLATE_UNDEF_ERR", (Object)this._name, this);
            throw new TypeCheckError(err);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        Stylesheet stylesheet = classGen.getStylesheet();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (stylesheet.hasLocalParams() || this.hasContents()) {
            this._calleeTemplate = this.getCalleeTemplate();
            if (this._calleeTemplate != null) {
                this.buildParameterList();
            } else {
                int push = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "pushParamFrame", "()V");
                il.append(classGen.loadTranslet());
                il.append(new INVOKEVIRTUAL(push));
                this.translateContents(classGen, methodGen);
            }
        }
        String className = stylesheet.getClassName();
        String methodName = Util.escape(this._name.toString());
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadIterator());
        il.append(methodGen.loadHandler());
        il.append(methodGen.loadCurrentNode());
        String methodSig = "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xml/serializer/SerializationHandler;I";
        if (this._calleeTemplate != null) {
            Vector calleeParams = this._calleeTemplate.getParameters();
            int numParams = this._parameters.length;
            com.ibm.xslt4j.bcel.generic.Type objectType = null;
            if (this._createTempVar) {
                this._oldLoadInstructions = new com.ibm.xslt4j.bcel.generic.Instruction[numParams];
                objectType = Util.getJCRefType("Ljava/lang/Object;");
            }
            int i = 0;
            while (i < numParams) {
                methodSig = methodSig + "Ljava/lang/Object;";
                SyntaxTreeNode node = (SyntaxTreeNode)this._parameters[i];
                node.translate(classGen, methodGen);
                if (this._createTempVar) {
                    com.ibm.xslt4j.bcel.generic.Instruction oldInstruction;
                    Param param;
                    il.append(InstructionConstants.DUP);
                    String name = "call$template$" + Util.escape(this._name.toString()) + "$" + this.getParameterName(node);
                    LocalVariableGen local = methodGen.getLocalVariable(name);
                    if (local == null) {
                        local = methodGen.addLocalVariable2(name, objectType, il.getEnd());
                    }
                    il.append(new ASTORE(local.getIndex()));
                    if (node instanceof Param) {
                        param = (Param)node;
                        this._oldLoadInstructions[param.getIndex()] = oldInstruction = param.setLoadInstruction(new ALOAD(local.getIndex()));
                    } else if (node instanceof WithParam) {
                        param = (Param)calleeParams.elementAt(i);
                        this._oldLoadInstructions[param.getIndex()] = oldInstruction = param.setLoadInstruction(new ALOAD(local.getIndex()));
                    }
                }
                ++i;
            }
            if (this._createTempVar) {
                int i2 = 0;
                while (i2 < numParams) {
                    Param param = (Param)calleeParams.elementAt(i2);
                    param.setLoadInstruction(this._oldLoadInstructions[i2]);
                    ++i2;
                }
            }
        }
        methodSig = methodSig + ")V";
        il.append(new INVOKEVIRTUAL(cpg.addMethodref(className, methodName, methodSig)));
        if (this._calleeTemplate == null && (stylesheet.hasLocalParams() || this.hasContents())) {
            int pop = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "popParamFrame", "()V");
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(pop));
        }
    }

    private String getParameterName(SyntaxTreeNode node) {
        if (node instanceof Param) {
            return Util.escape(((Param)node).getName().toString());
        }
        if (node instanceof WithParam) {
            WithParam withParam = (WithParam)node;
            return Util.escape(withParam.getName().toString());
        }
        return null;
    }

    public Template getCalleeTemplate() {
        Stylesheet stylesheet = this.getStylesheet();
        Vector templates = stylesheet.getAllValidTemplates();
        int size = templates.size();
        int i = 0;
        while (i < size) {
            Template t = (Template)templates.elementAt(i);
            if (t.getName() == this._name && t.isSimpleNamedTemplate()) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private void buildParameterList() {
        Vector defaultParams = this._calleeTemplate.getParameters();
        int numParams = defaultParams.size();
        this._parameters = new Object[numParams];
        int i = 0;
        while (i < numParams) {
            this._parameters[i] = defaultParams.elementAt(i);
            ++i;
        }
        int count = this.elementCount();
        int i2 = 0;
        while (i2 < count) {
            Object node = this.elementAt(i2);
            if (node instanceof WithParam) {
                WithParam withParam = (WithParam)node;
                QName name = withParam.getName();
                int k = 0;
                while (k < numParams) {
                    Object object = this._parameters[k];
                    if (object instanceof Param && ((Param)object).getName() == name) {
                        withParam.setDoParameterOptimization(true);
                        this._parameters[k] = withParam;
                        break;
                    }
                    if (object instanceof WithParam && ((WithParam)object).getName() == name) {
                        withParam.setDoParameterOptimization(true);
                        this._parameters[k] = withParam;
                        break;
                    }
                    ++k;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < numParams) {
            Param param;
            Expression expr;
            if (!(!(this._parameters[i3] instanceof Param) || (expr = (param = (Param)this._parameters[i3]).getExpression()) == null && param.elementCount() == 0 || expr instanceof CastExpr && (((CastExpr)expr).getExpr() instanceof LiteralExpr || ((CastExpr)expr).getExpr() instanceof BooleanExpr))) {
                this._createTempVar = true;
                break;
            }
            ++i3;
        }
    }
}

