/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import com.ibm.xslt4j.bcel.generic.ConstantPoolGen;
import com.ibm.xslt4j.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xslt4j.bcel.generic.InstructionConstants;
import com.ibm.xslt4j.bcel.generic.InstructionList;
import com.ibm.xslt4j.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class WithParam
extends Instruction {
    private QName _name;
    private Expression _select;
    private boolean _doParameterOptimization = false;

    WithParam() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("with-param " + this._name);
        if (this._select != null) {
            this.indent(indent + 4);
            Util.println("select " + this._select.toString());
        }
        this.displayContents(indent + 4);
    }

    public QName getName() {
        return this._name;
    }

    public void setDoParameterOptimization(boolean flag) {
        this._doParameterOptimization = flag;
    }

    public void parseContents(Parser parser) {
        String name = this.getAttribute("name");
        if (name.length() > 0) {
            this._name = parser.getQName(name);
        } else {
            this.reportError(this, parser, "REQUIRED_ATTR_ERR", "name");
        }
        String select = this.getAttribute("select");
        if (select.length() > 0) {
            this._select = parser.parseExpression(this, "select", null);
        }
        this.parseChildren(parser);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._select != null) {
            Type tselect = this._select.typeCheck(stable);
            if (!(tselect instanceof ReferenceType)) {
                this._select = new CastExpr(this._select, Type.Reference);
            }
        } else {
            this.typeCheckContents(stable);
        }
        return Type.Void;
    }

    public void translateValue(ClassGenerator classGen, MethodGenerator methodGen) {
        if (this._select != null) {
            this._select.translate(classGen, methodGen);
            this._select.startResetIterator(classGen, methodGen);
        } else if (this.hasContents()) {
            this.compileResultTree(classGen, methodGen);
        } else {
            ConstantPoolGen cpg = classGen.getConstantPool();
            InstructionList il = methodGen.getInstructionList();
            il.append(new PUSH(cpg, ""));
        }
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this._doParameterOptimization) {
            this.translateValue(classGen, methodGen);
            return;
        }
        String name = Util.escape(this._name.getLocalPart());
        il.append(classGen.loadTranslet());
        il.append(new PUSH(cpg, name));
        this.translateValue(classGen, methodGen);
        il.append(new PUSH(cpg, false));
        il.append(new INVOKEVIRTUAL(cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "addParameter", "(Ljava/lang/String;Ljava/lang/Object;Z)Ljava/lang/Object;")));
        il.append(InstructionConstants.POP);
    }
}

