/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    ValidationState fValidationState = new ValidationState();
    private static final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    private StringBuffer fPattern = new StringBuffer();
    private final XSFacets xsFacets = new XSFacets();

    XSDAbstractTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        this.fSchemaHandler = xSDHandler;
        this.fAttrChecker = xSAttributeChecker;
    }

    void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fValidationState.setExtraChecking(false);
        this.fValidationState.setSymbolTable(symbolTable);
    }

    void traverseAnnotationDecl(Element element, Object[] objectArray, boolean bl, XSDocumentInfo xSDocumentInfo) {
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element, bl, xSDocumentInfo);
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = DOMUtil.getLocalName(element2);
            if (!string.equals(SchemaSymbols.ELT_APPINFO) && !string.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportSchemaError("src-annotation", null, element2);
            }
            objectArray2 = this.fAttrChecker.checkAttributes(element2, true, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
    }

    FacetInfo traverseFacets(Element element, XSSimpleType xSSimpleType, XSDocumentInfo xSDocumentInfo) {
        Object[] objectArray;
        int n = 0;
        short s = 0;
        boolean bl = this.containsQName(xSSimpleType);
        Vector<String> vector = new Vector<String>();
        Vector<NamespaceSupport> vector2 = bl ? new Vector<NamespaceSupport>() : null;
        int n2 = 0;
        while (element != null) {
            Object object;
            objectArray = null;
            String string = DOMUtil.getLocalName(element);
            if (string.equals(SchemaSymbols.ELT_ENUMERATION)) {
                Object object2;
                objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo, bl);
                object = (String)objectArray[XSAttributeChecker.ATTIDX_VALUE];
                NamespaceSupport namespaceSupport = (NamespaceSupport)objectArray[XSAttributeChecker.ATTIDX_ENUMNSDECLS];
                if (xSSimpleType.getVariety() == 1 && xSSimpleType.getPrimitiveKind() == 19) {
                    xSDocumentInfo.fValidationContext.setNamespaceSupport(namespaceSupport);
                    try {
                        object2 = (QName)fQNameDV.validate((String)object, (ValidationContext)xSDocumentInfo.fValidationContext, null);
                        this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 6, (QName)object2, element);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), element);
                    }
                    xSDocumentInfo.fValidationContext.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                }
                vector.addElement((String)object);
                if (bl) {
                    vector2.addElement(namespaceSupport);
                }
                if ((object2 = DOMUtil.getFirstChildElement(element)) != null) {
                    if (DOMUtil.getLocalName((Node)object2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl((Element)object2, objectArray, false, xSDocumentInfo);
                        object2 = DOMUtil.getNextSiblingElement((Node)object2);
                    }
                    if (object2 != null && DOMUtil.getLocalName((Node)object2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{"enumeration", "(annotation?)"}, (Element)object2);
                    }
                }
            } else if (string.equals(SchemaSymbols.ELT_PATTERN)) {
                objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
                if (this.fPattern.length() == 0) {
                    this.fPattern.append((String)objectArray[XSAttributeChecker.ATTIDX_VALUE]);
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append((String)objectArray[XSAttributeChecker.ATTIDX_VALUE]);
                    object = DOMUtil.getFirstChildElement(element);
                    if (object != null) {
                        if (DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl((Element)object, objectArray, false, xSDocumentInfo);
                            object = DOMUtil.getNextSiblingElement((Node)object);
                        }
                        if (object != null && DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.reportSchemaError("s4s-elt-must-match", new Object[]{"pattern", "(annotation?)"}, (Element)object);
                        }
                    }
                }
            } else {
                if (string.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    n2 = 2;
                } else if (string.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    n2 = 4;
                } else if (string.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    n2 = 64;
                } else if (string.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    n2 = 32;
                } else if (string.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    n2 = 128;
                } else if (string.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    n2 = 256;
                } else if (string.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    n2 = 512;
                } else if (string.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    n2 = 1024;
                } else if (string.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    n2 = 16;
                } else {
                    if (!string.equals(SchemaSymbols.ELT_LENGTH)) break;
                    n2 = 1;
                }
                objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
                if ((n & n2) != 0) {
                    this.reportSchemaError("src-single-facet-value", new Object[]{string}, element);
                } else if (objectArray[XSAttributeChecker.ATTIDX_VALUE] != null) {
                    n = (short)(n | n2);
                    if (((Boolean)objectArray[XSAttributeChecker.ATTIDX_FIXED]).booleanValue()) {
                        s = (short)(s | n2);
                    }
                    switch (n2) {
                        case 2: {
                            this.xsFacets.minLength = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 4: {
                            this.xsFacets.maxLength = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 64: {
                            this.xsFacets.maxExclusive = (String)objectArray[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 32: {
                            this.xsFacets.maxInclusive = (String)objectArray[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 128: {
                            this.xsFacets.minExclusive = (String)objectArray[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 256: {
                            this.xsFacets.minInclusive = (String)objectArray[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 512: {
                            this.xsFacets.totalDigits = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 1024: {
                            this.xsFacets.fractionDigits = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 16: {
                            this.xsFacets.whiteSpace = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).shortValue();
                            break;
                        }
                        case 1: {
                            this.xsFacets.length = ((XInt)objectArray[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                        }
                    }
                }
                object = DOMUtil.getFirstChildElement(element);
                if (object != null) {
                    if (DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl((Element)object, objectArray, false, xSDocumentInfo);
                        object = DOMUtil.getNextSiblingElement((Node)object);
                    }
                    if (object != null && DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{string, "(annotation?)"}, (Element)object);
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            element = DOMUtil.getNextSiblingElement(element);
        }
        if (vector.size() > 0) {
            n = (short)(n | 0x800);
            this.xsFacets.enumeration = vector;
            this.xsFacets.enumNSDecls = vector2;
        }
        if (this.fPattern.length() != 0) {
            n = (short)(n | 8);
            this.xsFacets.pattern = this.fPattern.toString();
        }
        this.fPattern.setLength(0);
        objectArray = new FacetInfo();
        objectArray.facetdata = this.xsFacets;
        objectArray.nodeAfterFacets = element;
        objectArray.fPresentFacets = (short)n;
        objectArray.fFixedFacets = s;
        return objectArray;
    }

    private boolean containsQName(XSSimpleType xSSimpleType) {
        if (xSSimpleType.getVariety() == 1) {
            short s = xSSimpleType.getPrimitiveKind();
            return s == 18 || s == 19;
        }
        if (xSSimpleType.getVariety() == 2) {
            return this.containsQName((XSSimpleType)xSSimpleType.getItemType());
        }
        if (xSSimpleType.getVariety() == 3) {
            XSObjectList xSObjectList = xSSimpleType.getMemberTypes();
            int n = 0;
            while (n < xSObjectList.getLength()) {
                if (this.containsQName((XSSimpleType)xSObjectList.item(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    Element traverseAttrsAndAttrGrps(Element element, XSAttributeGroupDecl xSAttributeGroupDecl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, XSComplexTypeDecl xSComplexTypeDecl) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Element element2 = null;
        XSAttributeGroupDecl xSAttributeGroupDecl2 = null;
        XSAttributeUseImpl xSAttributeUseImpl = null;
        element2 = element;
        while (element2 != null) {
            string = DOMUtil.getLocalName(element2);
            if (string.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                xSAttributeUseImpl = this.fSchemaHandler.fAttributeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar, xSComplexTypeDecl);
                if (xSAttributeUseImpl == null) break;
                if (xSAttributeGroupDecl.getAttributeUse(xSAttributeUseImpl.fAttrDecl.getNamespace(), xSAttributeUseImpl.fAttrDecl.getName()) == null) {
                    object3 = xSAttributeGroupDecl.addAttributeUse(xSAttributeUseImpl);
                    if (object3 != null) {
                        object2 = xSComplexTypeDecl == null ? "ag-props-correct.3" : "ct-props-correct.5";
                        object = xSComplexTypeDecl == null ? xSAttributeGroupDecl.fName : xSComplexTypeDecl.getName();
                        this.reportSchemaError((String)object2, new Object[]{object, xSAttributeUseImpl.fAttrDecl.getName(), object3}, element2);
                    }
                } else {
                    object3 = xSComplexTypeDecl == null ? "ag-props-correct.2" : "ct-props-correct.4";
                    object2 = xSComplexTypeDecl == null ? xSAttributeGroupDecl.fName : xSComplexTypeDecl.getName();
                    this.reportSchemaError((String)object3, new Object[]{object2, xSAttributeUseImpl.fAttrDecl.getName()}, element2);
                }
            } else {
                String string2;
                String string3;
                if (!string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (xSAttributeGroupDecl2 = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar)) == null) break;
                object3 = xSAttributeGroupDecl2.getAttributeUses();
                object2 = null;
                int n = object3.getLength();
                int n2 = 0;
                while (n2 < n) {
                    object = (XSAttributeUseImpl)object3.item(n2);
                    object2 = xSAttributeGroupDecl.getAttributeUse(((XSAttributeUseImpl)object).fAttrDecl.getNamespace(), ((XSAttributeUseImpl)object).fAttrDecl.getName());
                    if (object2 == null) {
                        string3 = xSAttributeGroupDecl.addAttributeUse((XSAttributeUseImpl)object);
                        if (string3 != null) {
                            this.reportSchemaError("cvc-complex-type.5.3", new Object[]{((XSAttributeUseImpl)object).fAttrDecl.getName(), string3}, element2);
                        }
                    } else {
                        string3 = xSComplexTypeDecl == null ? "ag-props-correct.2" : "ct-props-correct.4";
                        string2 = xSComplexTypeDecl == null ? xSAttributeGroupDecl.fName : xSComplexTypeDecl.getName();
                        this.reportSchemaError(string3, new Object[]{string2, ((XSAttributeUseImpl)object).fAttrDecl.getName()}, element2);
                    }
                    ++n2;
                }
                if (xSAttributeGroupDecl2.fAttributeWC != null) {
                    if (xSAttributeGroupDecl.fAttributeWC == null) {
                        xSAttributeGroupDecl.fAttributeWC = xSAttributeGroupDecl2.fAttributeWC;
                    } else {
                        xSAttributeGroupDecl.fAttributeWC = xSAttributeGroupDecl.fAttributeWC.performIntersectionWith(xSAttributeGroupDecl2.fAttributeWC, xSAttributeGroupDecl.fAttributeWC.fProcessContents);
                        if (xSAttributeGroupDecl.fAttributeWC == null) {
                            string3 = xSComplexTypeDecl == null ? "src-attribute_group.2" : "src-ct.4";
                            string2 = xSComplexTypeDecl == null ? xSAttributeGroupDecl.fName : xSComplexTypeDecl.getName();
                            this.reportSchemaError(string3, new Object[]{string2}, element2);
                        }
                    }
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 != null && (string = DOMUtil.getLocalName(element2)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            object3 = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(element2, xSDocumentInfo, schemaGrammar);
            if (xSAttributeGroupDecl.fAttributeWC == null) {
                xSAttributeGroupDecl.fAttributeWC = object3;
            } else {
                xSAttributeGroupDecl.fAttributeWC = ((XSWildcardDecl)object3).performIntersectionWith(xSAttributeGroupDecl.fAttributeWC, ((XSWildcardDecl)object3).fProcessContents);
                if (xSAttributeGroupDecl.fAttributeWC == null) {
                    object2 = xSComplexTypeDecl == null ? "src-attribute_group.2" : "src-ct.4";
                    object = xSComplexTypeDecl == null ? xSAttributeGroupDecl.fName : xSComplexTypeDecl.getName();
                    this.reportSchemaError((String)object2, new Object[]{object}, element2);
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        return element2;
    }

    void reportSchemaError(String string, Object[] objectArray, Element element) {
        this.fSchemaHandler.reportSchemaError(string, objectArray, element);
    }

    void checkNotationType(String string, XSTypeDefinition xSTypeDefinition, Element element) {
        if (xSTypeDefinition.getTypeCategory() == 14 && ((XSSimpleType)xSTypeDefinition).getVariety() == 1 && ((XSSimpleType)xSTypeDefinition).getPrimitiveKind() == 19 && (((XSSimpleType)xSTypeDefinition).getDefinedFacets() & 0x800) == 0) {
            this.reportSchemaError("enumeration-required-notation", new Object[]{string}, element);
        }
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl xSParticleDecl, String string, Element element, int n, long l) {
        boolean bl;
        int n2 = xSParticleDecl.fMinOccurs;
        int n3 = xSParticleDecl.fMaxOccurs;
        boolean bl2 = (l & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean bl3 = (l & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean bl4 = (n & 1) != 0;
        boolean bl5 = (n & 8) != 0;
        boolean bl6 = (n & 2) != 0;
        boolean bl7 = bl = (n & 4) != 0;
        if (bl) {
            Object[] objectArray;
            if (!bl2) {
                objectArray = new Object[]{string, "minOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", objectArray, element);
                n2 = 1;
            }
            if (!bl3) {
                objectArray = new Object[]{string, "maxOccurs"};
                this.reportSchemaError("s4s-att-not-allowed", objectArray, element);
                n3 = 1;
            }
        }
        if (n2 == 0 && n3 == 0) {
            xSParticleDecl.fType = 0;
            return null;
        }
        if (bl4) {
            if (n3 != 1) {
                this.reportSchemaError("cos-all-limited.2", null, element);
                n3 = 1;
                if (n2 > 1) {
                    n2 = 1;
                }
            }
        } else if ((bl5 || bl6) && n3 != 1) {
            this.reportSchemaError("cos-all-limited.1.2", null, element);
            if (n2 > 1) {
                n2 = 1;
            }
            n3 = 1;
        }
        xSParticleDecl.fMaxOccurs = n2;
        xSParticleDecl.fMaxOccurs = n3;
        return xSParticleDecl;
    }

    class FacetInfo {
        XSFacets facetdata;
        Element nodeAfterFacets;
        short fPresentFacets;
        short fFixedFacets;

        FacetInfo() {
        }
    }
}

