/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.CharKey;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;

public class CharInfo {
    private Hashtable m_charToEntityRef;
    public static String HTML_ENTITIES_RESOURCE = "org.apache.xml.serializer.HTMLEntities";
    public static String XML_ENTITIES_RESOURCE = "org.apache.xml.serializer.XMLEntities";
    public static final char S_LINEFEED = '\n';
    public static char S_CARRIAGERETURN = (char)13;
    public final boolean onlyQuotAmpLtGt;
    private static final int ASCII_MAX = 128;
    private boolean[] quickASCII;
    private boolean[] isCleanASCII;
    private int[] array_of_bits;
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed;
    private CharKey m_charKey;
    static /* synthetic */ Class class$org$apache$xml$serializer$CharInfo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CharInfo(String entitiesResource) {
        boolean noExtraEntities;
        block27: {
            int code;
            String value;
            String name;
            this.m_charToEntityRef = new Hashtable();
            this.quickASCII = new boolean[128];
            this.isCleanASCII = new boolean[128];
            this.array_of_bits = this.createEmptySetOfIntegers(65535);
            this.m_charKey = new CharKey();
            InputStream is = null;
            BufferedReader reader = null;
            noExtraEntities = true;
            PropertyResourceBundle entities = this.loadEntitiesResource(entitiesResource);
            if (null != entities) {
                Enumeration<String> enumeration = entities.getKeys();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        this.set(10);
                        this.set(S_CARRIAGERETURN);
                        break block27;
                    }
                    name = enumeration.nextElement();
                    value = entities.getString(name);
                    code = Integer.parseInt(value);
                    this.defineEntity(name, (char)code);
                    if (!this.extraEntity(code)) continue;
                    noExtraEntities = false;
                }
            }
            try {
                try {
                    try {
                        ClassLoader cl = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getClassLoader();
                        is = cl == null ? ClassLoader.getSystemResourceAsStream(entitiesResource) : cl.getResourceAsStream(entitiesResource);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (is == null) {
                        is = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getResourceAsStream(entitiesResource);
                    }
                    if (is == null) {
                        URL url = new URL(entitiesResource);
                        is = url.openStream();
                    }
                    if (is == null) {
                        throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{entitiesResource, entitiesResource}));
                    }
                    try {
                        reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        reader = new BufferedReader(new InputStreamReader(is));
                    }
                    String line = reader.readLine();
                    while (true) {
                        if (line == null) {
                            is.close();
                            this.set(10);
                            this.set(S_CARRIAGERETURN);
                            break;
                        }
                        if (line.length() == 0 || line.charAt(0) == '#') {
                            line = reader.readLine();
                            continue;
                        }
                        int index = line.indexOf(32);
                        if (index > 1) {
                            name = line.substring(0, index);
                            if (++index < line.length()) {
                                value = line.substring(index);
                                if ((index = value.indexOf(32)) > 0) {
                                    value = value.substring(0, index);
                                }
                                code = Integer.parseInt(value);
                                this.defineEntity(name, (char)code);
                                if (this.extraEntity(code)) {
                                    noExtraEntities = false;
                                }
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (Exception except) {
                    throw new RuntimeException(XMLMessages.createXMLMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{entitiesResource, except.toString(), entitiesResource, except.toString()}));
                }
                Object var13_16 = null;
                if (is == null) break block27;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception except) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception except) {}
            is.close();
        }
        this.onlyQuotAmpLtGt = noExtraEntities;
        int i = 0;
        while (true) {
            if (i >= 128) break;
            this.quickASCII[i] = this.get(i);
            ++i;
        }
        int ch = 0;
        while (ch < 128) {
            this.isCleanASCII[ch] = (32 <= ch || 10 == ch || 13 == ch || 9 == ch) && !this.get(ch) || 34 == ch;
            ++ch;
        }
        return;
    }

    protected void defineEntity(String name, char value) {
        CharKey character = new CharKey(value);
        this.m_charToEntityRef.put(character, name);
        this.set(value);
    }

    public synchronized String getEntityNameForChar(char value) {
        this.m_charKey.setChar(value);
        return (String)this.m_charToEntityRef.get(this.m_charKey);
    }

    public final boolean isSpecial(int value) {
        if (value < 128) {
            return this.quickASCII[value];
        }
        return this.get(value);
    }

    public final boolean isASCIIClean(int value) {
        return this.isCleanASCII[value];
    }

    public static CharInfo getCharInfo(String entitiesFileName) {
        CharInfo retobj = null;
        Hashtable getCharInfo_cache = HashtableHolder.m_getCharInfo_cache;
        retobj = (CharInfo)getCharInfo_cache.get(entitiesFileName);
        if (retobj == null) {
            try {
                retobj = new CharInfo(entitiesFileName);
                getCharInfo_cache.put(entitiesFileName, retobj);
            }
            catch (Exception e) {
                retobj = null;
            }
        }
        if (null == retobj) {
            String absoluteEntitiesFileName;
            if (entitiesFileName.indexOf(58) < 0) {
                absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName);
            } else {
                try {
                    absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                }
                catch (TransformerException te) {
                    throw new WrappedRuntimeException(te);
                }
            }
            retobj = new CharInfo(absoluteEntitiesFileName);
            getCharInfo_cache.put(entitiesFileName, retobj);
        }
        return retobj;
    }

    private PropertyResourceBundle loadEntitiesResource(String baseName) throws MissingResourceException {
        try {
            Locale locale = Locale.getDefault();
            ClassLoader loader = this.getClass().getClassLoader();
            return (PropertyResourceBundle)ResourceBundle.getBundle(baseName);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static int arrayIndex(int i) {
        return i >> 5;
    }

    private static int bit(int i) {
        int ret = 1 << (i & 0x1F);
        return ret;
    }

    private int[] createEmptySetOfIntegers(int max) {
        this.firstWordNotUsed = 0;
        int[] arr = new int[CharInfo.arrayIndex(max - 1) + 1];
        return arr;
    }

    private final void set(int i) {
        int j = i >> 5;
        int k = j + 1;
        if (this.firstWordNotUsed < k) {
            this.firstWordNotUsed = k;
        }
        int n = j;
        this.array_of_bits[n] = this.array_of_bits[n] | 1 << (i & 0x1F);
    }

    private final boolean get(int i) {
        boolean in_the_set = false;
        int j = i >> 5;
        if (j < this.firstWordNotUsed) {
            in_the_set = (this.array_of_bits[j] & 1 << (i & 0x1F)) != 0;
        }
        return in_the_set;
    }

    private CharInfo() {
        this.m_charToEntityRef = new Hashtable();
        this.quickASCII = new boolean[128];
        this.isCleanASCII = new boolean[128];
        this.array_of_bits = this.createEmptySetOfIntegers(65535);
        this.m_charKey = new CharKey();
        this.onlyQuotAmpLtGt = true;
    }

    private boolean extraEntity(int entityValue) {
        boolean extra = false;
        if (entityValue < 128) {
            switch (entityValue) {
                case 34: 
                case 38: 
                case 60: 
                case 62: {
                    break;
                }
                default: {
                    extra = true;
                }
            }
        }
        return extra;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HashtableHolder {
        private static Hashtable m_getCharInfo_cache = new Hashtable();

        private HashtableHolder() {
        }
    }
}

