/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int buf_length = 16384;
    private final OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream out) throws UnsupportedEncodingException {
        this.m_os = out;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5462];
        this.count = 0;
    }

    public void write(int c) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (c < 128) {
            this.m_outputBytes[this.count++] = (byte)c;
        } else if (c < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (c >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (c & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(224 + (c >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    private final void writeWithoutBuffering(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    private final void writeWithoutBuffering(String s) throws IOException {
        int n = s.length();
        OutputStream os = this.m_os;
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(char[] chars, int start, int length) throws IOException {
        char c;
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= 16384 - this.count) {
            this.flushBuffer();
            if (lengthx3 >= 16384) {
                this.writeWithoutBuffering(chars, start, length);
                return;
            }
        }
        int n = length + start;
        byte[] buf_loc = this.m_outputBytes;
        int count_loc = this.count;
        int i = start;
        while (i < n && (c = chars[i]) < '\u0080') {
            void var9_9;
            buf_loc[count_loc++] = (byte)var9_9;
            ++i;
        }
        while (i < n) {
            c = chars[i];
            if (c < '\u0080') {
                buf_loc[count_loc++] = (byte)c;
            } else if (c < '\u0800') {
                buf_loc[count_loc++] = (byte)(192 + (c >> 6));
                buf_loc[count_loc++] = (byte)(128 + (c & 0x3F));
            } else {
                buf_loc[count_loc++] = (byte)(224 + (c >> 12));
                buf_loc[count_loc++] = (byte)(128 + (c >> 6 & 0x3F));
                buf_loc[count_loc++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
        this.count = count_loc;
    }

    /*
     * WARNING - void declaration
     */
    public void write(String s) throws IOException {
        char c;
        int length = s.length();
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= 16384 - this.count) {
            this.flushBuffer();
            if (lengthx3 >= 16384) {
                this.writeWithoutBuffering(s);
                return;
            }
        }
        s.getChars(0, length, this.m_inputChars, 0);
        char[] chars = this.m_inputChars;
        int n = length;
        byte[] buf_loc = this.m_outputBytes;
        int count_loc = this.count;
        int i = 0;
        while (i < n && (c = chars[i]) < '\u0080') {
            void var9_9;
            buf_loc[count_loc++] = (byte)var9_9;
            ++i;
        }
        while (i < n) {
            c = chars[i];
            if (c < '\u0080') {
                buf_loc[count_loc++] = (byte)c;
            } else if (c < '\u0800') {
                buf_loc[count_loc++] = (byte)(192 + (c >> 6));
                buf_loc[count_loc++] = (byte)(128 + (c & 0x3F));
            } else {
                buf_loc[count_loc++] = (byte)(224 + (c >> 12));
                buf_loc[count_loc++] = (byte)(128 + (c >> 6 & 0x3F));
                buf_loc[count_loc++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
        this.count = count_loc;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void directWrite(String s) throws IOException {
        int length = s.length();
        int lengthx3 = (length << 1) + length;
        if (lengthx3 >= 16384 - this.count) {
            this.flushBuffer();
            if (lengthx3 >= 16384) {
                this.writeWithoutBuffering(s);
                return;
            }
        }
        s.getChars(0, length, this.m_inputChars, 0);
        char[] chars = this.m_inputChars;
        byte[] buf_loc = this.m_outputBytes;
        int count_loc = this.count;
        int i = 0;
        while (i < length) {
            buf_loc[count_loc++] = (byte)chars[i++];
        }
        this.count = count_loc;
    }
}

