/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.beans.beancontext.BeanContextServiceProvider;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WSSecurityClientComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private VariableMap varMap = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl = WSSecurityClientComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WSSecurityService;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl;

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        try {
            this.addService(class$com$ibm$ws$runtime$service$WSSecurityService == null ? (class$com$ibm$ws$runtime$service$WSSecurityService = WSSecurityClientComponentImpl.class$("com.ibm.ws.runtime.service.WSSecurityService")) : class$com$ibm$ws$runtime$service$WSSecurityService, (BeanContextServiceProvider)((Object)this));
            this.varMap = ClientVariableMap.getInstance();
            this._refresh();
            try {
                NonceManagerFactory.init(600L);
            }
            catch (SoapSecurityException soapSecurityException) {
                FFDCFilter.processException((Throwable)soapSecurityException, (String)((class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl = WSSecurityClientComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl).getName() + ".initialize"), (String)"114", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0126E", (Object)soapSecurityException);
            }
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, (String)(((Object)((Object)this)).getClass().getName() + ".initialize"), (String)"118", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.client.init.startfail", (Object)new Object[]{configurationError});
            throw configurationError;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".initialize"), (String)"122", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.client.init.startfail", (Object)new Object[]{exception});
            throw new ConfigurationError(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void refresh() throws RuntimeWarning {
        throw new RuntimeWarning(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.no.refresh"));
    }

    private void _refresh() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_refresh");
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
        try {
            String string = null;
            String string2 = null;
            Resource resource = null;
            Object object = null;
            String string3 = System.getProperty("wssecurity.defaultbindings.location");
            if (string3 != null && string3.length() > 0) {
                string = string3;
            }
            if (string != null) {
                Object object2;
                string2 = this.getFileURL(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Client xmlFileURL to load: " + string2));
                }
                try {
                    object2 = new WASResourceSetImpl();
                    resource = object2.getResource(URI.createURI((String)string2), true);
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.client.wssecurity.xml.notfound", (Object)new Object[]{string2});
                    FFDCFilter.processException((Throwable)exception, (String)((class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl = WSSecurityClientComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityClientComponentImpl")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityClientComponentImpl).getName() + "._refresh"), (String)"176", (Object)((Object)this));
                    String string4 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), string2);
                    throw new ConfigurationWarning(string4, (Throwable)exception);
                }
                if (resource == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.client.wssecurity.xml.notfound", (Object)new Object[]{string2});
                    object2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.wssecurity.xml.notfound"), string2);
                    throw new ConfigurationWarning((String)object2);
                }
                object2 = resource.getContents();
                object = object2.get(0);
                if (object != null && object instanceof WSSecurity) {
                    object2 = (WSSecurity)object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Loading the client-side ws-security.xml configuration, type = " + object.getClass().getName()));
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.client.wssecurity.xml", (Object)new Object[]{string2});
                    object2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.client.wssecurity.xml"), string2);
                    throw new ConfigurationError((String)object2);
                }
                this.loadConfig((WSSecurity)object2, wSSecurityDefaultConfiguration);
                wSSecurityDefaultConfiguration.keyStores.clear();
                wSSecurityDefaultConfiguration.certs.clear();
                this.config = wSSecurityDefaultConfiguration;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configuration: ", (Object)new Object[]{this.config});
            }
        }
        catch (Exception exception) {
            String string = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.client.loading.config"), exception.getMessage());
            throw new ConfigurationError("Exception loading config: " + exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_refresh");
        }
    }

    public String getFileURL(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = string2.startsWith("/") ? "file:" + string2 : "file:/" + string2;
        return string2;
    }

    public Object getConfig() {
        return this.config;
    }

    private void loadConfig(WSSecurity wSSecurity, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        CertStoreList certStoreList;
        EList eList;
        EList eList2;
        Object object;
        Object object2;
        TrustedIDEvaluator trustedIDEvaluator;
        Object object3;
        EList eList3;
        TrustAnchor trustAnchor;
        int n;
        EList eList4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadConfig", (Object)new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
        if ((eList4 = wSSecurity.getLoginMappings()) != null && !eList4.isEmpty()) {
            int n2 = eList4.size();
            for (n = 0; n < n2; ++n) {
                LoginMapping loginMapping = (LoginMapping)eList4.get(n);
                try {
                    trustAnchor = ConfigConstants.readLoginMapping(loginMapping, this.varMap);
                    wSSecurityDefaultConfiguration.loginMappings.put(trustAnchor.getAuthMethod(), trustAnchor);
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.loginmapping.failed", (Object)new Object[]{loginMapping.getAuthMethod(), throwable});
                }
            }
        }
        if ((eList3 = wSSecurity.getTrustAnchors()) != null && !eList3.isEmpty()) {
            n = eList3.size();
            for (int i = 0; i < n; ++i) {
                KeyStore keyStore;
                trustAnchor = (TrustAnchor)eList3.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Processing TrustAnchor: ", (Object)new Object[]{trustAnchor});
                }
                if ((keyStore = (KeyStore)wSSecurityDefaultConfiguration.keyStores.get(object3 = this.varMap.expand((trustedIDEvaluator = trustAnchor.getKeyStore()).getPath()))) == null) {
                    object2 = trustedIDEvaluator.getType();
                    object = trustedIDEvaluator.getStorepass().toCharArray();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Creating keystore instance " + (String)object3 + " of type " + (String)object2));
                    }
                    keyStore = new KeyStore((String)object2, (String)object3, (char[])object);
                    wSSecurityDefaultConfiguration.keyStores.put(object3, keyStore);
                }
                wSSecurityDefaultConfiguration.trustAnchors.put(trustAnchor.getName(), keyStore);
            }
        }
        if ((eList2 = wSSecurity.getTrustedIDEvaluators()) != null && !eList2.isEmpty()) {
            int n3 = eList2.size();
            for (int i = 0; i < n3; ++i) {
                trustedIDEvaluator = (TrustedIDEvaluator)eList2.get(i);
                try {
                    wSSecurityDefaultConfiguration.trustedIDEvaluators.put(trustedIDEvaluator.getName(), ConfigConstants.readTrustedIDEvaluator(trustedIDEvaluator, this.varMap));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.trustedidevaluator.failed", (Object)new Object[]{trustedIDEvaluator.getName(), throwable});
                }
            }
        }
        if ((eList = wSSecurity.getKeyLocators()) != null && !eList.isEmpty()) {
            int n4 = eList.size();
            for (int i = 0; i < n4; ++i) {
                object3 = (KeyLocator)eList.get(i);
                try {
                    wSSecurityDefaultConfiguration.keyLocators.put(object3.getName(), ConfigConstants.readKeyLocator(object3, this.varMap));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.keylocator.failed", (Object)new Object[]{object3.getName(), throwable});
                }
            }
        }
        if ((certStoreList = wSSecurity.getCertStoreList()) != null) {
            EList eList5;
            EList eList6 = certStoreList.getLdapCertStores();
            if (eList6 != null && !eList6.isEmpty()) {
                int n5 = eList6.size();
                for (int i = 0; i < n5; ++i) {
                    object2 = (LDAPCertStore)eList6.get(i);
                    try {
                        object = null;
                        object = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore((LDAPCertStore)object2, this.varMap);
                        wSSecurityDefaultConfiguration.certStores.put(object2.getName(), object);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.ldapcertstore.failed", (Object)new Object[]{object2.getName(), throwable});
                    }
                }
            }
            if ((eList5 = certStoreList.getCollectionCertStores()) != null && !eList5.isEmpty()) {
                int n6 = eList5.size();
                for (int i = 0; i < n6; ++i) {
                    object = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)eList5.get(i);
                    if (object == null) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.collectioncertstore.is.null");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Process CollectionCertStore: ", (Object)new Object[]{object});
                    }
                    String string = object.getProvider();
                    HashSet<java.security.cert.X509Certificate> hashSet = new HashSet<java.security.cert.X509Certificate>();
                    EList eList7 = object.getX509Certificates();
                    if (eList7 == null || eList7.isEmpty()) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.x509certificates.is.null");
                        continue;
                    }
                    String string2 = "Collection";
                    CollectionCertStoreParameters collectionCertStoreParameters = null;
                    try {
                        CertificateFactory certificateFactory = ConfigUtil.createCertificateFactory((String)"");
                        int n7 = eList7.size();
                        for (int j = 0; j < n7; ++j) {
                            X509Certificate x509Certificate = (X509Certificate)eList7.get(j);
                            String string3 = this.varMap.expand(x509Certificate.getPath());
                            if (string3 == null) {
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.cert.path.null", (Object)new Object[]{object.getName()});
                                continue;
                            }
                            java.security.cert.X509Certificate x509Certificate2 = (java.security.cert.X509Certificate)wSSecurityDefaultConfiguration.certs.get(string3);
                            if (x509Certificate2 == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Creating certificate: " + string3));
                                }
                                x509Certificate2 = ConfigUtil.getX509Certificate((File)new File(string3), (CertificateFactory)certificateFactory);
                                wSSecurityDefaultConfiguration.certs.put(string3, x509Certificate2);
                            }
                            hashSet.add(x509Certificate2);
                        }
                        collectionCertStoreParameters = new CollectionCertStoreParameters(hashSet);
                        CollectionCertStore collectionCertStore = null;
                        collectionCertStore = new CollectionCertStore(string2, collectionCertStoreParameters, string, object.getName());
                        wSSecurityDefaultConfiguration.certStores.put(object.getName(), collectionCertStore);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.collectioncertstore.failed", (Object)new Object[]{object.getName(), throwable});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadConfig", (Object)new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

