/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.WebServiceInit;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wssecurity.WSSecurity;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.KeyStore;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.core.WebServicesSecurityAdmin;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.Permission;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WSSecurityComponentImpl
extends ComponentImpl
implements WSSecurityService {
    private boolean ndEnvironment = false;
    private WSSecurityDefaultConfiguration config = new WSSecurityDefaultConfiguration();
    private WebServicesSecurityAdmin wssecAdmin = null;
    private Object lock = new Object();
    private boolean initialized = false;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl = WSSecurityComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityComponentImpl")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final Permission REFRESH_PERM = new WebSphereRuntimePermission("wssecurity.refreshConfig");
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Repository;
    static /* synthetic */ Class class$com$ibm$ws$security$service$SecurityService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WSSecurityService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$VariableMap;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl$WSSecurityListener;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl;

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering WebServicesSecurityAdmin MBean");
            }
            this.wssecAdmin = new WebServicesSecurityAdmin();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((Object)this.wssecAdmin, "WebServicesSecurityAdmin");
            mBeanFactory.activateMBean("WebServicesSecurityAdmin", (RuntimeCollaborator)defaultRuntimeCollaborator, mBeanFactory.getConfigId((Object)"WebServicesSecurityAdmin"), "com/ibm/ws/management/descriptor/xml/WebServicesSecurityAdmin.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebServicesSecurityAdmin MBean registered");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".initialize"), (String)"120", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.init.startfail", (Object)new Object[]{exception});
            throw new RuntimeError(ConfigConstants.getMessage("security.wssecurity.start.activate.failed"), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        try {
            Resource resource;
            WSSecurity wSSecurity;
            WSSecurity wSSecurity2;
            Repository repository;
            block22: {
                WebServiceInit.init();
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getProcessType();
                if (string == null || string.length() == 0) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.init.nullprocesstype");
                    throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.init.nullprocesstype"));
                }
                if (string.equals("ManagedProcess") || string.equals("DeploymentManager") || string.equals("NodeAgent")) {
                    this.ndEnvironment = true;
                }
                repository = null;
                ConfigRoot configRoot = null;
                wSSecurity2 = null;
                wSSecurity = null;
                try {
                    block21: {
                        repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = WSSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                        configRoot = repository.getConfigRoot();
                        if (this.ndEnvironment) {
                            resource = null;
                            try {
                                resource = configRoot.getResource(0, "ws-security.xml");
                            }
                            catch (Exception exception) {
                                String string2 = configRoot.getAbsolutePath(0, "ws-security.xml");
                                FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".initialize"), (String)"185", (Object)((Object)this));
                                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.load.cell.wssecurity.xml", (Object)new Object[]{string2});
                                throw new ConfigurationWarning(MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), string2), (Throwable)exception);
                            }
                            if (resource != null && (wSSecurity2 = (WSSecurity)resource.getContents().get(0)) != null && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Found document: " + configRoot.getAbsolutePath(0, "ws-security.xml")));
                            }
                        }
                        resource = null;
                        try {
                            resource = configRoot.getResource(4, "ws-security.xml");
                        }
                        catch (Exception exception) {
                            if (this.ndEnvironment) break block21;
                            String string3 = configRoot.getAbsolutePath(4, "ws-security.xml");
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Can not load server level configuration file: " + string3), (Object)new Object[]{exception});
                            }
                            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.load.server.wssecurity.xml", (Object)new Object[]{string3});
                        }
                    }
                    if (resource != null && (wSSecurity = (WSSecurity)resource.getContents().get(0)) != null && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found document: " + configRoot.getAbsolutePath(4, "ws-security.xml")));
                    }
                    Object var12_14 = null;
                    if (configRoot == null) break block22;
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (configRoot != null) {
                        this.releaseService(configRoot);
                    }
                    if (repository != null) {
                        this.releaseService(repository);
                    }
                    throw throwable;
                }
                this.releaseService(configRoot);
            }
            if (repository != null) {
                this.releaseService(repository);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cell WSSecurity: ", (Object)new Object[]{wSSecurity2});
                Tr.debug((TraceComponent)tc, (String)"Server WSSecurity: ", (Object)new Object[]{wSSecurity});
            }
            if ((resource = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? (class$com$ibm$ws$security$service$SecurityService = WSSecurityComponentImpl.class$("com.ibm.ws.security.service.SecurityService")) : class$com$ibm$ws$security$service$SecurityService)) == null) {
                throw new ConfigurationError(ConfigConstants.getMessage("security.wssecurity.secrutiyservice.isnull"));
            }
            resource.addListener((SecurityServiceListener)new WSSecurityListener(wSSecurity2, wSSecurity));
            this.addService(class$com$ibm$ws$runtime$service$WSSecurityService == null ? (class$com$ibm$ws$runtime$service$WSSecurityService = WSSecurityComponentImpl.class$("com.ibm.ws.runtime.service.WSSecurityService")) : class$com$ibm$ws$runtime$service$WSSecurityService);
        }
        catch (ConfigurationError configurationError) {
            FFDCFilter.processException((Throwable)configurationError, (String)(((Object)((Object)this)).getClass().getName() + ".initialize"), (String)"242", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.init.startfail", (Object)new Object[]{configurationError});
            throw configurationError;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConfig() {
        Object object = this.lock;
        synchronized (object) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(WSSecurity wSSecurity, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadConfig", (Object)new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
        VariableMap variableMap = null;
        try {
            CertStoreList certStoreList;
            EList eList;
            EList eList2;
            Object object;
            Object object2;
            TrustedIDEvaluator trustedIDEvaluator;
            Object object3;
            EList eList3;
            com.ibm.xml.soapsec.token.LoginMapping loginMapping;
            Object object4;
            variableMap = (VariableMap)this.getService(class$com$ibm$ws$runtime$service$VariableMap == null ? (class$com$ibm$ws$runtime$service$VariableMap = WSSecurityComponentImpl.class$("com.ibm.ws.runtime.service.VariableMap")) : class$com$ibm$ws$runtime$service$VariableMap);
            EList eList4 = wSSecurity.getProperties();
            if (eList4 != null) {
                String string;
                String string2;
                object4 = ConfigConstants.getProperties(eList4, variableMap);
                if (!this.initialized && (string2 = (String)object4.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout")) != null && (string2 = string2.trim()).length() != 0) {
                    try {
                        long l = Long.parseLong(string2);
                        wSSecurityDefaultConfiguration.nonceCacheTimeOut = ConfigConstants.validNonceCacheTimeOut(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, (String)(((Object)((Object)this)).getClass().getName() + ".loadConfig"), (String)"286", (Object)((Object)this));
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0115W", (Object)new Object[]{string2, new Integer(600)});
                        wSSecurityDefaultConfiguration.nonceCacheTimeOut = 600L;
                    }
                }
                if ((string2 = (String)object4.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge")) != null) {
                    wSSecurityDefaultConfiguration.nonceMaxAge = ConfigConstants.processNonceMaxAge(string2, wSSecurityDefaultConfiguration.nonceCacheTimeOut, 300L, 300L);
                }
                if ((string = (String)object4.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                    wSSecurityDefaultConfiguration.nonceClockSkew = ConfigConstants.processNonceClockSkew(string, wSSecurityDefaultConfiguration.nonceMaxAge, 0L, 0L);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Nonce cache timeout = " + wSSecurityDefaultConfiguration.nonceCacheTimeOut + ", Nonce max age = " + wSSecurityDefaultConfiguration.nonceMaxAge + ", Nonce clock skew = " + wSSecurityDefaultConfiguration.nonceClockSkew));
                }
            }
            if ((object4 = wSSecurity.getLoginMappings()) != null && !object4.isEmpty()) {
                int n = object4.size();
                for (int i = 0; i < n; ++i) {
                    LoginMapping loginMapping2 = (LoginMapping)object4.get(i);
                    try {
                        loginMapping = ConfigConstants.readLoginMapping(loginMapping2, variableMap);
                        wSSecurityDefaultConfiguration.loginMappings.put(loginMapping.getAuthMethod(), loginMapping);
                        this.processNonceBindings(loginMapping.getAuthMethod(), loginMapping.getProperties(), wSSecurityDefaultConfiguration);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.loginmapping.failed", (Object)new Object[]{loginMapping2.getAuthMethod(), throwable});
                    }
                }
            }
            if ((eList3 = wSSecurity.getTrustAnchors()) != null && !eList3.isEmpty()) {
                int n = eList3.size();
                for (int i = 0; i < n; ++i) {
                    KeyStore keyStore;
                    loginMapping = (TrustAnchor)eList3.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Processing TrustAnchor: ", (Object)new Object[]{loginMapping});
                    }
                    if ((keyStore = (KeyStore)wSSecurityDefaultConfiguration.keyStores.get(object3 = variableMap.expand((trustedIDEvaluator = loginMapping.getKeyStore()).getPath()))) == null) {
                        object2 = trustedIDEvaluator.getType();
                        object = trustedIDEvaluator.getStorepass().toCharArray();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Creating keystore instance " + (String)object3 + " of type " + (String)object2));
                        }
                        keyStore = new KeyStore((String)object2, (String)object3, (char[])object);
                        wSSecurityDefaultConfiguration.keyStores.put(object3, keyStore);
                    }
                    wSSecurityDefaultConfiguration.trustAnchors.put(loginMapping.getName(), keyStore);
                }
            }
            if ((eList2 = wSSecurity.getTrustedIDEvaluators()) != null && !eList2.isEmpty()) {
                int n = eList2.size();
                for (int i = 0; i < n; ++i) {
                    trustedIDEvaluator = (TrustedIDEvaluator)eList2.get(i);
                    try {
                        wSSecurityDefaultConfiguration.trustedIDEvaluators.put(trustedIDEvaluator.getName(), ConfigConstants.readTrustedIDEvaluator(trustedIDEvaluator, variableMap));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.trustedidevaluator.failed", (Object)new Object[]{trustedIDEvaluator.getName(), throwable});
                    }
                }
            }
            if ((eList = wSSecurity.getKeyLocators()) != null && !eList.isEmpty()) {
                int n = eList.size();
                for (int i = 0; i < n; ++i) {
                    object3 = (KeyLocator)eList.get(i);
                    try {
                        wSSecurityDefaultConfiguration.keyLocators.put(object3.getName(), ConfigConstants.readKeyLocator(object3, variableMap));
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.keylocator.failed", (Object)new Object[]{object3.getName(), throwable});
                    }
                }
            }
            if ((certStoreList = wSSecurity.getCertStoreList()) != null) {
                EList eList5;
                EList eList6 = certStoreList.getLdapCertStores();
                if (eList6 != null && !eList6.isEmpty()) {
                    int n = eList6.size();
                    for (int i = 0; i < n; ++i) {
                        object2 = (LDAPCertStore)eList6.get(i);
                        try {
                            object = null;
                            object = new com.ibm.ws.webservices.wssecurity.config.LDAPCertStore((LDAPCertStore)object2, variableMap);
                            wSSecurityDefaultConfiguration.certStores.put(object2.getName(), object);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.ldapcertstore.failed", (Object)new Object[]{object2.getName(), throwable});
                        }
                    }
                }
                if ((eList5 = certStoreList.getCollectionCertStores()) != null && !eList5.isEmpty()) {
                    int n = eList5.size();
                    for (int i = 0; i < n; ++i) {
                        object = (com.ibm.etools.webservice.wscommonbnd.CollectionCertStore)eList5.get(i);
                        if (object == null) {
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.collectioncertstore.is.null");
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Process CollectionCertStore: ", (Object)new Object[]{object});
                        }
                        String string = object.getProvider();
                        HashSet<java.security.cert.X509Certificate> hashSet = new HashSet<java.security.cert.X509Certificate>();
                        EList eList7 = object.getX509Certificates();
                        if (eList7 == null || eList7.isEmpty()) {
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.x509certificates.is.null");
                            continue;
                        }
                        String string3 = "Collection";
                        CollectionCertStoreParameters collectionCertStoreParameters = null;
                        try {
                            CertificateFactory certificateFactory = ConfigUtil.createCertificateFactory((String)"");
                            int n2 = eList7.size();
                            for (int j = 0; j < n2; ++j) {
                                X509Certificate x509Certificate = (X509Certificate)eList7.get(j);
                                String string4 = variableMap.expand(x509Certificate.getPath());
                                if (string4 == null) {
                                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.cert.path.null", (Object)new Object[]{object.getName()});
                                    continue;
                                }
                                java.security.cert.X509Certificate x509Certificate2 = (java.security.cert.X509Certificate)wSSecurityDefaultConfiguration.certs.get(string4);
                                if (x509Certificate2 == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Creating certificate: " + string4));
                                    }
                                    x509Certificate2 = ConfigUtil.getX509Certificate((File)new File(string4), (CertificateFactory)certificateFactory);
                                    wSSecurityDefaultConfiguration.certs.put(string4, x509Certificate2);
                                }
                                hashSet.add(x509Certificate2);
                            }
                            collectionCertStoreParameters = new CollectionCertStoreParameters(hashSet);
                            CollectionCertStore collectionCertStore = null;
                            collectionCertStore = new CollectionCertStore(string3, collectionCertStoreParameters, string, object.getName());
                            wSSecurityDefaultConfiguration.certStores.put(object.getName(), collectionCertStore);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.load.collectioncertstore.failed", (Object)new Object[]{object.getName(), throwable});
                        }
                    }
                }
            }
        }
        finally {
            if (variableMap != null) {
                this.releaseService(variableMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadConfig", (Object)new Object[]{wSSecurity, wSSecurityDefaultConfiguration});
        }
    }

    private void processNonceBindings(String string, Map map, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processNonceBindings");
        }
        if (bl = "BasicAuth".equals(string)) {
            String string2;
            String string3 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
            if (string3 != null) {
                wSSecurityDefaultConfiguration.nonceMaxAge = ConfigConstants.processNonceMaxAge(string3, wSSecurityDefaultConfiguration.nonceCacheTimeOut, 300L, 300L);
            }
            if ((string2 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew")) != null) {
                wSSecurityDefaultConfiguration.nonceClockSkew = ConfigConstants.processNonceClockSkew(string2, wSSecurityDefaultConfiguration.nonceMaxAge, 0L, 0L);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Nonce max age = " + wSSecurityDefaultConfiguration.nonceMaxAge + ", Nonce clock skew = " + wSSecurityDefaultConfiguration.nonceClockSkew));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNonceBindings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RuntimeWarning {
        Repository repository;
        block23: {
            SecurityManager securityManager;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"refresh");
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPermission(REFRESH_PERM);
            }
            repository = null;
            ConfigRoot configRoot = null;
            WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
            try {
                Object object;
                Resource resource;
                block22: {
                    repository = (Repository)this.getService(class$com$ibm$ws$runtime$service$Repository == null ? (class$com$ibm$ws$runtime$service$Repository = WSSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository")) : class$com$ibm$ws$runtime$service$Repository);
                    configRoot = repository.getConfigRoot();
                    if (this.ndEnvironment) {
                        resource = null;
                        try {
                            resource = configRoot.getResource(0, "ws-security.xml");
                        }
                        catch (Exception exception) {
                            String string = configRoot.getAbsolutePath(0, "ws-security.xml");
                            FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".refresh"), (String)"527", (Object)((Object)this));
                            String string2 = MessageFormat.format(ConfigConstants.getMessage("security.wssecurity.load.cell.wssecurity.xml"), string);
                            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.load.cell.wssecurity.xml", (Object)new Object[]{string});
                            throw new RuntimeWarning(string2, (Throwable)exception);
                        }
                        if (resource != null) {
                            object = (WSSecurity)resource.getContents().get(0);
                            if (object != null && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Loading the Cell level configuration: " + configRoot.getAbsolutePath(0, "ws-security.xml")));
                            }
                            this.loadConfig((WSSecurity)object, wSSecurityDefaultConfiguration);
                        }
                    }
                    resource = null;
                    try {
                        resource = configRoot.getResource(4, "ws-security.xml");
                    }
                    catch (Exception exception) {
                        if (this.ndEnvironment) break block22;
                        String string = configRoot.getAbsolutePath(4, "ws-security.xml");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Can not load server level configuration file: " + string), (Object)new Object[]{exception});
                        }
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.load.server.wssecurity.xml", (Object)new Object[]{string});
                    }
                }
                if (resource != null) {
                    object = (WSSecurity)resource.getContents().get(0);
                    if (object != null && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Loading the Server level configuration: " + configRoot.getAbsolutePath(4, "ws-security.xml")));
                    }
                    this.loadConfig((WSSecurity)object, wSSecurityDefaultConfiguration);
                }
                wSSecurityDefaultConfiguration.keyStores.clear();
                wSSecurityDefaultConfiguration.certs.clear();
                object = this.lock;
                synchronized (object) {
                    this.config = wSSecurityDefaultConfiguration;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configuration: ", (Object)new Object[]{this.config});
                }
                Object var11_13 = null;
                if (configRoot == null) break block23;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (configRoot != null) {
                    this.releaseService(configRoot);
                }
                if (repository != null) {
                    this.releaseService(repository);
                }
                throw throwable;
            }
            this.releaseService(configRoot);
        }
        if (repository != null) {
            this.releaseService(repository);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refresh");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WSSecurityListener
    implements SecurityServiceListener {
        private WSSecurity cell;
        private WSSecurity server;

        private WSSecurityListener(WSSecurity wSSecurity, WSSecurity wSSecurity2) {
            this.cell = wSSecurity;
            this.server = wSSecurity2;
        }

        public void stateChanged(SecurityServiceEvent securityServiceEvent) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stateChanged");
            }
            if (securityServiceEvent.getState() == 1) {
                WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
                if (WSSecurityComponentImpl.this.ndEnvironment && this.cell != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Loading the Cell level configuration");
                    }
                    WSSecurityComponentImpl.this.loadConfig(this.cell, wSSecurityDefaultConfiguration);
                }
                if (this.server != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Loading the Server level configuration");
                    }
                    WSSecurityComponentImpl.this.loadConfig(this.server, wSSecurityDefaultConfiguration);
                }
                wSSecurityDefaultConfiguration.keyStores.clear();
                wSSecurityDefaultConfiguration.certs.clear();
                WSSecurityComponentImpl.this.config = wSSecurityDefaultConfiguration;
                if (!WSSecurityComponentImpl.this.initialized) {
                    try {
                        NonceManagerFactory.init(((WSSecurityComponentImpl)WSSecurityComponentImpl.this).config.nonceCacheTimeOut);
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        FFDCFilter.processException((Throwable)soapSecurityException, (String)((class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl$WSSecurityListener == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl$WSSecurityListener = WSSecurityComponentImpl.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityComponentImpl$WSSecurityListener")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityComponentImpl$WSSecurityListener).getName() + ".stateChanged"), (String)"630", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0126E", (Object)soapSecurityException);
                    }
                }
                WSSecurityComponentImpl.this.initialized = true;
                if (WSSecurityComponentImpl.this.wssecAdmin != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"(Start) set WSSecurityService to WebServicesSecurityAdmin MBean");
                    }
                    WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(WSSecurityComponentImpl.this);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Configuration: ", (Object)new Object[]{WSSecurityComponentImpl.this.config});
                }
            } else if (securityServiceEvent.getState() == 2 && WSSecurityComponentImpl.this.wssecAdmin != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"(Stop) remove WSSecurityService from WebServicesSecurityAdmin MBean");
                }
                WSSecurityComponentImpl.this.wssecAdmin.setWSSecurityService(null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stateChanged");
            }
        }
    }
}

