/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.LDAPCertStore;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.token.LoginMapping;
import java.security.KeyStore;
import java.security.Permission;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.Map;

public class WSSecurityDefaultConfiguration {
    Map loginMappings = new HashMap();
    Map trustAnchors = new HashMap();
    Map trustedIDEvaluators = new HashMap();
    Map keyLocators = new HashMap();
    Map certStores = new HashMap();
    Map certs = new HashMap();
    Map keyStores = new HashMap();
    long nonceCacheTimeOut = 600L;
    long nonceMaxAge = 300L;
    long nonceClockSkew = 0L;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$core$WSSecurityDefaultConfiguration == null ? (class$com$ibm$ws$webservices$wssecurity$core$WSSecurityDefaultConfiguration = WSSecurityDefaultConfiguration.class$("com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration")) : class$com$ibm$ws$webservices$wssecurity$core$WSSecurityDefaultConfiguration), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission GETLOGINMAPPINGPERM = new WebSphereRuntimePermission("wssecurity.getLoginMapping");
    private static final WebSphereRuntimePermission GETTRUSTANCHORPERM = new WebSphereRuntimePermission("wssecurity.getTrustAnchor");
    private static final WebSphereRuntimePermission GETTRUSTEDIDEVALUATORPERM = new WebSphereRuntimePermission("wssecurity.getTrustedIDEvaluator");
    private static final WebSphereRuntimePermission GETKEYLOCATORPERM = new WebSphereRuntimePermission("wssecurity.getKeyLocator");
    private static final WebSphereRuntimePermission GETCERTSTOREPERM = new WebSphereRuntimePermission("wssecurity.getCertStore");
    private static final WebSphereRuntimePermission WSSECURITYCONFIGPERM = new WebSphereRuntimePermission("wssecurity.wssecurity.config");
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$core$WSSecurityDefaultConfiguration;

    protected WSSecurityDefaultConfiguration() {
    }

    public LoginMapping getLoginMapping(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLoginMapping", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)GETLOGINMAPPINGPERM);
        }
        LoginMapping loginMapping = (LoginMapping)this.loginMappings.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLoginMapping", (Object)loginMapping);
        }
        return loginMapping;
    }

    public KeyStore getTrustAnchor(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTrustAnchor", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)GETTRUSTANCHORPERM);
        }
        KeyStore keyStore = null;
        com.ibm.ws.webservices.wssecurity.config.KeyStore keyStore2 = (com.ibm.ws.webservices.wssecurity.config.KeyStore)this.trustAnchors.get(string);
        if (keyStore2 != null) {
            keyStore = keyStore2.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTrustAnchor", (Object)keyStore);
        }
        return keyStore;
    }

    public TrustedIDEvaluator getTrustedIDEvaluator(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTrustedIDEvaluator", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)GETTRUSTEDIDEVALUATORPERM);
        }
        TrustedIDEvaluator trustedIDEvaluator = (TrustedIDEvaluator)this.trustedIDEvaluators.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTrustedIDEvaluator", (Object)trustedIDEvaluator);
        }
        return trustedIDEvaluator;
    }

    public KeyLocator getKeyLocator(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyLocator", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)GETKEYLOCATORPERM);
        }
        KeyLocator keyLocator = (KeyLocator)this.keyLocators.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyLocator", (Object)keyLocator);
        }
        return keyLocator;
    }

    public CertStore getCertStore(String string) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCertStore", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)GETCERTSTOREPERM);
        }
        CertStore certStore = null;
        Object v = this.certStores.get(string);
        if (v != null) {
            if (v instanceof CollectionCertStore) {
                CollectionCertStore collectionCertStore = (CollectionCertStore)v;
                certStore = collectionCertStore.getInstance();
            } else if (v instanceof LDAPCertStore) {
                LDAPCertStore lDAPCertStore = (LDAPCertStore)v;
                certStore = lDAPCertStore.getInstance();
            } else {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.default.config.bad.certstore.class", (Object)new Object[]{string, v.getClass().getName()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCertStore", certStore);
        }
        return certStore;
    }

    public long getNonceCacheTimeout() {
        return this.nonceCacheTimeOut;
    }

    public long getDefaultNonceMaxAge() {
        return this.nonceMaxAge;
    }

    public long getDefaultNonceClockSkew() {
        return this.nonceClockSkew;
    }

    public String toString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)WSSECURITYCONFIGPERM);
        }
        return "Configuration( LoginMappings = " + this.loginMappings + " TrustAnchors = " + this.trustAnchors + " TrustedIDEvaluators = " + this.trustedIDEvaluators + " KeyLocators = " + this.keyLocators + " CertStores = " + this.certStores + " Nonce.cacheTimeout = " + this.nonceCacheTimeOut + " DefaultNonce.maxAge = " + this.nonceMaxAge + " DefaultNonce.clockSkew = " + this.nonceClockSkew + ")";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

