/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscext.LoginConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSEMFRequestSenderConfig
extends PrivateSenderConfig {
    private String wsseNS = Constants.NS_WSSE;
    private String wsuNS = Constants.NS_WSU;
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig == null ? (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig = WSEMFRequestSenderConfig.class$("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig")) : class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig == null ? (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig = WSEMFRequestSenderConfig.class$("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig")) : class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig).getName();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$handler$WSEMFRequestSenderConfig;

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI):", (Object)new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityService});
        }
        if (variableMap == null) {
            variableMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)wSSecurityService.getConfig();
        this.init(securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityDefaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSEMFRequestSenderConfig()");
        }
    }

    WSEMFRequestSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSEMFRequestSenderConfig()");
            Tr.exit((TraceComponent)tc, (String)"WSEMFRequestSenderConfig()");
        }
    }

    final void init(SecurityRequestSenderBindingConfig securityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig securityRequestSenderServiceConfig, String string, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        Object object;
        KeyEncryptionMethod keyEncryptionMethod;
        Object object2;
        BasicAuth basicAuth;
        String string2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ReferencePart referencePart;
        Reference reference;
        int n;
        String string3;
        ConfigValidation configValidation;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, WSSecurityDefaultConfiguration):", (Object)new Object[]{securityRequestSenderBindingConfig, securityRequestSenderServiceConfig, string, variableMap, wSSecurityDefaultConfiguration});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        LoginConfig loginConfig = null;
        IDAssertion iDAssertion = null;
        Map map = null;
        String string4 = null;
        if (securityRequestSenderServiceConfig != null) {
            confidentiality = securityRequestSenderServiceConfig.getConfidentiality();
            integrity = securityRequestSenderServiceConfig.getIntegrity();
            string4 = securityRequestSenderServiceConfig.getActor();
            loginConfig = securityRequestSenderServiceConfig.getLoginConfig();
            iDAssertion = securityRequestSenderServiceConfig.getIdAssertion();
            addCreatedTimeStamp = securityRequestSenderServiceConfig.getAddCreatedTimeStamp();
            configValidation = securityRequestSenderServiceConfig.getProperties();
            map = ConfigConstants.getProperties((EList)configValidation, variableMap);
            if (tc.isDebugEnabled()) {
                if (map != null) {
                    Tr.debug((TraceComponent)tc, (String)"Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp, Properties):", (Object)new Object[]{confidentiality, integrity, string4, loginConfig, iDAssertion, addCreatedTimeStamp, map});
                } else {
                    Tr.debug((TraceComponent)tc, (String)"Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp):", (Object)new Object[]{confidentiality, integrity, string4, loginConfig, iDAssertion, addCreatedTimeStamp});
                }
            }
        }
        if (!(configValidation = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration)).confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!configValidation.integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (!configValidation.idAssertionValid(iDAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (string != null) {
            string3 = string.trim();
            if (string3.length() != 0) {
                this.myactor = string3;
            }
        } else {
            this.myactor = null;
        }
        if (string4 != null) {
            string3 = string4.trim();
            if (string3.length() != 0) {
                this.targetactor = string3;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("actorURI = " + this.myactor + ", actor = " + this.targetactor));
        }
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string3 = addCreatedTimeStamp.getExpires();
            if (string3 != null && string3.length() > 0) {
                try {
                    this.duration = Duration.parse((String)string3);
                }
                catch (ParseException parseException) {
                    String string5 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, (String)(clsName + ".WSEMFRequestSenderConfig"), (String)"205", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)string5, (Object)string3);
                    throw SoapSecurityException.format(string5, string3, (Throwable)parseException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addCreatedTimeStamp = " + this.enableCreatedTimestamp + ", expires = " + addCreatedTimeStamp.getExpires() + ", duration = " + this.duration));
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                reference = (Reference)integrity.getReferences().get(n);
                referencePart = reference.getPart();
                object6 = referencePart.getName();
                this.integralParts.add(object6);
                if (!((String)object6).equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("integrity constraints = " + this.integralParts + "signed security token = " + this.isSecTokenSigned));
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                reference = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                referencePart = reference.getPart();
                object6 = referencePart.getName();
                this.confidentialParts.add(object6);
                if (!((String)object6).equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("confidentiality constraints = " + this.confidentialParts + "encrypt username token = " + this.isUsernameTokenEncrypted));
            }
        }
        if (iDAssertion != null) {
            this.idType = iDAssertion.getIdType();
            this.idType = this.idType == null ? this.idType : this.idType.trim();
            this.trustMode = iDAssertion.getTrustMode();
            String string6 = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IDType = " + this.idType + "Trust Mode = " + this.trustMode));
            }
        }
        this.nonceManager = NonceManagerFactory.getInstance();
        if (loginConfig != null) {
            this.authMethod = loginConfig.getAuthMethod().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuthMethod = " + this.authMethod));
            }
            if (map != null && !map.isEmpty()) {
                String string7 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce");
                if (string7 != null) {
                    if ((string7 = string7.trim()).length() != 0) {
                        this.addNonce = Boolean.valueOf(string7);
                        if (this.addNonce) {
                            if (!"BasicAuth".equals(this.authMethod)) {
                                this.addNonce = false;
                                this.addNonceTimestamp = false;
                                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0113W", (Object)new Object[]{this.authMethod});
                            } else {
                                this.addNonceTimestamp = true;
                            }
                        }
                    }
                } else {
                    this.addNonce = false;
                    this.addNonceTimestamp = false;
                }
                if ((string7 = (String)map.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp")) != null && (string7 = string7.trim()).length() != 0) {
                    this.addNonceTimestamp = Boolean.valueOf(string7);
                    if (this.addNonceTimestamp && !this.addNonce) {
                        this.addNonceTimestamp = false;
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0114W");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nonce enabled: " + this.addNonce + ", Nonce timestamp: " + this.addNonceTimestamp));
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        reference = null;
        referencePart = null;
        object6 = null;
        if (securityRequestSenderBindingConfig != null) {
            encryptionInfo = securityRequestSenderBindingConfig.getEncryptionInfo();
            eList = securityRequestSenderBindingConfig.getKeyLocators();
            reference = securityRequestSenderBindingConfig.getLoginBinding();
            referencePart = securityRequestSenderBindingConfig.getSigningInfo();
            object5 = securityRequestSenderBindingConfig.getProperties();
            if (object5 != null) {
                object6 = ConfigConstants.getProperties(object5, variableMap);
            }
            if (tc.isDebugEnabled()) {
                if (object6 != null) {
                    Tr.debug((TraceComponent)tc, (String)"Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo, Properties):", (Object)new Object[]{encryptionInfo, eList, reference, referencePart, object6});
                } else {
                    Tr.debug((TraceComponent)tc, (String)"Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo):", (Object)new Object[]{encryptionInfo, eList, reference, referencePart});
                }
            }
            if ((object6 != null || object6.size() != 0) && (object4 = (String)object6.get("com.ibm.ws.wssecurity.config.WSSE.Namespace")) != null && ((String)object4).length() != 0) {
                if (!NamespaceUtil.isWsse((String)object4)) {
                    throw new SoapSecurityException("Namespace " + (String)object4 + " is not supported");
                }
                this.wsseNS = object4;
                this.wsuNS = NamespaceUtil.getCorrespondingWSUNS((String)this.wsseNS);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS));
            }
        }
        if (!configValidation.senderSigningInfoValid((SigningInfo)referencePart, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!configValidation.encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!configValidation.loginBindingValid((LoginBinding)reference, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginBinding");
        }
        if (encryptionInfo != null) {
            object5 = encryptionInfo.getName();
            object4 = encryptionInfo.getEncryptionKey();
            object3 = null;
            string2 = null;
            if (object4 != null) {
                object3 = object4.getName();
                string2 = object4.getLocatorRef();
            }
            basicAuth = encryptionInfo.getEncryptionMethod();
            object2 = null;
            if (basicAuth != null) {
                object2 = basicAuth.getAlgorithm();
            }
            keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            String string8 = null;
            if (keyEncryptionMethod != null) {
                string8 = keyEncryptionMethod.getAlgorithm();
            }
            object = ConfigConstants.findKeyLocator(eList, string2, variableMap, wSSecurityDefaultConfiguration);
            if (object2 == null || object3 == null || object == null) {
                String string9 = "security.wssecurity.IncompleteEncryptionInfo";
                if (object2 == null) {
                    Tr.warning((TraceComponent)tc, (String)string9, (Object)"Data Encryption Algorithm");
                }
                if (object3 == null) {
                    Tr.warning((TraceComponent)tc, (String)string9, (Object)"Encryption Key Name");
                }
                if (object == null) {
                    Tr.warning((TraceComponent)tc, (String)string9, (Object)"Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings((String)object2, string8, (String)object3, (KeyLocator)object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encryption Info Name = " + (String)object5 + "Encryption Key Name = " + (String)object3 + "Encryption KeyLocatorRef = " + string2 + "Encryption Data Algorithm = " + (String)object2 + "Encryption Key Algorithm = " + string8));
            }
        }
        if (reference != null) {
            object5 = null;
            object4 = null;
            object3 = null;
            string2 = null;
            basicAuth = reference.getBasicAuth();
            if (basicAuth != null) {
                object4 = basicAuth.getUserid();
                object3 = basicAuth.getPassword().toCharArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Basic-Auth(" + (String)object4 + ", XXXXXXXX)"));
                }
            }
            if ((object2 = reference.getTokenValueType()) != null) {
                this.tokenValueType = new QName(object2.getUri(), object2.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TokenValue(" + object2.getUri() + ", " + object2.getLocalName() + ")"));
                }
            }
            object5 = reference.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CallbackHandler Class Name = " + (String)object5));
            }
            int n4 = reference.getProperties().size();
            for (int i = 0; i < n4; ++i) {
                object = (Property)reference.getProperties().get(i);
                if (variableMap == null) {
                    string2.put(object.getName(), object.getValue());
                } else {
                    string2.put(object.getName(), variableMap.expand(object.getValue()));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("CallbackHandler Properties = " + string2));
            }
            if (object5 != null) {
                try {
                    Class<?> clazz = Class.forName((String)object5);
                    object = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = WSEMFRequestSenderConfig.class$("java.lang.String")) : class$java$lang$String, array$C == null ? (array$C = WSEMFRequestSenderConfig.class$("[C")) : array$C, class$java$util$Map == null ? (class$java$util$Map = WSEMFRequestSenderConfig.class$("java.util.Map")) : class$java$util$Map);
                    this.callbackHandler = (CallbackHandler)((Constructor)object).newInstance(object4, object3, string2);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format(Constants.getQName((String)this.getWSSENS(), (String)"InvalidSecurity"), "security.wssecurity.RequestSenderConfig.token28", exception.toString());
                }
            }
        }
        if (referencePart != null) {
            object5 = referencePart.getCanonicalizationMethod();
            object4 = null;
            if (object5 == null) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.nocanonicalization.algo");
            } else {
                object4 = object5.getAlgorithm();
            }
            this.c14nMethod = object4;
            object3 = referencePart.getSignatureMethod();
            string2 = null;
            if (object3 == null) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.nosignature.algo");
            } else {
                string2 = object3.getAlgorithm();
            }
            this.signatureMethod = string2;
            basicAuth = referencePart.getDigestMethod();
            object2 = null;
            if (basicAuth == null) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.nodigest.algo");
            } else {
                object2 = basicAuth.getAlgorithm();
            }
            this.digestMethod = object2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Signature Canonicalization Algorithm = " + this.c14nMethod + "Signature Algorithm = " + this.signatureMethod + "Signature Digest Algorithm = " + this.digestMethod));
            }
            if ((keyEncryptionMethod = referencePart.getSigningKey()) != null) {
                String string10 = keyEncryptionMethod.getLocatorRef();
                this.keyName = keyEncryptionMethod.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Signature Keyname = " + this.keyName + "Signature KeyLocatorRef = " + string10));
                }
                this.keyLocator = ConfigConstants.findKeyLocator(eList, string10, variableMap, wSSecurityDefaultConfiguration);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

