/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.text.ParseException;
import org.eclipse.emf.common.util.EList;

public class WSEMFResponseSenderConfig
extends PrivateSenderConfig {
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig == null ? (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig = WSEMFResponseSenderConfig.class$("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig")) : class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig == null ? (class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig = WSEMFResponseSenderConfig.class$("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig")) : class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig).getName();
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$handler$WSEMFResponseSenderConfig;

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityService wSSecurityService) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService):", (Object)new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityService});
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)wSSecurityService.getConfig();
        this.init(securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityDefaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSEMFResponseSenderConfig()");
        }
    }

    WSEMFResponseSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSEMFResponseSenderConfig()");
            Tr.exit((TraceComponent)tc, (String)"WSEMFResponseSenderConfig()");
        }
    }

    final void init(SecurityResponseSenderBindingConfig securityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig securityResponseSenderServiceConfig, String string, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        String string2;
        KeyEncryptionMethod keyEncryptionMethod;
        String string3;
        DataEncryptionMethod dataEncryptionMethod;
        String string4;
        String string5;
        String string6;
        Object object;
        Reference reference;
        int n;
        String string7;
        ConfigValidation configValidation;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityDefaultConfiguration):", (Object)new Object[]{securityResponseSenderBindingConfig, securityResponseSenderServiceConfig, string, variableMap, wSSecurityDefaultConfiguration});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        String string8 = null;
        if (securityResponseSenderServiceConfig != null) {
            addCreatedTimeStamp = securityResponseSenderServiceConfig.getAddCreatedTimestamp();
            confidentiality = securityResponseSenderServiceConfig.getConfidentiality();
            integrity = securityResponseSenderServiceConfig.getIntegrity();
            string8 = securityResponseSenderServiceConfig.getActor();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response Sender Service Config (AddCreatedTimestamp, Confidentiality, Integrity, targetActor):", (Object)new Object[]{addCreatedTimeStamp, confidentiality, integrity, string8});
            }
        }
        if (!(configValidation = new ConfigValidation(variableMap, wSSecurityDefaultConfiguration)).confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!configValidation.integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (string != null) {
            string7 = string.trim();
            if (string7.length() != 0) {
                this.myactor = string7;
            }
        } else {
            this.myactor = null;
        }
        if (string8 != null) {
            string7 = string8.trim();
            if (string7.length() != 0) {
                this.targetactor = string7;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("actorURI = " + this.myactor + ", actor = " + this.targetactor));
        }
        this.enableCreatedTimestamp = false;
        this.duration = null;
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            string7 = addCreatedTimeStamp.getExpires();
            if (string7 != null && string7.length() > 0) {
                try {
                    this.duration = Duration.parse((String)string7);
                }
                catch (ParseException parseException) {
                    String string9 = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)parseException, (String)(clsName + ".WSEMFResponseSenderConfig"), (String)"178", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)string9, (Object)string7);
                    throw SoapSecurityException.format(string9, string7, (Throwable)parseException);
                }
            }
        }
        if (integrity != null) {
            int n2 = integrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                reference = (Reference)integrity.getReferences().get(n);
                object = reference.getPart();
                string6 = object.getName();
                this.integralParts.add(string6);
                if (!string6.equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
        }
        if (confidentiality != null) {
            int n3 = confidentiality.getConfidentialParts().size();
            for (n = 0; n < n3; ++n) {
                reference = (ConfidentialPart)confidentiality.getConfidentialParts().get(n);
                object = reference.getPart();
                string6 = object.getName();
                this.confidentialParts.add(string6);
                if (!string6.equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList eList = null;
        reference = null;
        if (securityResponseSenderBindingConfig != null) {
            encryptionInfo = securityResponseSenderBindingConfig.getEncryptionInfo();
            eList = securityResponseSenderBindingConfig.getKeyLocators();
            reference = securityResponseSenderBindingConfig.getSigningInfo();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo):", (Object)new Object[]{encryptionInfo, eList, reference});
            }
        }
        if (!configValidation.senderSigningInfoValid((SigningInfo)reference, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!configValidation.encryptionInfoValid(encryptionInfo, eList, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (encryptionInfo != null) {
            object = encryptionInfo.getName();
            string6 = encryptionInfo.getEncryptionKey();
            string5 = null;
            string4 = null;
            if (string6 != null) {
                string5 = string6.getName();
                string4 = string6.getLocatorRef();
            }
            dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            string3 = null;
            if (dataEncryptionMethod != null) {
                string3 = dataEncryptionMethod.getAlgorithm();
            }
            keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            string2 = null;
            if (keyEncryptionMethod != null) {
                string2 = keyEncryptionMethod.getAlgorithm();
            }
            KeyLocator keyLocator = ConfigConstants.findKeyLocator(eList, string4, variableMap, wSSecurityDefaultConfiguration);
            if (string3 == null || string5 == null || keyLocator == null) {
                String string10 = "security.wssecurity.IncompleteEncryptionInfo";
                if (string3 == null) {
                    Tr.warning((TraceComponent)tc, (String)string10, (Object)"Data Encryption Algorithm");
                }
                if (string5 == null) {
                    Tr.warning((TraceComponent)tc, (String)string10, (Object)"Encryption Key Name");
                }
                if (keyLocator == null) {
                    Tr.warning((TraceComponent)tc, (String)string10, (Object)"Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings(string3, string2, string5, keyLocator);
        }
        if (reference != null) {
            object = reference.getCanonicalizationMethod();
            string6 = null;
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No CanonicalizationMethod defined");
                }
            } else {
                string6 = object.getAlgorithm();
            }
            this.c14nMethod = string6;
            string5 = reference.getSignatureMethod();
            string4 = null;
            if (string5 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No SignatureMethod defined");
                }
            } else {
                string4 = string5.getAlgorithm();
            }
            this.signatureMethod = string4;
            dataEncryptionMethod = reference.getDigestMethod();
            string3 = null;
            if (dataEncryptionMethod == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No DigestMethod defined");
                }
            } else {
                string3 = dataEncryptionMethod.getAlgorithm();
            }
            this.digestMethod = string3;
            keyEncryptionMethod = reference.getSigningKey();
            if (keyEncryptionMethod != null) {
                string2 = keyEncryptionMethod.getLocatorRef();
                this.keyName = keyEncryptionMethod.getName();
                this.keyLocator = ConfigConstants.findKeyLocator(eList, string2, variableMap, wSSecurityDefaultConfiguration);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSEMFResponseSenderConfig()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

