/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

class NonceCache
implements AlarmListener {
    private Hashtable table;
    private Hashtable secondaryTable;
    private Hashtable tertiaryTable;
    private int minSize = 0;
    private boolean wipeCache;
    private Alarm defaultAlarm;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache = NonceCache.class$("com.ibm.ws.webservices.wssecurity.handler.token.NonceCache")) : class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = (class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache = NonceCache.class$("com.ibm.ws.webservices.wssecurity.handler.token.NonceCache")) : class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache).getName();
    private static final String comp = "security.wssecurity";
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$handler$token$NonceCache;

    public NonceCache(int n, long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("NonceCache(" + n + ", " + l + ", " + bl + ")"));
        }
        this.defaultAlarm = new Alarm(l);
        this.table = new Hashtable(n);
        this.secondaryTable = new Hashtable(n);
        this.tertiaryTable = new Hashtable(n);
        this.minSize = n;
        this.wipeCache = bl;
        this.addAlarmListener(this, l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NonceCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contains");
            StringBuffer stringBuffer = new StringBuffer("Key = ");
            stringBuffer.append(object.toString());
            stringBuffer.append(", key class is ");
            stringBuffer.append(object.getClass().getName());
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
        boolean bl = true;
        Hashtable hashtable = null;
        Entry entry = (Entry)this.table.get(object);
        if (entry == null) {
            entry = (Entry)this.secondaryTable.get(object);
            if (entry == null) {
                entry = (Entry)this.tertiaryTable.get(object);
                if (entry != null) {
                    hashtable = this.tertiaryTable;
                }
            } else {
                hashtable = this.secondaryTable;
            }
            if (entry == null) {
                Hashtable hashtable2 = this.table;
                synchronized (hashtable2) {
                    if (tc.isEntryEnabled() && (this.table.size() + this.secondaryTable.size() + this.tertiaryTable.size()) % 100 == 0) {
                        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
                        stringBuffer.append(" number of entries: ");
                        stringBuffer.append(this.table.size() + this.secondaryTable.size() + this.tertiaryTable.size());
                        Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                    }
                    if ((entry = (Entry)this.table.get(object)) == null) {
                        entry = new Entry();
                        entry.value = new Date();
                        entry.marked = false;
                        this.table.put(object, entry);
                        bl = false;
                    }
                }
            } else {
                this.table.put(object, entry);
                hashtable.remove(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("contains returns " + bl));
        }
        return bl;
    }

    protected void mark() {
        if (this.wipeCache) {
            this.tertiaryTable.clear();
        } else {
            this.tertiaryTable.putAll(this.secondaryTable);
        }
        this.secondaryTable = this.table;
        this.table = new Hashtable(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size() + 100);
    }

    public void alarm(Object object) {
        long l = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this.table.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this.secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this.tertiaryTable.size());
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    private void addAlarmListener(AlarmListener alarmListener, long l) {
        if (l == this.defaultAlarm.getTimeout()) {
            this.defaultAlarm.addAlarmListener(alarmListener);
        } else {
            Alarm alarm = new Alarm(l);
            alarm.addAlarmListener(alarmListener);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        public Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.create((long)this.timeout, (AlarmListener)this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }

    private class Entry {
        public Object value;
        public boolean marked = false;
        public int timesAccessed;
    }
}

