/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.handler.token.ByteArray;
import com.ibm.ws.webservices.wssecurity.handler.token.NonceCache;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.text.MessageFormat;

public class WSNonceManagerImpl
implements NonceManager {
    private static final String clsName = (class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl = WSNonceManagerImpl.class$("com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl")) : class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl).getName();
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl = WSNonceManagerImpl.class$("com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl")) : class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.wssecurity.util.nonceCacheSize";
    private static final int DEFAULT_CACHE_SIZE = 1024;
    private static final int DEFAULT_MIN_CACHE_SIZE = 16;
    private static final String NONCE_LENGTH_KEY = "com.ibm.websphere.wssecurity.util.nonceLength";
    private static final int DEFAULT_NONCE_LENGTH = 128;
    private static final int DEFAULT_MIN_NONCE_LENGTH = 16;
    private SecureRandom random = null;
    private boolean bServer = false;
    private NonceCache cache = null;
    private int nonceLength = 128;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl;

    public WSNonceManagerImpl(long l) throws SoapSecurityException {
        int n;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("WSNonceManagerImpl(" + l + ")"));
        }
        this.bServer = ContextManagerFactory.getInstance().processIsServer();
        if (this.bServer) {
            string = System.getProperty(NONCE_CACHE_SIZE_KEY);
            n = 1024;
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 <= 16) {
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0124W", (Object)new Object[]{string, new Integer(16), new Integer(1024)});
                        n = 1024;
                    } else {
                        n = n2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Nonce cache size from system property (com.ibm.websphere.wssecurity.util.nonceCacheSize) = " + n));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)((class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl = WSNonceManagerImpl.class$("com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl")) : class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl).getName() + ".WSNonceManagerImpl"), (String)"65", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_CACHE_SIZE_KEY, string, new Integer(1024)});
                }
            }
            this.cache = new NonceCache(n, l * 1000L, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server process: enabled NonceCache");
            }
        }
        if ((string = System.getProperty(NONCE_LENGTH_KEY)) != null && (string = string.trim()).length() != 0) {
            try {
                n = Integer.parseInt(string);
                if (n <= 16) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0127W", (Object)new Object[]{string, new Integer(16), new Integer(128)});
                    this.nonceLength = 128;
                } else {
                    this.nonceLength = n;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Nonce length from system property (com.ibm.websphere.wssecurity.util.nonceLength) = " + this.nonceLength));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)((class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl == null ? (class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl = WSNonceManagerImpl.class$("com.ibm.ws.webservices.wssecurity.handler.token.WSNonceManagerImpl")) : class$com$ibm$ws$webservices$wssecurity$handler$token$WSNonceManagerImpl).getName() + ".WSNonceManagerImpl"), (String)"94", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_LENGTH_KEY, string, new Integer(128)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce length = " + this.nonceLength));
        }
        this.initSecureRandom();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSNonceManagerImpl");
        }
    }

    public boolean validate(byte[] byArray) throws SoapSecurityException {
        boolean bl;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        if (byArray == null || byArray.length == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0121E");
            throw SoapSecurityException.format("security.wssecurity.WSEC0121E");
        }
        if (this.cache == null) {
            String string = this.bServer ? ".WSEC0122E" : ".WSEC0123E";
            Tr.error((TraceComponent)tc, (String)(comp + string));
            throw SoapSecurityException.format(comp + string);
        }
        if (tc.isDebugEnabled()) {
            object = new ByteArrayOutputStream();
            ((ByteArrayOutputStream)object).write(byArray, 0, byArray.length);
            Tr.debug((TraceComponent)tc, (String)"validating ", (Object)((ByteArrayOutputStream)object).toString());
        }
        boolean bl2 = bl = !this.cache.contains(object = new ByteArray(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validate returns " + bl));
        }
        return bl;
    }

    public byte[] generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generate");
        }
        byte[] byArray = null;
        if (this.random != null) {
            byArray = new byte[this.nonceLength];
            this.random.nextBytes(byArray);
            if (tc.isEntryEnabled()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                Tr.exit((TraceComponent)tc, (String)"generate", (Object)byteArrayOutputStream.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No random number generator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"generate returns null");
            }
        }
        return byArray;
    }

    private void initSecureRandom() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initSecureRandom");
        }
        String string = Security.getProperty(DEFAULT_JCE_PROVIDER);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is " + string));
        }
        if (string == null || string.length() == 0) {
            string = IBMJCE;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is null, force to use: " + string));
            }
        }
        try {
            this.random = SecureRandom.getInstance(IBMSEC_RANDOM, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = "security.wssecurity.WSEC5195E";
            Tr.error((TraceComponent)tc, (String)string2, (Object)new Object[]{IBMSEC_RANDOM, string, noSuchAlgorithmException});
            String string3 = MessageFormat.format(ConfigUtil.getMessage((String)string2), IBMSEC_RANDOM, string, noSuchAlgorithmException.toString());
            throw new SoapSecurityException(string3, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string4 = "security.wssecurity.WSEC5195E";
            Tr.error((TraceComponent)tc, (String)string4, (Object)new Object[]{IBMSEC_RANDOM, string, noSuchProviderException});
            String string5 = MessageFormat.format(ConfigUtil.getMessage((String)string4), IBMSEC_RANDOM, string, noSuchProviderException.toString());
            throw new SoapSecurityException(string5, noSuchProviderException);
        }
        byte[] byArray = new byte[this.nonceLength];
        this.random.nextBytes(byArray);
        this.random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        this.random.nextBytes(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initSecureRandom");
        }
    }

    public String toString() {
        return clsName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

