/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.webservices.engine.MessageContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import org.omg.Security.InvalidCredentialType;
import org.omg.SecurityLevel2.InvalidCredential;

public final class CORBAHelper {
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final HashMap originalCallerSubject = new HashMap();
    private static final HashMap originalInvocationSubject = new HashMap();
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper == null ? (class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper = CORBAHelper.class$("com.ibm.ws.webservices.wssecurity.util.CORBAHelper")) : class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String FFDC_SOURCE_ID = "com.ibm.ws.webservices.wssecurity.util.CORBAHelper";
    private static SecurityServer securityServer = null;
    private static final Permission MAP_CREDENTIAL;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper;
    static /* synthetic */ Class class$com$ibm$ws$security$server$SecurityServer;

    public static boolean isSecurityEnabled() {
        return SecurityContext.isSecurityEnabled();
    }

    public static synchronized void pushCredential(Subject subject, MessageContext messageContext) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pushCredential(" + subject + ", " + messageContext + ")"));
        }
        if (contextManager != null && contextManager.isCellSecurityEnabled()) {
            try {
                Subject subject2 = contextManager.getInvocationSubject();
                Subject subject3 = contextManager.getCallerSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Original Caller Subject", (Object)subject3);
                    Tr.debug((TraceComponent)tc, (String)"Original Invocation Subject", (Object)subject2);
                    Tr.debug((TraceComponent)tc, (String)"Replace Caller and Invocation Subjects with", (Object)subject);
                }
                contextManager.setInvocationSubject(subject);
                contextManager.setCallerSubject(subject);
                originalInvocationSubject.put(messageContext, subject2);
                originalCallerSubject.put(messageContext, subject3);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)((class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper == null ? (class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper = CORBAHelper.class$(FFDC_SOURCE_ID)) : class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper).getName() + ".pushCredential()"), (String)"143");
                if (tc.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    wSSecurityException.printStackTrace(new PrintWriter(stringWriter));
                    Tr.debug((TraceComponent)tc, (String)("Exception in set Caller/Invocation Subject" + stringWriter.toString()));
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pushCredential()");
        }
    }

    public static synchronized void popCredential(MessageContext messageContext) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("popCredential(" + messageContext + ")"));
        }
        if (contextManager != null && contextManager.isCellSecurityEnabled()) {
            Subject subject = (Subject)originalCallerSubject.remove(messageContext);
            Subject subject2 = (Subject)originalInvocationSubject.remove(messageContext);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Original caller subject", (Object)subject);
                Tr.debug((TraceComponent)tc, (String)"Original Invocation Subject", (Object)subject2);
            }
            try {
                contextManager.setCallerSubject(subject);
                contextManager.setInvocationSubject(subject2);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)((class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper == null ? (class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper = CORBAHelper.class$(FFDC_SOURCE_ID)) : class$com$ibm$ws$webservices$wssecurity$util$CORBAHelper).getName() + ".pushCredential()"), (String)"176");
                if (tc.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    wSSecurityException.printStackTrace(new PrintWriter(stringWriter));
                    Tr.debug((TraceComponent)tc, (String)("Exception in set Caller/Invocation Subject" + stringWriter.toString()));
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"popCredential()");
        }
    }

    public static String getSecurityName() {
        String string;
        block18: {
            WSCredential wSCredential;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"getSecurityName()");
                }
                string = null;
                wSCredential = null;
                try {
                    wSCredential = contextManager.getInvocationCredential();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Invocation creds = " + (wSCredential == null ? "null" : wSCredential.toString())));
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    string = null;
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)FFDC_SOURCE_ID, (String)"313");
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug((TraceComponent)tc, (String)("Error in getting security name from credential " + wSSecurityException.toString()));
                }
            }
            try {
                if (wSCredential != null) {
                    string = wSCredential.getRealmSecurityName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Invocation creds securityName = " + string));
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Try getting the principal from received creds");
                    }
                    WSCredential[] wSCredentialArray = contextManager.getCallerCredentials();
                    wSCredential = null;
                    if (wSCredentialArray != null && wSCredentialArray.length != 0) {
                        wSCredential = wSCredentialArray[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Received cred = " + wSCredential));
                        }
                        if (wSCredential != null) {
                            string = wSCredential.getRealmSecurityName();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Received cred securityName = " + string));
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Received creds = null");
                    }
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                string = null;
                FFDCFilter.processException((Throwable)generalSecurityException, (String)FFDC_SOURCE_ID, (String)"351");
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug((TraceComponent)tc, (String)"Error in getting security name from credential ", (Object)generalSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityName() --> " + string));
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (contextManager.isCellSecurityEnabled()) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to get initial naming context");
                }
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.getting.initialctx.error", (Object)new Object[]{namingException});
            }
            if (initialContext != null) {
                try {
                    Object object = initialContext.lookup("SecurityServer");
                    securityServer = (SecurityServer)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ws$security$server$SecurityServer == null ? (class$com$ibm$ws$security$server$SecurityServer = CORBAHelper.class$("com.ibm.ws.security.server.SecurityServer")) : class$com$ibm$ws$security$server$SecurityServer));
                }
                catch (NamingException namingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to lookup Security Server");
                    }
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.securityserver.lookup.error", (Object)new Object[]{namingException});
                }
            }
        }
        MAP_CREDENTIAL = new WebSphereRuntimePermission("wssecurity.mapCredential");
    }
}

