/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandlerFactory;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public final class ConfigConstants {
    public static final String TR_GROUP = "Web Services Security";
    public static final String TR_NLSPROPS = "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity";
    public static final String WS_SECURITY_RESOURCE_NAME = "ws-security.xml";
    public static final String WS_SECURITY_DEFAULT_LOCATION = "${USER_INSTALL_ROOT}/properties/ws-security.xml";
    public static final String WS_SECURITY_LOCATION_PROPERTY = "wssecurity.defaultbindings.location";
    public static final String WS_INITIAL_SENDER_ID = "wssecurity.initial.sender.id";
    public static final String BASICAUTH_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    public static final String BASICAUTH_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    public static final String BASICAUTH_NONCE_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    public static final String BASICAUTH_NONCE_TIMESTAMP_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    public static final String BASICAUTH_NONCE_MAX_AGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    public static final String BASICAUTH_NONCE_CLOCK_SKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    public static final String BASICAUTH_NONCE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout";
    public static final int DEFAULT_NONCE_CACHETIMEOUT = 600;
    public static final int MIN_NONCE_CACHETIMEOUT = 300;
    public static final int DEFAULT_NONCE_MAX_AGE = 300;
    public static final int MIN_NONCE_MAX_AGE = 300;
    public static final int DEFAULT_NONCE_CLOCK_SKEW = 0;
    public static final int MIN_NONCE_CLOCK_SKEW = 0;
    public static final String WSSE_NS = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    private static ResourceBundle _res = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants = ConfigConstants.class$("com.ibm.ws.webservices.wssecurity.util.ConfigConstants")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants;
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$auth$callback$CallbackHandlerFactory;
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$id$TrustedIDEvaluator;
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$config$KeyLocator;

    public static String getMessage(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessage", (Object)new Object[]{string});
        }
        String string2 = string;
        if (_res != null) {
            try {
                string2 = _res.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception", (Object)new Object[]{missingResourceException});
                }
                FFDCFilter.processException((Throwable)missingResourceException, (String)((class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants = ConfigConstants.class$("com.ibm.ws.webservices.wssecurity.util.ConfigConstants")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants).getName() + ".getMessage"), (String)"162");
                string2 = string;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessage", (Object)new Object[]{string2});
        }
        return string2;
    }

    public static com.ibm.xml.soapsec.token.LoginMapping readLoginMapping(LoginMapping loginMapping, VariableMap variableMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readLoginMapping", (Object)loginMapping);
        }
        if (loginMapping == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.loginmapping.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.loginmapping.is.null"));
        }
        CallbackHandlerFactory callbackHandlerFactory = loginMapping.getCallbackHandlerFactory();
        String string = callbackHandlerFactory.getClassname();
        Map map = ConfigConstants.getProperties(callbackHandlerFactory.getProperties(), variableMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating CallbackHandlerFactory: ", (Object)new Object[]{string, map});
        }
        com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory callbackHandlerFactory2 = (com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory)ConfigUtil.instantiate((String)string, (Class)(class$com$ibm$wsspi$wssecurity$auth$callback$CallbackHandlerFactory == null ? (class$com$ibm$wsspi$wssecurity$auth$callback$CallbackHandlerFactory = ConfigConstants.class$("com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory")) : class$com$ibm$wsspi$wssecurity$auth$callback$CallbackHandlerFactory), (Map)map);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerFactory " + string + " created"));
        }
        TokenValueType tokenValueType = loginMapping.getTokenValueType();
        QName qName = null;
        if (tokenValueType != null) {
            qName = new QName(tokenValueType.getUri(), tokenValueType.getLocalName());
        }
        com.ibm.xml.soapsec.token.LoginMapping loginMapping2 = new com.ibm.xml.soapsec.token.LoginMapping(loginMapping.getAuthMethod(), qName, loginMapping.getConfigName(), callbackHandlerFactory2, ConfigConstants.getProperties(loginMapping.getProperties(), variableMap));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readLoginMapping", (Object)loginMapping2);
        }
        return loginMapping2;
    }

    public static TrustedIDEvaluator readTrustedIDEvaluator(com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator trustedIDEvaluator, VariableMap variableMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readTrustedIDEvaluator", (Object)trustedIDEvaluator);
        }
        if (trustedIDEvaluator == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.trustedidevaluator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.trustedidevaluator.is.null"));
        }
        Map map = ConfigConstants.getProperties(trustedIDEvaluator.getProperties(), variableMap);
        String string = trustedIDEvaluator.getClassname();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating TrustedIDEvaluator: ", (Object)new Object[]{string, map});
        }
        TrustedIDEvaluator trustedIDEvaluator2 = (TrustedIDEvaluator)ConfigUtil.instantiate((String)string, (Class)(class$com$ibm$wsspi$wssecurity$id$TrustedIDEvaluator == null ? (class$com$ibm$wsspi$wssecurity$id$TrustedIDEvaluator = ConfigConstants.class$("com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator")) : class$com$ibm$wsspi$wssecurity$id$TrustedIDEvaluator), (Map)map);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TrustedIDEvaluator " + string + " created"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readTrustedIDEvaluator", (Object)trustedIDEvaluator2);
        }
        return trustedIDEvaluator2;
    }

    public static com.ibm.wsspi.wssecurity.config.KeyLocator findKeyLocator(EList eList, String string, VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findKeyLocator(" + eList + "," + string + ")"));
        }
        com.ibm.wsspi.wssecurity.config.KeyLocator keyLocator = null;
        for (int i = 0; i < eList.size(); ++i) {
            KeyLocator keyLocator2 = (KeyLocator)eList.get(i);
            if (!string.equals(keyLocator2.getName())) continue;
            keyLocator = ConfigConstants.readKeyLocator(keyLocator2, variableMap);
            break;
        }
        if (keyLocator == null && wSSecurityDefaultConfiguration != null) {
            keyLocator = wSSecurityDefaultConfiguration.getKeyLocator(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findKeyLocator(EList locators, String locatorRef) returns " + keyLocator));
        }
        return keyLocator;
    }

    public static com.ibm.wsspi.wssecurity.config.KeyLocator readKeyLocator(KeyLocator keyLocator, VariableMap variableMap) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readKeyLocator", (Object)keyLocator);
        }
        if (keyLocator == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.keylocator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.keylocator.is.null"));
        }
        Map map = ConfigConstants.getProperties(keyLocator.getProperties(), variableMap);
        KeyStore keyStore = keyLocator.getKeyStore();
        if (keyStore != null) {
            String string;
            String string2;
            String string3 = keyStore.getPath();
            if (variableMap != null) {
                string3 = variableMap.expand(string3);
            }
            if (string3 != null) {
                map.put("path", string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readKeyLocator() - keystore path: " + string3));
                }
            }
            if ((string2 = keyStore.getStorepass()) != null) {
                map.put("storepass", string2);
            }
            if ((string = keyStore.getType()) != null) {
                map.put("type", string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readKeyLocator() - keystore type: " + string));
                }
            }
        }
        int n = 0;
        int n2 = keyLocator.getKeys().size();
        for (int i = 0; i < n2; ++i) {
            String string;
            String string4;
            object = (Key)keyLocator.getKeys().get(i);
            String string5 = object.getAlias();
            while (map.containsKey("name_" + n)) {
                ++n;
            }
            if (string5 != null) {
                map.put("alias_" + n, string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readKeyLocator() - keystore alias_" + n + ": " + string5));
                }
            }
            if ((string4 = object.getKeypass()) != null) {
                map.put("keypass_" + n, string4);
            }
            if ((string = object.getName()) == null) continue;
            map.put("name_" + n, string);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("readKeyLocator() - keystore name_" + n + ": " + string));
        }
        String string = keyLocator.getClassname();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating KeyLocator: ", (Object)new Object[]{string, "map"});
        }
        object = (com.ibm.wsspi.wssecurity.config.KeyLocator)ConfigUtil.instantiate((String)string, (Class)(class$com$ibm$wsspi$wssecurity$config$KeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$KeyLocator = ConfigConstants.class$("com.ibm.wsspi.wssecurity.config.KeyLocator")) : class$com$ibm$wsspi$wssecurity$config$KeyLocator), (Map)map);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyLocator " + string + " created"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readKeyLocator", (Object)object);
        }
        return object;
    }

    public static CertStore readLDAPCertStore(LDAPCertStore lDAPCertStore, VariableMap variableMap) throws SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readLDAPCertStore", (Object)lDAPCertStore);
        }
        if (lDAPCertStore == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ldapCertStore.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapCertStore.is.null"));
        }
        LDAPServer lDAPServer = lDAPCertStore.getLdapServer();
        if (lDAPServer == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ldapserver.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapserver.is.null"));
        }
        String string = lDAPServer.getHost();
        try {
            n = Integer.parseInt(lDAPServer.getPort());
        }
        catch (NumberFormatException numberFormatException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s19", lDAPServer.getPort(), (Throwable)numberFormatException);
        }
        String string2 = "LDAP";
        String string3 = lDAPCertStore.getProvider();
        CertStore certStore = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("algorithm=" + string2 + ", provider=" + string3 + ", LDAPServer host=" + string + ", LDAPServer port=" + n));
        }
        LDAPCertStoreParameters lDAPCertStoreParameters = new LDAPCertStoreParameters(string, n);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LDAPCertStoreParameters: ", (Object)new Object[]{lDAPCertStoreParameters});
        }
        try {
            certStore = "".equals(string3) ? CertStore.getInstance(string2, lDAPCertStoreParameters) : CertStore.getInstance(string2, (CertStoreParameters)lDAPCertStoreParameters, string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s20", string2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s21", lDAPCertStoreParameters.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readLDAPCertStore", (Object)certStore);
        }
        return certStore;
    }

    public static Map getProperties(EList eList, VariableMap variableMap) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eList != null && !eList.isEmpty()) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                Property property;
                Object object = eList.get(i);
                if (object instanceof Property) {
                    property = (Property)object;
                    string = variableMap == null ? property.getValue() : variableMap.expand(property.getValue());
                    hashMap.put(property.getName(), string);
                    continue;
                }
                property = (com.ibm.etools.webservice.wscommonext.Property)object;
                string = variableMap == null ? property.getValue() : variableMap.expand(property.getValue());
                hashMap.put(property.getName(), string);
            }
        }
        return hashMap;
    }

    public static long validNonceCacheTimeOut(long l) {
        long l2 = l;
        if (l2 < 300L) {
            l2 = 300L;
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0116W", (Object)new Object[]{new Long(l2), new Long(300L)});
        }
        return l2;
    }

    public static long validNonceMaxAge(long l, long l2, long l3) {
        long l4 = l;
        if (l4 < 300L || l4 > l2) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0118W", (Object)new Object[]{new Long(l4), new Long(300L), new Long(l2), new Long(l3)});
            l4 = l3;
        }
        return l4;
    }

    public static long validNonceClockSkew(long l, long l2, long l3) {
        long l4 = l;
        if (l4 < 0L || l4 > l2) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0119W", (Object)new Object[]{new Long(l4), new Long(0L), new Long(l2), new Long(l3)});
            l4 = l3;
        }
        return l4;
    }

    public static long processNonceMaxAge(String string, long l, long l2, long l3) {
        long l4 = 300L;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                long l5 = Long.parseLong(string);
                l4 = ConfigConstants.validNonceMaxAge(l5, l, l2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)((class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants = ConfigConstants.class$("com.ibm.ws.webservices.wssecurity.util.ConfigConstants")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants).getName() + ".processNonceMaxAge"), (String)"505");
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0117W", (Object)new Object[]{string, new Long(l3)});
                l4 = l3;
            }
        }
        return l4;
    }

    public static long processNonceClockSkew(String string, long l, long l2, long l3) {
        long l4 = 0L;
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                long l5 = Long.parseLong(string);
                l4 = ConfigConstants.validNonceClockSkew(l5, l, l2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)((class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants = ConfigConstants.class$("com.ibm.ws.webservices.wssecurity.util.ConfigConstants")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants).getName() + ".processNonceClockSkew"), (String)"529");
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0120W", (Object)new Object[]{string, new Long(l3)});
                l4 = l3;
            }
        }
        return l4;
    }

    public static String getWSSENS(MessageContext messageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWSSENS(MessageContext)");
        }
        if ((string = (String)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No WSSE namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSSENS(MessageContext) returns " + string));
        }
        return string;
    }

    public static String getWSUNS(MessageContext messageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWSUNS(MessageContext)");
        }
        if ((string = (String)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace")) == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No WSU namespace found in MessageContext, use default");
            }
            string = Constants.NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSUNS(MessageContext) returns " + string));
        }
        return string;
    }

    private static void init() {
        try {
            _res = ResourceBundle.getBundle(TR_NLSPROPS);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants = ConfigConstants.class$("com.ibm.ws.webservices.wssecurity.util.ConfigConstants")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigConstants).getName(), (String)"583");
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.cannot.laod.resource", (Object)new Object[]{throwable});
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConfigConstants.init();
    }
}

