/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonext.AuthMethod;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConfigValidation {
    private VariableMap varMap = null;
    private WSSecurityDefaultConfiguration config = null;
    protected final Set allowedEncAlgos = new HashSet();
    protected final Set allowedKeyEncAlgos = new HashSet();
    protected final Set allowedC14nAlgos = new HashSet();
    protected final Set allowedSignAlgos = new HashSet();
    protected final Set allowedDigestAlgos = new HashSet();
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation = ConfigValidation.class$("com.ibm.ws.webservices.wssecurity.util.ConfigValidation")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation).getName();
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation == null ? (class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation = ConfigValidation.class$("com.ibm.ws.webservices.wssecurity.util.ConfigValidation")) : class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    static /* synthetic */ Class class$com$ibm$ws$webservices$wssecurity$util$ConfigValidation;

    public ConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigValidation()");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap variableMap, WSSecurityService wSSecurityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigValidation(VariableMap, WSSecurityService):", (Object)new Object[]{variableMap, wSSecurityService});
        }
        this.init();
        this.varMap = variableMap;
        this.config = wSSecurityService != null ? (WSSecurityDefaultConfiguration)wSSecurityService.getConfig() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigValidation(VariableMap, WSSecurityDefaultConfiguration):", (Object)new Object[]{variableMap, wSSecurityDefaultConfiguration});
        }
        this.init();
        this.varMap = variableMap;
        this.config = wSSecurityDefaultConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigValidation()");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        this.processAllowedAlgorithms(DOMUtil.getConfigValidation());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public void initVarMap(VariableMap variableMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initVarMap(VariableMap):", (Object)new Object[]{variableMap});
        }
        this.varMap = variableMap;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initVarMap()");
        }
    }

    public void initDefaultConfig(WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initDefaultConfig(WSSecurityDefaultConfiguration):", (Object)new Object[]{wSSecurityDefaultConfiguration});
        }
        this.config = wSSecurityDefaultConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initDefaultConfig()");
        }
    }

    public void initWsService(WSSecurityService wSSecurityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initWsService(WSSecurityService):", (Object)new Object[]{wSSecurityService});
        }
        if (wSSecurityService != null) {
            this.config = (WSSecurityDefaultConfiguration)wSSecurityService.getConfig();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initWsService()");
        }
    }

    public boolean requiredIntegrityValid(RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("requiredIntegrityValid(" + requiredIntegrity + ")"));
        }
        String string = null;
        boolean bl = true;
        if (requiredIntegrity != null) {
            int n = requiredIntegrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                Reference reference = (Reference)requiredIntegrity.getReferences().get(i);
                ReferencePart referencePart = reference.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if ("body".equals(string2) || "timestamp".equals(string2) || "securitytoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.required.integrity.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("requiredIntegrityValid() returns " + bl));
        }
        return bl;
    }

    public boolean requiredConfidentialityValid(RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("requiredConfidentialityValid(" + requiredConfidentiality + ")"));
        }
        String string = null;
        boolean bl = true;
        if (requiredConfidentiality != null) {
            int n = requiredConfidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string2 = null;
                if (confidentialPartPart != null) {
                    string2 = confidentialPartPart.getName();
                }
                if ("bodycontent".equals(string2) || "usernametoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.required.conf.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("requiredConfidentialityValid() returns " + bl));
        }
        return bl;
    }

    public boolean integrityValid(Integrity integrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("integrityValid(" + integrity + ")"));
        }
        String string = null;
        boolean bl = true;
        if (integrity != null) {
            int n = integrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                Reference reference = (Reference)integrity.getReferences().get(i);
                ReferencePart referencePart = reference.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if ("body".equals(string2) || "timestamp".equals(string2) || "securitytoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.integrity.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("integrityValid() returns " + bl));
        }
        return bl;
    }

    public boolean confidentialityValid(Confidentiality confidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("confidentialityValid(" + confidentiality + ")"));
        }
        String string = null;
        boolean bl = true;
        if (confidentiality != null) {
            int n = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string2 = null;
                if (confidentialPartPart != null) {
                    string2 = confidentialPartPart.getName();
                }
                if ("bodycontent".equals(string2) || "usernametoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.conf.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("confidentialityValid() returns " + bl));
        }
        return bl;
    }

    public boolean idAssertionValid(IDAssertion iDAssertion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("idAssertionValid(" + iDAssertion + ")"));
        }
        String string = null;
        boolean bl = true;
        if (iDAssertion != null) {
            String string2;
            String string3;
            String string4 = iDAssertion.getIdType();
            if (!("Username".equals(string4) || "DN".equals(string4) || "X509Certificate".equals(string4))) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.idassertion.type.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string4});
                string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if ((string3 = iDAssertion.getTrustMode()) != null && !"Signature".equals(string3) && !"BasicAuth".equals(string3)) {
                bl = false;
                string2 = "security.wssecurity.ConfigValidation.idassertion.mode.invalid";
                Tr.error((TraceComponent)tc, (String)string2, (Object)new Object[]{string3});
                String string5 = MessageFormat.format(ConfigConstants.getMessage(string2), string3);
                string = string == null || string.length() == 0 ? new String(string5) : new String(string + " ; " + string5);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("idAssertionValid() returns " + bl));
        }
        return bl;
    }

    public boolean scopeValid(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("scopeValid(" + string + ")"));
        }
        String string2 = null;
        boolean bl = true;
        if (!(string == null || "Session".equals(string) || "Request".equals(string) || "Application".equals(string))) {
            bl = false;
            String string3 = "security.wssecurity.ConfigValidation.scope.invalid";
            Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string});
            String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string);
            string2 = string2 == null || string2.length() == 0 ? new String(string4) : new String(string2 + " ; " + string4);
        }
        if (!bl) {
            throw new SoapSecurityException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("scopeValid() returns " + bl));
        }
        return bl;
    }

    private boolean signingInfoValid(SigningInfo signingInfo, EList eList, CertStoreList certStoreList, boolean bl, boolean bl2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("signingInfoValid(" + signingInfo + ", " + eList + ", " + certStoreList + ", " + (bl ? "receiver" : "sender") + ", " + "signingInfoRequired=" + bl2 + ")"));
        }
        String string = null;
        boolean bl3 = true;
        if (signingInfo != null) {
            Object object;
            String string2;
            Object object2;
            int n;
            Object object3;
            String string3;
            String string4;
            Object object4;
            Object object5;
            TrustAnchorRef trustAnchorRef = null;
            CertStoreRef certStoreRef = null;
            TrustAnyCertificate trustAnyCertificate = null;
            CanonicalizationMethod canonicalizationMethod = signingInfo.getCanonicalizationMethod();
            String string5 = null;
            if (canonicalizationMethod != null) {
                string5 = canonicalizationMethod.getAlgorithm();
            }
            DigestMethod digestMethod = signingInfo.getDigestMethod();
            String string6 = null;
            if (digestMethod != null) {
                string6 = digestMethod.getAlgorithm();
            }
            SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
            String string7 = null;
            if (signatureMethod != null) {
                string7 = signatureMethod.getAlgorithm();
            }
            if (canonicalizationMethod != null && !this.canonicalizationMethodValid(string5)) {
                bl3 = false;
                object5 = "security.wssecurity.ConfigValidation.canon.method.invalid";
                Tr.error((TraceComponent)tc, (String)object5, (Object)new Object[]{string5});
                object4 = MessageFormat.format(ConfigConstants.getMessage((String)object5), string5);
                string = string == null || string.length() == 0 ? new String((String)object4) : new String(string + " ; " + (String)object4);
            }
            if (digestMethod != null && !this.digestMethodValid(string6)) {
                bl3 = false;
                object5 = "security.wssecurity.ConfigValidation.digest.method.invalid";
                Tr.error((TraceComponent)tc, (String)object5, (Object)new Object[]{string6});
                object4 = MessageFormat.format(ConfigConstants.getMessage((String)object5), string6);
                string = string == null || string.length() == 0 ? new String((String)object4) : new String(string + " ; " + (String)object4);
            }
            if (signatureMethod != null && !this.signatureMethodValid(string7)) {
                bl3 = false;
                object5 = "security.wssecurity.ConfigValidation.sign.method.invalid";
                Tr.error((TraceComponent)tc, (String)object5, (Object)new Object[]{string7});
                object4 = MessageFormat.format(ConfigConstants.getMessage((String)object5), string7);
                string = string == null || string.length() == 0 ? new String((String)object4) : new String(string + " ; " + (String)object4);
            }
            if ((object5 = signingInfo.getCertPathSettings()) != null) {
                trustAnchorRef = object5.getTrustAnchorRef();
                certStoreRef = object5.getCertStoreRef();
                trustAnyCertificate = object5.getTrustAnyCertificate();
                if (trustAnyCertificate == null && trustAnchorRef == null) {
                    bl3 = false;
                    object4 = "security.wssecurity.ConfigValidation.cps.missing.refs";
                    Tr.error((TraceComponent)tc, (String)object4);
                    string4 = ConfigConstants.getMessage((String)object4);
                    string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
                }
            } else if (bl) {
                bl3 = false;
                object4 = "security.wssecurity.ConfigValidation.cps.missing";
                Tr.error((TraceComponent)tc, (String)object4);
                string4 = ConfigConstants.getMessage((String)object4);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
            if ((object4 = signingInfo.getSigningKey()) != null) {
                String string8;
                string4 = object4.getName();
                string3 = object4.getLocatorRef();
                if (string4 == null || string4.length() == 0) {
                    bl3 = false;
                    object3 = "security.wssecurity.ConfigValidation.sk.missing.name";
                    Tr.error((TraceComponent)tc, (String)object3);
                    string8 = ConfigConstants.getMessage((String)object3);
                    string = string == null || string.length() == 0 ? new String(string8) : new String(string + " ; " + string8);
                }
                if (string3 == null || string3.length() == 0) {
                    bl3 = false;
                    object3 = "security.wssecurity.ConfigValidation.sk.missing.ref";
                    Tr.error((TraceComponent)tc, (String)object3);
                    string8 = ConfigConstants.getMessage((String)object3);
                    string = string == null || string.length() == 0 ? new String(string8) : new String(string + " ; " + string8);
                }
            } else if (!bl) {
                bl3 = false;
                string4 = "security.wssecurity.ConfigValidation.sk.missing";
                Tr.error((TraceComponent)tc, (String)string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            }
            if (trustAnyCertificate != null) {
                string4 = null;
                if (trustAnchorRef != null) {
                    string4 = trustAnchorRef.getRef();
                }
                if (string4 != null && string4.length() != 0) {
                    boolean bl4 = false;
                    if (eList != null && !eList.isEmpty()) {
                        object3 = null;
                        int n2 = eList.size();
                        for (n = 0; n < n2; ++n) {
                            object2 = (TrustAnchor)eList.get(n);
                            if (!string4.equals(object2.getName())) continue;
                            bl4 = true;
                            string2 = object2.getKeyStore();
                            object = null;
                            object = this.varMap == null ? new File(string2.getPath()) : new File(this.varMap.expand(string2.getPath()));
                            try {
                                object3 = ConfigUtil.getKeyStore((String)string2.getType(), (File)object, (char[])string2.getStorepass().toCharArray());
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                // empty catch block
                            }
                            if (object3 != null || !tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tc, (String)("Unable to open keystore \"" + string2.getPath() + "\"."));
                            break;
                        }
                        if (object3 == null && this.config != null) {
                            object3 = this.config.getTrustAnchor(string4);
                        }
                        if (object3 == null) {
                            bl3 = false;
                            String string9 = "security.wssecurity.ConfigValidation.keystore.taref.open";
                            Tr.error((TraceComponent)tc, (String)string9, (Object)new Object[]{string4});
                            object2 = MessageFormat.format(ConfigConstants.getMessage(string9), string4);
                            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
                        }
                    }
                    if (!bl4 && bl) {
                        bl3 = false;
                        object3 = "security.wssecurity.ConfigValidation.taref.notfound";
                        Tr.error((TraceComponent)tc, (String)object3, (Object)new Object[]{string4});
                        String string10 = MessageFormat.format(ConfigConstants.getMessage((String)object3), string4);
                        string = string == null || string.length() == 0 ? new String(string10) : new String(string + " ; " + string10);
                    }
                }
            }
            if (trustAnyCertificate != null) {
                string4 = null;
                if (certStoreRef != null) {
                    string4 = certStoreRef.getRef();
                }
                if (string4 != null && string4.length() != 0) {
                    boolean bl5 = false;
                    if (certStoreList != null) {
                        EList eList2;
                        String string11;
                        String string12;
                        String string13;
                        String string14;
                        object3 = certStoreList.getCollectionCertStores();
                        if (object3 != null && !object3.isEmpty()) {
                            int n3 = object3.size();
                            for (n = 0; n < n3; ++n) {
                                object2 = (CollectionCertStore)object3.get(n);
                                string2 = object2.getName();
                                if (!string4.equals(string2)) continue;
                                bl5 = true;
                                object = object2.getName();
                                if (object == null || ((String)object).length() == 0) {
                                    bl3 = false;
                                    string14 = "security.wssecurity.ConfigValidation.ccs.missing.name";
                                    Tr.error((TraceComponent)tc, (String)string14);
                                    string13 = ConfigConstants.getMessage(string14);
                                    string = string == null || string.length() == 0 ? new String(string13) : new String(string + " ; " + string13);
                                }
                                if ((string14 = object2.getProvider()) == null || string14.length() == 0) {
                                    bl3 = false;
                                    string13 = "security.wssecurity.ConfigValidation.ccs.missing.provider";
                                    Tr.error((TraceComponent)tc, (String)string13);
                                    string12 = ConfigConstants.getMessage(string13);
                                    string = string == null || string.length() == 0 ? new String(string12) : new String(string + " ; " + string12);
                                }
                                if ((string13 = object2.getX509Certificates()) != null && string13.size() >= 1) break;
                                bl3 = false;
                                string12 = "security.wssecurity.ConfigValidation.ccs.missing.cert";
                                Tr.error((TraceComponent)tc, (String)string12);
                                string11 = ConfigConstants.getMessage(string12);
                                if (string == null || string.length() == 0) {
                                    string = new String(string11);
                                    break;
                                }
                                string = new String(string + " ; " + string11);
                                break;
                            }
                        }
                        if ((eList2 = certStoreList.getLdapCertStores()) != null && !eList2.isEmpty()) {
                            n = eList2.size();
                            for (int i = 0; i < n; ++i) {
                                String string15;
                                String string16;
                                string2 = (LDAPCertStore)eList2.get(i);
                                object = string2.getName();
                                if (!string4.equals(object)) continue;
                                bl5 = true;
                                string14 = string2.getName();
                                if (string14 == null || string14.length() == 0) {
                                    bl3 = false;
                                    string13 = "security.wssecurity.ConfigValidation.lcs.missing.name";
                                    Tr.error((TraceComponent)tc, (String)string13);
                                    string12 = ConfigConstants.getMessage(string13);
                                    string = string == null || string.length() == 0 ? new String(string12) : new String(string + " ; " + string12);
                                }
                                if ((string13 = string2.getProvider()) == null || string13.length() == 0) {
                                    bl3 = false;
                                    string12 = "security.wssecurity.ConfigValidation.lcs.missing.provider";
                                    Tr.error((TraceComponent)tc, (String)string12);
                                    string11 = ConfigConstants.getMessage(string12);
                                    string = string == null || string.length() == 0 ? new String(string11) : new String(string + " ; " + string11);
                                }
                                if ((string12 = string2.getLdapServer()) == null) {
                                    bl3 = false;
                                    string11 = "security.wssecurity.ConfigValidation.lcs.missing.server";
                                    Tr.error((TraceComponent)tc, (String)string11);
                                    String string17 = ConfigConstants.getMessage(string11);
                                    if (string == null || string.length() == 0) {
                                        string = new String(string17);
                                        break;
                                    }
                                    string = new String(string + " ; " + string17);
                                    break;
                                }
                                string11 = string12.getHost();
                                if (string11 == null || string11.length() == 0) {
                                    bl3 = false;
                                    string16 = "security.wssecurity.ConfigValidation.ldap.missing.host";
                                    Tr.error((TraceComponent)tc, (String)string16);
                                    string15 = ConfigConstants.getMessage(string16);
                                    string = string == null || string.length() == 0 ? new String(string15) : new String(string + " ; " + string15);
                                }
                                if ((string16 = string12.getPort()) != null && string16.length() != 0) break;
                                bl3 = false;
                                string15 = "security.wssecurity.ConfigValidation.ldap.missing.port";
                                Tr.error((TraceComponent)tc, (String)string15);
                                String string18 = ConfigConstants.getMessage(string15);
                                if (string == null || string.length() == 0) {
                                    string = new String(string18);
                                    break;
                                }
                                string = new String(string + " ; " + string18);
                                break;
                            }
                        }
                    }
                    if (!bl5 && this.config != null && (object3 = this.config.getCertStore(string4)) != null) {
                        bl5 = true;
                    }
                    if (!bl5 && bl) {
                        bl3 = false;
                        object3 = "security.wssecurity.ConfigValidation.csref.notfound";
                        Tr.error((TraceComponent)tc, (String)object3, (Object)new Object[]{string4});
                        String string19 = MessageFormat.format(ConfigConstants.getMessage((String)object3), string4);
                        string = string == null || string.length() == 0 ? new String(string19) : new String(string + " ; " + string19);
                    }
                }
            }
        } else if (bl2) {
            bl3 = false;
            String string20 = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error((TraceComponent)tc, (String)string20);
            String string21 = ConfigConstants.getMessage(string20);
            string = string == null || string.length() == 0 ? new String(string21) : new String(string + " ; " + string21);
        }
        if (!bl3) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("signingInfoValid() returns " + bl3));
        }
        return bl3;
    }

    public boolean receiverSigningInfoValid(EList eList, EList eList2, CertStoreList certStoreList, RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        Object object;
        Object object2;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("receiverSigningInfoValid(" + eList + ", " + eList2 + ", " + certStoreList + ", " + requiredIntegrity + ")"));
        }
        String string = null;
        boolean bl = false;
        if (requiredIntegrity != null) {
            n2 = requiredIntegrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                object2 = (Reference)requiredIntegrity.getReferences().get(n);
                ReferencePart referencePart = object2.getPart();
                object = null;
                if (referencePart != null) {
                    object = referencePart.getName();
                }
                if (object == null || ((String)object).length() == 0) continue;
                bl = true;
                break;
            }
        }
        n2 = 1;
        if (eList != null && !eList.isEmpty()) {
            n = 0;
            int n3 = eList.size();
            for (int i = 0; i < n3; ++i) {
                object = (SigningInfo)eList.get(i);
                boolean bl2 = this.signingInfoValid((SigningInfo)object, eList2, certStoreList, true, bl);
                if (!bl2) {
                    n2 = 0;
                }
                if (!bl || object == null || object.getSignatureMethod() == null || object.getDigestMethod() == null || object.getCanonicalizationMethod() == null) continue;
                n = 1;
            }
            if (bl && n == 0) {
                n2 = 0;
                String string2 = "security.wssecurity.ConfigValidation.sign.algos.required";
                Tr.error((TraceComponent)tc, (String)string2);
                object = ConfigConstants.getMessage(string2);
                string = string == null || string.length() == 0 ? new String((String)object) : new String(string + " ; " + (String)object);
            }
        } else if (bl) {
            n2 = 0;
            String string3 = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error((TraceComponent)tc, (String)string3);
            object2 = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
        }
        if (n2 == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("receiverSigningInfoValid() returns " + (n2 != 0)));
        }
        return n2 != 0;
    }

    public boolean senderSigningInfoValid(SigningInfo signingInfo, EList eList, CertStoreList certStoreList, Integrity integrity) throws SoapSecurityException {
        Object object;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("senderSigningInfoValid(" + signingInfo + ", " + eList + ", " + certStoreList + ", " + integrity + ")"));
        }
        String string = null;
        boolean bl = false;
        if (integrity != null) {
            n = integrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                object = (Reference)integrity.getReferences().get(i);
                ReferencePart referencePart = object.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if (string2 == null || string2.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n = this.signingInfoValid(signingInfo, eList, certStoreList, false, bl) ? 1 : 0;
        if (bl && signingInfo != null && (signingInfo.getSignatureMethod() == null || signingInfo.getDigestMethod() == null || signingInfo.getCanonicalizationMethod() == null)) {
            n = 0;
            String string3 = "security.wssecurity.ConfigValidation.sign.algos.required";
            Tr.error((TraceComponent)tc, (String)string3);
            object = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object) : new String(string + " ; " + (String)object);
        }
        if (n == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("senderSigningInfoValid() returns " + (n != 0)));
        }
        return n != 0;
    }

    public boolean encryptionInfosValid(EList eList, EList eList2, RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        ConfidentialPartPart confidentialPartPart;
        Object object;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encryptionInfosValid(" + eList + ", " + eList2 + ", " + requiredConfidentiality + ")"));
        }
        String string = null;
        boolean bl = false;
        if (requiredConfidentiality != null) {
            n2 = requiredConfidentiality.getConfidentialParts().size();
            for (n = 0; n < n2; ++n) {
                object = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(n);
                confidentialPartPart = object.getPart();
                String string2 = null;
                if (confidentialPartPart != null) {
                    string2 = confidentialPartPart.getName();
                }
                if (string2 == null || string2.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n2 = 1;
        if (eList != null && !eList.isEmpty()) {
            n = eList.size();
            for (int i = 0; i < n; ++i) {
                confidentialPartPart = (EncryptionInfo)eList.get(i);
                boolean bl2 = this.privateEncInfoValid((EncryptionInfo)confidentialPartPart, eList2, bl);
                if (bl2) continue;
                n2 = 0;
            }
        } else if (bl) {
            n2 = 0;
            String string3 = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error((TraceComponent)tc, (String)string3);
            object = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object) : new String(string + " ; " + (String)object);
        }
        if (n2 == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptionInfosValid() returns " + (n2 != 0)));
        }
        return n2 != 0;
    }

    public boolean encryptionInfoValid(EncryptionInfo encryptionInfo, EList eList, Confidentiality confidentiality) throws SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encryptionInfoValid(" + encryptionInfo + ", " + eList + ", " + confidentiality + ")"));
        }
        boolean bl = false;
        if (confidentiality != null) {
            n = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string = null;
                if (confidentialPartPart != null) {
                    string = confidentialPartPart.getName();
                }
                if (string == null || string.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n = 1;
        n = this.privateEncInfoValid(encryptionInfo, eList, bl) ? 1 : 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptionInfoValid() returns " + (n != 0)));
        }
        return n != 0;
    }

    private boolean privateEncInfoValid(EncryptionInfo encryptionInfo, EList eList, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("privateEncInfoValid(" + encryptionInfo + ", " + eList + ", " + bl + ")"));
        }
        String string = null;
        boolean bl2 = true;
        if (encryptionInfo != null) {
            String string2;
            String string3;
            String string4;
            String string5 = null;
            String string6 = encryptionInfo.getName();
            EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
            DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            if (encryptionKey == null) {
                bl2 = false;
                string4 = "security.wssecurity.ConfigValidation.ei.missing.key";
                Tr.error((TraceComponent)tc, (String)string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            } else {
                string5 = encryptionKey.getLocatorRef();
                if (string5 == null || string5.length() == 0) {
                    bl2 = false;
                    string4 = "security.wssecurity.ConfigValidation.ei.missing.key.loc.ref";
                    Tr.error((TraceComponent)tc, (String)string4);
                    string3 = ConfigConstants.getMessage(string4);
                    string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
                }
            }
            if (dataEncryptionMethod == null) {
                bl2 = false;
                string4 = "security.wssecurity.ConfigValidation.ei.missing.enc.method";
                Tr.error((TraceComponent)tc, (String)string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            } else {
                string4 = dataEncryptionMethod.getAlgorithm();
                if (!this.encryptionMethodValid(string4)) {
                    bl2 = false;
                    string3 = "security.wssecurity.ConfigValidation.enc.method.invalid";
                    Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string4});
                    string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                    string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
                }
            }
            if (keyEncryptionMethod != null && !this.keyEncryptionMethodValid(string4 = keyEncryptionMethod.getAlgorithm())) {
                bl2 = false;
                string3 = "security.wssecurity.ConfigValidation.keyenc.method.invalid";
                Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string4});
                string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if (string5 != null && string5.length() > 0) {
                com.ibm.wsspi.wssecurity.config.KeyLocator keyLocator;
                boolean bl3 = false;
                if (eList != null && !eList.isEmpty()) {
                    int n = eList.size();
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        Object object2;
                        String string7;
                        KeyLocator keyLocator2 = (KeyLocator)eList.get(i);
                        if (!string5.equals(keyLocator2.getName())) continue;
                        bl3 = true;
                        if (keyLocator2.getClassname() == null || keyLocator2.getClassname().length() == 0) {
                            bl2 = false;
                            string7 = "security.wssecurity.ConfigValidation.keyloc.missing.classname";
                            Tr.error((TraceComponent)tc, (String)string7);
                            object2 = ConfigConstants.getMessage(string7);
                            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
                        }
                        string7 = keyLocator2.getKeyStore();
                        object2 = null;
                        if (string7 != null) {
                            object = null;
                            object = this.varMap == null ? new File(string7.getPath()) : new File(this.varMap.expand(string7.getPath()));
                            try {
                                object2 = ConfigUtil.getKeyStore((String)string7.getType(), (File)object, (char[])string7.getStorepass().toCharArray());
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                // empty catch block
                            }
                            if (object2 == null) {
                                bl2 = false;
                                String string8 = "security.wssecurity.ConfigValidation.keystore.open";
                                Tr.error((TraceComponent)tc, (String)string8, (Object)new Object[]{string7.getPath()});
                                String string9 = MessageFormat.format(ConfigConstants.getMessage(string8), string7.getPath());
                                string = string == null || string.length() == 0 ? new String(string9) : new String(string + " ; " + string9);
                            }
                        }
                        if ((object = keyLocator2.getKeys()) == null || object.isEmpty()) break;
                        int n2 = object.size();
                        for (int j = 0; j < n2; ++j) {
                            String string10;
                            String string11;
                            Key key = (Key)object.get(j);
                            String string12 = key.getAlias();
                            String string13 = key.getKeypass();
                            String string14 = key.getName();
                            if (string12 == null || string12.length() == 0) {
                                bl2 = false;
                                string11 = "security.wssecurity.ConfigValidation.key.missing.alias";
                                Tr.error((TraceComponent)tc, (String)string11);
                                string10 = ConfigConstants.getMessage(string11);
                                string = string == null || string.length() == 0 ? new String(string10) : new String(string + " ; " + string10);
                            }
                            if (string13 == null || string13.length() == 0) {
                                bl2 = false;
                                string11 = "security.wssecurity.ConfigValidation.key.missing.keypass";
                                Tr.error((TraceComponent)tc, (String)string11);
                                string10 = ConfigConstants.getMessage(string11);
                                string = string == null || string.length() == 0 ? new String(string10) : new String(string + " ; " + string10);
                            }
                            if (string14 != null && string14.length() != 0) continue;
                            bl2 = false;
                            string11 = "security.wssecurity.ConfigValidation.key.missing.name";
                            Tr.error((TraceComponent)tc, (String)string11);
                            string10 = ConfigConstants.getMessage(string11);
                            string = string == null || string.length() == 0 ? new String(string10) : new String(string + " ; " + string10);
                        }
                        break;
                    }
                }
                if (!bl3 && this.config != null && (keyLocator = this.config.getKeyLocator(string5)) != null) {
                    bl3 = true;
                }
                if (!bl3) {
                    bl2 = false;
                    String string15 = "security.wssecurity.ConfigValidation.keylocref.notfound";
                    Tr.error((TraceComponent)tc, (String)string15, (Object)new Object[]{string5});
                    String string16 = MessageFormat.format(ConfigConstants.getMessage(string15), string5);
                    string = string == null || string.length() == 0 ? new String(string16) : new String(string + " ; " + string16);
                }
            }
        } else if (bl) {
            bl2 = false;
            String string17 = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error((TraceComponent)tc, (String)string17);
            String string18 = ConfigConstants.getMessage(string17);
            string = string == null || string.length() == 0 ? new String(string18) : new String(string + " ; " + string18);
        }
        if (!bl2) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("privateEncInfoValid() returns " + bl2));
        }
        return bl2;
    }

    public boolean loginMappingValid(EList eList, LoginConfig loginConfig) throws SoapSecurityException {
        Object object;
        String string;
        String string2;
        String string3;
        LoginMapping loginMapping;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loginMappingValid(" + eList + ", " + loginConfig + ")"));
        }
        String string4 = null;
        boolean bl = true;
        if (loginConfig != null) {
            EList eList2 = loginConfig.getAuthMethods();
            if (eList2 != null && !eList2.isEmpty()) {
                n2 = eList2.size();
                for (n = 0; n < n2; ++n) {
                    com.ibm.xml.soapsec.token.LoginMapping loginMapping2;
                    loginMapping = (AuthMethod)eList2.get(n);
                    string3 = null;
                    if (loginMapping != null) {
                        string3 = loginMapping.getText();
                    }
                    if (string3 == null || string3.length() == 0) {
                        bl = false;
                        string2 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                        Tr.error((TraceComponent)tc, (String)string2);
                        string = ConfigConstants.getMessage(string2);
                        if (string4 == null || string4.length() == 0) {
                            string4 = new String(string);
                            continue;
                        }
                        string4 = new String(string4 + " ; " + string);
                        continue;
                    }
                    boolean bl2 = false;
                    if (eList != null && !eList.isEmpty()) {
                        int n3 = eList.size();
                        for (int i = 0; i < n3; ++i) {
                            object = (LoginMapping)eList.get(i);
                            if (!string3.equals(object.getAuthMethod())) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl2 && this.config != null && (loginMapping2 = this.config.getLoginMapping(string3)) != null) {
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = false;
                    String string5 = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error((TraceComponent)tc, (String)string5, (Object)new Object[]{string3});
                    String string6 = MessageFormat.format(ConfigConstants.getMessage(string5), string3);
                    string4 = string4 == null || string4.length() == 0 ? new String(string6) : new String(string4 + " ; " + string6);
                }
            } else {
                bl = false;
                String string7 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error((TraceComponent)tc, (String)string7);
                String string8 = ConfigConstants.getMessage(string7);
                string4 = string4 == null || string4.length() == 0 ? new String(string8) : new String(string4 + " ; " + string8);
            }
        }
        if (eList != null && !eList.isEmpty()) {
            int n4 = eList.size();
            for (n2 = 0; n2 < n4; ++n2) {
                String string9;
                String string10;
                n = 0;
                loginMapping = (LoginMapping)eList.get(n2);
                string3 = loginMapping.getAuthMethod();
                if (string3 == null || string3.length() == 0) {
                    bl = false;
                    string2 = "security.wssecurity.ConfigValidation.lm.missing.authmethod";
                    Tr.error((TraceComponent)tc, (String)string2);
                    string = ConfigConstants.getMessage(string2);
                    string4 = string4 == null || string4.length() == 0 ? new String(string) : new String(string4 + " ; " + string);
                } else if (this.authMethodValid(string3)) {
                    if (!this.authMethodKnown(string3)) {
                        n = 1;
                    }
                } else {
                    bl = false;
                    string2 = "security.wssecurity.ConfigValidation.lm.authmethod.invalid";
                    Tr.error((TraceComponent)tc, (String)string2, (Object)new Object[]{string3});
                    string = MessageFormat.format(ConfigConstants.getMessage(string2), string3);
                    string4 = string4 == null || string4.length() == 0 ? new String(string) : new String(string4 + " ; " + string);
                }
                if (n != 0) {
                    string2 = loginMapping.getTokenValueType();
                    if (string2 == null) {
                        bl = false;
                        string = "security.wssecurity.ConfigValidation.lm.missing.tokvaltype";
                        Tr.error((TraceComponent)tc, (String)string);
                        string10 = ConfigConstants.getMessage(string);
                        string4 = string4 == null || string4.length() == 0 ? new String(string10) : new String(string4 + " ; " + string10);
                    } else {
                        string = string2.getUri();
                        string10 = string2.getLocalName();
                        if (string == null || string.length() == 0) {
                            bl = false;
                            object = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                            Tr.error((TraceComponent)tc, (String)object);
                            string9 = ConfigConstants.getMessage((String)object);
                            string4 = string4 == null || string4.length() == 0 ? new String(string9) : new String(string4 + " ; " + string9);
                        }
                        if (string10 == null || string10.length() == 0) {
                            bl = false;
                            object = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                            Tr.error((TraceComponent)tc, (String)object);
                            string9 = ConfigConstants.getMessage((String)object);
                            string4 = string4 == null || string4.length() == 0 ? new String(string9) : new String(string4 + " ; " + string9);
                        }
                    }
                }
                if ((string2 = loginMapping.getConfigName()) == null || string2.length() == 0) {
                    bl = false;
                    string = "security.wssecurity.ConfigValidation.lm.missing.configname";
                    Tr.error((TraceComponent)tc, (String)string);
                    string10 = ConfigConstants.getMessage(string);
                    string4 = string4 == null || string4.length() == 0 ? new String(string10) : new String(string4 + " ; " + string10);
                }
                if ((string = loginMapping.getCallbackHandlerFactory()) == null) {
                    bl = false;
                    string10 = "security.wssecurity.ConfigValidation.lm.missing.ch.factory";
                    Tr.error((TraceComponent)tc, (String)string10);
                    object = ConfigConstants.getMessage(string10);
                    if (string4 == null || string4.length() == 0) {
                        string4 = new String((String)object);
                        continue;
                    }
                    string4 = new String(string4 + " ; " + (String)object);
                    continue;
                }
                string10 = string.getClassname();
                if (string10 != null && string10.length() != 0) continue;
                bl = false;
                object = "security.wssecurity.ConfigValidation.lm.missing.ch.classname";
                Tr.error((TraceComponent)tc, (String)object);
                string9 = ConfigConstants.getMessage((String)object);
                string4 = string4 == null || string4.length() == 0 ? new String(string9) : new String(string4 + " ; " + string9);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loginMappingValid() returns " + bl));
        }
        return bl;
    }

    public boolean trustedIDEvaluatorRefValid(TrustedIDEvaluatorRef trustedIDEvaluatorRef) throws SoapSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("trustedIDEvaluatorRefValid(" + trustedIDEvaluatorRef + ")"));
        }
        String string2 = null;
        boolean bl = true;
        if (trustedIDEvaluatorRef != null && ((string = trustedIDEvaluatorRef.getRef()) == null || string.length() == 0)) {
            bl = false;
            String string3 = "security.wssecurity.ConfigValidation.tier.missing.ref";
            Tr.error((TraceComponent)tc, (String)string3);
            String string4 = ConfigConstants.getMessage(string3);
            string2 = string2 == null || string2.length() == 0 ? new String(string4) : new String(string2 + " ; " + string4);
        }
        if (!bl) {
            throw new SoapSecurityException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("trustedIDEvaluatorRefValid() returns " + bl));
        }
        return bl;
    }

    public boolean trustedIDEvaluatorValid(TrustedIDEvaluator trustedIDEvaluator) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("trustedIDEvaluatorValid(" + trustedIDEvaluator + ")"));
        }
        String string = null;
        boolean bl = true;
        if (trustedIDEvaluator != null) {
            String string2;
            String string3;
            String string4 = trustedIDEvaluator.getClassname();
            String string5 = trustedIDEvaluator.getName();
            if (string4 == null || string4.length() == 0) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.tie.missing.classname";
                Tr.error((TraceComponent)tc, (String)string3);
                string2 = ConfigConstants.getMessage(string3);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if (string5 == null || string5.length() == 0) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.tie.missing.name";
                Tr.error((TraceComponent)tc, (String)string3);
                string2 = ConfigConstants.getMessage(string3);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("trustedIDEvaluatorValid() returns " + bl));
        }
        return bl;
    }

    public boolean loginBindingValid(LoginBinding loginBinding, com.ibm.etools.webservice.wscext.LoginConfig loginConfig) throws SoapSecurityException {
        String string;
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loginBindingValid(" + loginBinding + ", " + loginConfig + ")"));
        }
        String string4 = null;
        boolean bl = true;
        if (loginConfig != null) {
            string3 = loginConfig.getAuthMethod();
            if (string3 == null || string3.length() == 0) {
                bl = false;
                String string5 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error((TraceComponent)tc, (String)string5);
                string2 = ConfigConstants.getMessage(string5);
                string4 = string4 == null || string4.length() == 0 ? new String(string2) : new String(string4 + " ; " + string2);
            } else {
                boolean bl2 = false;
                if (loginBinding != null && string3.equals(loginBinding.getAuthMethod())) {
                    bl2 = true;
                }
                if (!bl2) {
                    bl = false;
                    string2 = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error((TraceComponent)tc, (String)string2, (Object)new Object[]{string3});
                    string = MessageFormat.format(ConfigConstants.getMessage(string2), string3);
                    string4 = string4 == null || string4.length() == 0 ? new String(string) : new String(string4 + " ; " + string);
                }
            }
        }
        if (loginBinding != null) {
            String string6;
            string3 = loginBinding.getAuthMethod();
            boolean bl3 = false;
            if (string3 == null || string3.length() == 0) {
                bl = false;
                string2 = "security.wssecurity.ConfigValidation.lb.missing.authmethod";
                Tr.error((TraceComponent)tc, (String)string2);
                string = ConfigConstants.getMessage(string2);
                string4 = string4 == null || string4.length() == 0 ? new String(string) : new String(string4 + " ; " + string);
            } else if (this.authMethodValid(string3)) {
                if (!this.authMethodKnown(string3)) {
                    bl3 = true;
                }
            } else {
                bl = false;
                string2 = "security.wssecurity.ConfigValidation.lb.authmethod.invalid";
                Tr.error((TraceComponent)tc, (String)string2, (Object)new Object[]{string3});
                string = MessageFormat.format(ConfigConstants.getMessage(string2), string3);
                string4 = string4 == null || string4.length() == 0 ? new String(string) : new String(string4 + " ; " + string);
            }
            if (bl3) {
                string2 = loginBinding.getTokenValueType();
                if (string2 == null) {
                    bl = false;
                    string = "security.wssecurity.ConfigValidation.lb.missing.tokvaltype";
                    Tr.error((TraceComponent)tc, (String)string, (Object)new Object[]{string3});
                    string6 = MessageFormat.format(ConfigConstants.getMessage(string), string3);
                    string4 = string4 == null || string4.length() == 0 ? new String(string6) : new String(string4 + " ; " + string6);
                } else {
                    String string7;
                    String string8;
                    string = string2.getUri();
                    string6 = string2.getLocalName();
                    if (string == null || string.length() == 0) {
                        bl = false;
                        string8 = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                        Tr.error((TraceComponent)tc, (String)string8);
                        string7 = ConfigConstants.getMessage(string8);
                        string4 = string4 == null || string4.length() == 0 ? new String(string7) : new String(string4 + " ; " + string7);
                    }
                    if (string6 == null || string6.length() == 0) {
                        bl = false;
                        string8 = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                        Tr.error((TraceComponent)tc, (String)string8);
                        string7 = ConfigConstants.getMessage(string8);
                        string4 = string4 == null || string4.length() == 0 ? new String(string7) : new String(string4 + " ; " + string7);
                    }
                }
            }
            if ((string2 = loginBinding.getCallbackHandler()) == null || string2.length() == 0) {
                bl = false;
                string = "security.wssecurity.ConfigValidation.lb.missing.callbackhandler";
                Tr.error((TraceComponent)tc, (String)string);
                string6 = ConfigConstants.getMessage(string);
                string4 = string4 == null || string4.length() == 0 ? new String(string6) : new String(string4 + " ; " + string6);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loginBindingValid() returns " + bl));
        }
        return bl;
    }

    private boolean authMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("authMethodValid(" + string + ")"));
        }
        boolean bl = false;
        bl = string != null && string.length() != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("authMethodValid() returns " + bl));
        }
        return bl;
    }

    private boolean authMethodKnown(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("authMethodKnown(" + string + ")"));
        }
        boolean bl = false;
        bl = string == null || string.length() == 0 ? false : "BasicAuth".equals(string) || "IDAssertion".equals(string) || "Signature".equals(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("authMethodKnown() returns " + bl));
        }
        return bl;
    }

    private void addToSet(Document document, String string, Set set) {
        NodeList nodeList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addToSet(" + document + ", " + string + ", " + set + ")"));
        }
        if ((n = (nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", string)).getLength()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No allowed " + string + " elements found."));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                try {
                    set.add(DOMUtil.getAttribute((Element)element, (String)"algorithm"));
                    continue;
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException((Throwable)soapSecurityException, (String)(clsName + ".addToSet"), (String)"1819", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("\"algorithm\" attribute not found in \"" + string + "\" element."));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Allowed " + string + " set: "), (Object)new Object[]{set});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToSet()");
        }
    }

    protected void processAllowedAlgorithms(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processAllowedAlgorithms(" + document + ")"));
        }
        if (document == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Allowed Algorithms Document is null, exiting.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"processAllowedAlgorithms()");
            }
            return;
        }
        this.addToSet(document, "encryptionMethod", this.allowedEncAlgos);
        this.addToSet(document, "keyEncryptionMethod", this.allowedKeyEncAlgos);
        this.addToSet(document, "canonicalizationMethod", this.allowedC14nAlgos);
        this.addToSet(document, "signatureMethod", this.allowedSignAlgos);
        this.addToSet(document, "digestMethod", this.allowedDigestAlgos);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processAllowedAlgorithms()");
        }
    }

    protected boolean encryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encryptionMethodValid(" + string + ")"));
        }
        boolean bl = this.allowedEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptionMethodValid() returns " + bl));
        }
        return bl;
    }

    protected boolean keyEncryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("keyEncryptionMethodValid(" + string + ")"));
        }
        boolean bl = this.allowedKeyEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("keyEncryptionMethodValid() returns " + bl));
        }
        return bl;
    }

    protected boolean canonicalizationMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("canonicalizationMethodValid(" + string + ")"));
        }
        boolean bl = this.allowedC14nAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("canonicalizationMethodValid() returns " + bl));
        }
        return bl;
    }

    protected boolean signatureMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("signatureMethodValid(" + string + ")"));
        }
        boolean bl = this.allowedSignAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("signatureMethodValid() returns " + bl));
        }
        return bl;
    }

    protected boolean digestMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("digestMethodValid(" + string + ")"));
        }
        boolean bl = this.allowedDigestAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("digestMethodValid() returns " + bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

