/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.module.WSSecurityMappingModule;
import com.ibm.xml.soapsec.util.Tr;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SignatureLoginModule
extends WSSecurityMappingModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private String username = null;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private Map properties = null;
    private WSCredential credential = null;
    private WSPrincipal principal = null;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule == null ? (class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule = SignatureLoginModule.class$("com.ibm.wsspi.wssecurity.auth.module.SignatureLoginModule")) : class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule).getName();
    private static final TraceComponent tc = com.ibm.ejs.ras.Tr.register((Class)(class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule == null ? (class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule = SignatureLoginModule.class$("com.ibm.wsspi.wssecurity.auth.module.SignatureLoginModule")) : class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission PERM = new WebSphereRuntimePermission("wssecurity.SignatureLoginModule.login");
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$auth$module$SignatureLoginModule;

    public SignatureLoginModule() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"SignatureLoginModule()");
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)"SignatureLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        super.initialize(subject, callbackHandler, map, map2);
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"initialize()", (Object)new Object[]{subject, callbackHandler, map, map2});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)"initialize()");
        }
    }

    public boolean login() throws LoginException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"login()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)PERM);
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user.");
        }
        this.succeeded = false;
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PropertyCallback(null)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)("login() - username is " + this.username));
            }
            this.properties = ((PropertyCallback)callbackArray[1]).getProperties();
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)("login() - properties are " + this.properties));
            }
        }
        catch (IOException iOException) {
            Tr.processException((Throwable)iOException, (String)(clsName + ".login"), (String)"127", (Object)this);
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            Tr.processException((Throwable)unsupportedCallbackException, (String)(clsName + ".login"), (String)"130", (Object)this);
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication" + " information from the user");
        }
        this.succeeded = this._login(this.username);
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)("login() returns " + this.succeeded + ", username is " + this.username));
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        this.commitSucceeded = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Do not commit() because login() failed.");
            }
        } else {
            try {
                if (this.debug || tc.isDebugEnabled()) {
                    com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Starting to commit changes to subject.");
                }
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        SignatureLoginModule.this.credential = SignatureLoginModule.this.wscred;
                        SignatureLoginModule.this.principal = SignatureLoginModule.this.wsprin;
                        return null;
                    }
                });
                if (this.credential != null && this.principal != null) {
                    AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            if (!SignatureLoginModule.this.subject.getPrincipals().contains(SignatureLoginModule.this.principal)) {
                                SignatureLoginModule.this.subject.getPrincipals().add((Principal)SignatureLoginModule.this.principal);
                            }
                            if (!SignatureLoginModule.this.subject.getPublicCredentials().contains(SignatureLoginModule.this.credential)) {
                                SignatureLoginModule.this.subject.getPublicCredentials().add(SignatureLoginModule.this.credential);
                            }
                            return null;
                        }
                    });
                    if (this.debug || tc.isDebugEnabled()) {
                        com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Commit succeeded!");
                    }
                    this.commitSucceeded = true;
                } else if (this.debug || tc.isDebugEnabled()) {
                    if (this.credential == null) {
                        com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Unable to retrieve WSCredential.");
                    }
                    if (this.principal == null) {
                        com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Unable to retrieve WSPrincipal.");
                    }
                }
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, (String)(clsName + ".commit"), (String)"234", (Object)this);
                throw new LoginException(exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)("commit() returns " + this.commitSucceeded));
        }
        return this.commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                block12: {
                    block10: {
                        if (SignatureLoginModule.this.principal != null) {
                            try {
                                if (SignatureLoginModule.this.subject.getPrincipals().contains(SignatureLoginModule.this.principal)) {
                                    SignatureLoginModule.this.subject.getPrincipals().remove(SignatureLoginModule.this.principal);
                                }
                            }
                            catch (Exception exception) {
                                Tr.processException((Throwable)exception, (String)(clsName + ".run"), (String)"293", (Object)this);
                                if (!SignatureLoginModule.this.debug && !tc.isDebugEnabled()) break block10;
                                com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Unable to remove principal from subject.");
                            }
                        }
                    }
                    if (SignatureLoginModule.this.credential != null) {
                        block11: {
                            try {
                                if (SignatureLoginModule.this.subject.getPublicCredentials().contains(SignatureLoginModule.this.credential)) {
                                    SignatureLoginModule.this.subject.getPublicCredentials().remove(SignatureLoginModule.this.credential);
                                }
                            }
                            catch (Exception exception) {
                                Tr.processException((Throwable)exception, (String)(clsName + ".run"), (String)"307", (Object)this);
                                if (!SignatureLoginModule.this.debug && !tc.isDebugEnabled()) break block11;
                                com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Unable to remove credential from subject.");
                            }
                        }
                        try {
                            SignatureLoginModule.this.credential.destroy();
                        }
                        catch (Exception exception) {
                            Tr.processException((Throwable)exception, (String)(clsName + ".run"), (String)"316", (Object)this);
                            if (!SignatureLoginModule.this.debug && !tc.isDebugEnabled()) break block12;
                            com.ibm.ejs.ras.Tr.debug((TraceComponent)tc, (String)"Unable to destroy credential.");
                        }
                    }
                }
                return null;
            }
        });
        this.principal = null;
        this.credential = null;
        if (tc.isEntryEnabled()) {
            com.ibm.ejs.ras.Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

