/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.Constants;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSSecurityMappingModule
implements LoginModule,
Constants {
    private Subject s;
    private CallbackHandler cbh;
    private Map states;
    private Map options;
    private boolean successful = false;
    private boolean committed = false;
    private boolean debug = false;
    protected WSCredential wscred;
    protected WSPrincipal wsprin;
    private static final WebSphereRuntimePermission PERM = new WebSphereRuntimePermission("wssecurity.WSSecurityMappingModule.login");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule == null ? (class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule = WSSecurityMappingModule.class$("com.ibm.wsspi.wssecurity.auth.module.WSSecurityMappingModule")) : class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule;
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$WSPrincipal;

    public WSSecurityMappingModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSSecurityMappingModule");
            Tr.exit((TraceComponent)tc, (String)"WSSecurityMappingModule");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"initialize(Subject, CallbackHandler, sharedState, options)", (Object)new Object[]{subject, callbackHandler, map, map2});
        }
        this.s = subject;
        this.cbh = callbackHandler;
        this.states = map;
        this.options = map2;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"login");
        }
        this.clear();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)PERM);
        }
        String string = (String)this.states.get("com.ibm.wsspi.wssecurity.Constants.DN");
        return this._login(string);
    }

    boolean _login(String string) throws LoginException {
        Set set;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"_login");
        }
        if (string == null || string.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.novalidated.dn");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.novalidated.dn"));
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.ctxmgr.isnull"));
        }
        String string2 = contextManager.getDefaultRealm();
        Subject subject = null;
        try {
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)("Mapping \"" + string + "\" to a WSCredential and WSPrincipal ..."));
            }
            subject = contextManager.login(string2, string);
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)("\"" + string + "\" is mapped to " + subject));
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)((class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule == null ? (class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule = WSSecurityMappingModule.class$("com.ibm.wsspi.wssecurity.auth.module.WSSecurityMappingModule")) : class$com$ibm$wsspi$wssecurity$auth$module$WSSecurityMappingModule).getName() + ".login"), (String)"145", (Object)this);
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw wSLoginFailedException;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Extracting WSCredential and WSPrincipal from mapped subject.");
        }
        if ((set = subject.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = WSSecurityMappingModule.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential)) == null || set.size() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.nocred.found"));
        }
        if (set.size() > 1) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.more.than.one.cred.found");
        }
        this.wscred = (WSCredential)set.iterator().next();
        if (this.wscred == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.nocred.found"));
        }
        Set set2 = subject.getPrincipals(class$com$ibm$websphere$security$auth$WSPrincipal == null ? (class$com$ibm$websphere$security$auth$WSPrincipal = WSSecurityMappingModule.class$("com.ibm.websphere.security.auth.WSPrincipal")) : class$com$ibm$websphere$security$auth$WSPrincipal);
        if (set2 == null || set2.size() == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprin.found");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.noprin.found"));
        }
        if (set2.size() > 1) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.more.than.one.prin.found");
        }
        this.wsprin = (WSPrincipal)set2.iterator().next();
        if (this.wsprin == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprin.found");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit((TraceComponent)tc, (String)"_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.noprin.found"));
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Extracted WSCredential", (Object)this.wscred);
            Tr.debug((TraceComponent)tc, (String)"Extracted WSPrincipal", (Object)this.wsprin);
        }
        if (this.wscred != null) {
            this.states.put("com.ibm.wsspi.wssecurity.Constants.WSCredential", this.wscred);
        }
        this.successful = true;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)("_login: " + this.successful));
        }
        return this.successful;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        if (!this.successful) {
            Tr.error((TraceComponent)tc, (String)ConfigConstants.getMessage("security.wssecurity.notyet.login"));
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.notyet.login"));
        }
        if (this.committed) {
            Tr.warning((TraceComponent)tc, (String)ConfigConstants.getMessage("security.wssecurity.already.committed"));
        }
        if (this.wscred == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.nocred.found");
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.nocred.found"));
        }
        if (this.wsprin == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.noprin.found");
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.noprin.found"));
        }
        if (tc.isDebugEnabled() || this.debug) {
            Tr.debug((TraceComponent)tc, (String)"Starting to commit changes to Subject");
        }
        if (this.s.getPrincipals().contains(this.wsprin)) {
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)(this.wsprin + " already in the subject, remove it first before commit"));
            }
            this.s.getPrincipals().remove(this.wsprin);
        }
        this.s.getPrincipals().add((Principal)this.wsprin);
        if (this.s.getPublicCredentials().contains(this.wscred)) {
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)(this.wscred + " already in the subject, remove it first before commit"));
            }
            this.s.getPublicCredentials().remove(this.wscred);
        }
        this.s.getPublicCredentials().add(this.wscred);
        if (tc.isDebugEnabled() || this.debug) {
            Tr.debug((TraceComponent)tc, (String)"Changes committed to Subject", (Object)this.s);
        }
        this.committed = true;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)("commit: " + this.committed));
        }
        return this.committed;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"abort");
        }
        this.clear();
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)"abort: true");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"logout");
        }
        this.clear();
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)"logout: true");
        }
        return true;
    }

    private void clear() {
        boolean bl;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry((TraceComponent)tc, (String)"clear");
        }
        this.successful = false;
        this.committed = false;
        if (this.wsprin != null) {
            bl = this.s.getPrincipals().remove(this.wsprin);
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)("Removed WSPrincipal: " + bl));
            }
        }
        if (this.wscred != null) {
            bl = this.s.getPublicCredentials().remove(this.wsprin);
            if (tc.isDebugEnabled() || this.debug) {
                Tr.debug((TraceComponent)tc, (String)("Removed WSCredential: " + bl));
            }
        }
        this.states.remove("com.ibm.wsspi.wssecurity.Constants.WSCredential");
        this.wsprin = null;
        this.wscred = null;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

