/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CertInRequestKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator = CertInRequestKeyLocator.class$("com.ibm.wsspi.wssecurity.config.CertInRequestKeyLocator")) : class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator = CertInRequestKeyLocator.class$("com.ibm.wsspi.wssecurity.config.CertInRequestKeyLocator")) : class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator).getName();
    private static final String F_CERTIFICATE = clsName + ".fCert";
    private static final String F_KEY = clsName + ".fKey";
    private static final String F_NAME = clsName + ".fName";
    private static final String F_NAMES = clsName + ".fNames";
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$config$CertInRequestKeyLocator;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    private void getCertInRequest(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertInRequest(" + object + ")"));
        }
        if (!(object instanceof Map)) {
            throw new KeyLocatorException("Internal error: invalid context object.");
        }
        Object v = ((Map)object).get("com.ibm.xml.soapsec.RequestCert");
        if (!(v instanceof X509Certificate)) {
            String string = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)string);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)string));
        }
        MessageContext messageContext = this.getMessageContext();
        X509Certificate x509Certificate = (X509Certificate)v;
        messageContext.setProperty(F_CERTIFICATE, (Object)x509Certificate);
        messageContext.setProperty(F_KEY, (Object)x509Certificate.getPublicKey());
        String string = x509Certificate.getSubjectDN().getName();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        messageContext.setProperty(F_NAME, (Object)string);
        messageContext.setProperty(F_NAMES, hashSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCertInRequest(Object context)");
        }
    }

    public Set getNames(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNames(" + object + ")"));
        }
        if (this.getFName() == null) {
            this.getCertInRequest(object);
        }
        Set set = this.getFNames();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNames(Object context) returns " + set));
        }
        return set;
    }

    public Key getEncryptionKey(String string, Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + string + "," + object + ")"));
        }
        if (this.getFCert() == null) {
            this.getCertInRequest(object);
        }
        Key key = this.getFKey();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getDecryptionKey(String string, Object object) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getSigningKey(String string) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public Key getVerificationKey(String string) throws KeyLocatorException {
        throw new KeyLocatorException("Not implemented.");
    }

    public String getName(Key key) throws KeyLocatorException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + key + ")"));
        }
        if ((string = this.getFName()) == null) {
            String string2 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)string2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(Key key) returns " + string));
        }
        return string;
    }

    public String getName(String string) throws KeyLocatorException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + string + ")"));
        }
        if ((string2 = this.getFName()) == null) {
            String string3 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)string3);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)string3));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(String name) returns " + string2));
        }
        return string2;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        X509Certificate x509Certificate;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + key + ")"));
        }
        if ((x509Certificate = this.getFCert()) == null) {
            String string = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)string);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(Key key) returns " + x509Certificate));
        }
        return x509Certificate;
    }

    public Certificate getCertificate(String string) throws KeyLocatorException {
        X509Certificate x509Certificate;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + string + ")"));
        }
        if ((x509Certificate = this.getFCert()) == null) {
            String string2 = "security.wssecurity.CertInRequestKeyLocator.nocert";
            Tr.error((TraceComponent)tc, (String)string2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + x509Certificate));
        }
        return x509Certificate;
    }

    private MessageContext getMessageContext() throws KeyLocatorException {
        MessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMessageContext()");
        }
        if ((messageContext = MessageContext.getCurrentThreadsContext()) == null) {
            throw new KeyLocatorException("Internal error: message context is null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessageContext()");
        }
        return messageContext;
    }

    private X509Certificate getFCert() throws KeyLocatorException {
        return (X509Certificate)this.getMessageContext().getProperty(F_CERTIFICATE);
    }

    private Key getFKey() throws KeyLocatorException {
        return (Key)this.getMessageContext().getProperty(F_KEY);
    }

    private String getFName() throws KeyLocatorException {
        return (String)this.getMessageContext().getProperty(F_NAME);
    }

    private Set getFNames() throws KeyLocatorException {
        return (Set)this.getMessageContext().getProperty(F_NAMES);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

