/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KeyStoreKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator = KeyStoreKeyLocator.class$("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator")) : class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator), (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = (class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator == null ? (class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator = KeyStoreKeyLocator.class$("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator")) : class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator).getName();
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DEFAULT_DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private static final String DAYS_BEFORE_EXPIRE_WARNING_KEYS = "com.ibm.ws.wssecurity.daysBeforeExpireWarning";
    private Map fName2Container = new HashMap();
    private Map fName2PrivContainer = new HashMap();
    private Map fKey2Container = new HashMap();
    private String fDefaultName;
    private String path;
    private long daysInMSBeforeExpireWarning = 5184000000L;
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$config$KeyStoreKeyLocator;

    protected String getDefaultBasePath() {
        return null;
    }

    public void init(Map map) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        String string = null;
        char[] cArray = null;
        HashMap hashMap = new HashMap();
        HashMap<String, char[]> hashMap2 = new HashMap<String, char[]>();
        HashMap hashMap3 = new HashMap();
        Iterator iterator = null;
        String string2 = this.getDefaultBasePath();
        Object object3 = map.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = (String)map.get(object2);
            if (((String)object2).equals("type")) {
                string = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore type: " + (String)object));
                continue;
            }
            if (((String)object2).equals("path")) {
                this.path = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore path: " + object));
                continue;
            }
            if (((String)object2).equals("base")) {
                string2 = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore base: " + object));
                continue;
            }
            if (((String)object2).equals("storepass")) {
                cArray = ((String)object).toCharArray();
                continue;
            }
            if (((String)object2).startsWith("alias_")) {
                hashMap.put(((String)object2).substring("alias_".length()), object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore " + (String)object2 + ": " + object));
                continue;
            }
            if (((String)object2).startsWith("keypass_")) {
                hashMap2.put(((String)object2).substring("keypass_".length()), ((String)object).toCharArray());
                continue;
            }
            if (((String)object2).startsWith("name_")) {
                hashMap3.put(((String)object2).substring("name_".length()), object);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore " + (String)object2 + ": " + (String)object));
                continue;
            }
            if (((String)object2).equals("default")) {
                iterator = object;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("init() - keystore default: " + object));
                continue;
            }
            if (!((String)object2).equals(DAYS_BEFORE_EXPIRE_WARNING_KEYS)) continue;
            if (object != null && ((String)object).length() != 0) {
                if (((String)(object = ((String)object).trim())).length() != 0) {
                    long l = 0L;
                    try {
                        l = Long.parseLong((String)object);
                        this.daysInMSBeforeExpireWarning = l * 86400000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Tr.processException((Throwable)numberFormatException, (String)(clsName + ".init"), (String)"153", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{DAYS_BEFORE_EXPIRE_WARNING_KEYS, object, new Long(60L)});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"init() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"init() - no value define for: com.ibm.ws.wssecurity.daysBeforeExpireWarning");
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("init() - days before expire warning: " + this.daysInMSBeforeExpireWarning / 86400000L));
        }
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        if (this.path == null) {
            throw new NullPointerException("Keystore path not specified");
        }
        object3 = ConfigUtil.fixPath((String)this.path, (String)string2);
        this.path = ((File)object3).getAbsolutePath();
        object2 = ConfigUtil.getKeyStore((String)string, (File)object3, cArray);
        try {
            Object object4;
            Object object5;
            object = ((KeyStore)object2).aliases();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                object5 = this.validateCert(string3, ((KeyStore)object2).getCertificate(string3));
                if (object5 == null) continue;
                object4 = new KeyContainer((X509Certificate)object5);
                this.fName2Container.put(((KeyContainer)object4).getName(), object4);
                this.fKey2Container.put(((KeyContainer)object4).getKey(), object4);
            }
            object = hashMap3.keySet().iterator();
            while (object.hasNext()) {
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                String string4 = (String)object.next();
                object5 = (String)hashMap.get(string4);
                if (object5 == null) continue;
                object4 = ((KeyStore)object2).getCertificate((String)object5);
                if (object4 != null) {
                    object9 = this.validateCert((String)object5, (Certificate)object4);
                    if (object9 == null) continue;
                    object8 = (String)hashMap3.get(string4);
                    object7 = new KeyContainer((String)object8, (X509Certificate)object9);
                    this.fName2Container.put(((KeyContainer)object7).getName(), object7);
                    this.fKey2Container.put(((KeyContainer)object7).getKey(), object7);
                    object6 = (char[])hashMap2.get(string4);
                    if (object6 == null) continue;
                    try {
                        Key key = ((KeyStore)object2).getKey((String)object5, (char[])hashMap2.get(string4));
                        if (key == null) continue;
                        object7 = new KeyContainer((String)object8, key, (Certificate)object9);
                        this.fName2PrivContainer.put(((KeyContainer)object7).getName(), object7);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("KeyStoreKeyLocator.init() - added priv key for name " + ((KeyContainer)object7).getName()));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".init"), (String)"221", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{object5, this.path, noSuchAlgorithmException});
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        Tr.processException((Throwable)unrecoverableKeyException, (String)(clsName + ".init"), (String)"224", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{object5, this.path, unrecoverableKeyException});
                    }
                    continue;
                }
                object9 = (char[])hashMap2.get(string4);
                if (object9 == null) continue;
                try {
                    object8 = ((KeyStore)object2).getKey((String)object5, (char[])object9);
                    if (object8 == null) continue;
                    object7 = (String)hashMap3.get(string4);
                    object6 = new KeyContainer((String)object7, (Key)object8, null);
                    this.fName2Container.put(((KeyContainer)object6).getName(), object6);
                    this.fKey2Container.put(((KeyContainer)object6).getKey(), object6);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".init"), (String)"244", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{object5, this.path, noSuchAlgorithmException});
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    Tr.processException((Throwable)unrecoverableKeyException, (String)(clsName + ".init"), (String)"247", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{object5, this.path, unrecoverableKeyException});
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            Tr.processException((Throwable)keyStoreException, (String)(clsName + ".init"), (String)"255", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.exception", (Object)new Object[]{this.path, keyStoreException});
            throw new SoapSecurityException(keyStoreException);
        }
        if (iterator != null) {
            this.fDefaultName = KeyStoreKeyLocator.encodedName(iterator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    private X509Certificate validateCert(String string, Certificate certificate) {
        X509Certificate x509Certificate = null;
        if (certificate != null && certificate instanceof X509Certificate) {
            x509Certificate = (X509Certificate)certificate;
            try {
                x509Certificate.checkValidity();
                if (x509Certificate.getNotAfter().getTime() - System.currentTimeMillis() < this.daysInMSBeforeExpireWarning) {
                    long l = x509Certificate.getNotAfter().getTime() - System.currentTimeMillis();
                    long l2 = l / 86400000L;
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), string, this.path, new Long(l2)});
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Tr.processException((Throwable)certificateExpiredException, (String)(clsName + ".validateCert"), (String)"282", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), string, this.path, certificateExpiredException});
                x509Certificate = null;
            }
            catch (CertificateException certificateException) {
                Tr.processException((Throwable)certificateException, (String)(clsName + ".validateCert"), (String)"286", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{x509Certificate.getSubjectDN().getName(), string, this.path, certificateException});
                x509Certificate = null;
            }
        }
        return x509Certificate;
    }

    public Set getNames(Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNames(" + object + ")"));
        }
        Set set = this.fName2Container.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNames(Object context) returns " + set));
        }
        return set;
    }

    protected Key getConfidentialKey(String string, Object object) throws KeyLocatorException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConfidentialKey(" + string + "," + object + ")"));
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Key key = null;
        if (string != null) {
            object2 = (KeyContainer)this.fName2PrivContainer.get(string);
            if (object2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getConfidentialKey - priv key NOT found for " + string));
                    Tr.debug((TraceComponent)tc, (String)("getConfidentialKey - priv container map: " + this.fName2PrivContainer));
                }
                object2 = (KeyContainer)this.fName2Container.get(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getConfKey - priv key found for " + string));
            }
            if (object2 != null) {
                key = ((KeyContainer)object2).getKey();
            }
        }
        if (key == null) {
            object2 = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error((TraceComponent)tc, (String)object2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)object2) + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConfidentialKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getEncryptionKey(String string, Object object) throws KeyLocatorException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + string + "," + object + ")"));
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Key key = null;
        if (string != null && (object2 = (KeyContainer)this.fName2Container.get(string)) != null) {
            key = ((KeyContainer)object2).getKey();
        }
        if (key == null) {
            object2 = "security.wssecurity.KeyStoreKeyLocator.s41";
            Tr.error((TraceComponent)tc, (String)object2);
            throw new KeyLocatorException(ConfigUtil.getMessage((String)object2) + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getDecryptionKey(String string, Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDecryptionKey(" + string + "," + object + ")"));
        }
        Key key = this.getConfidentialKey(string, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDecryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Key getSigningKey(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSigningKey(" + string + ")"));
        }
        Key key = this.getConfidentialKey(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSigningKey(String name) returns " + key));
        }
        return key;
    }

    public Key getVerificationKey(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getVefificationKey(" + string + ")"));
        }
        Key key = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVerificationKey(String name) returns " + key));
        }
        return key;
    }

    public String getName(Key key) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + key + ")"));
        }
        String string = null;
        if (key != null && (keyContainer = (KeyContainer)this.fKey2Container.get(key)) != null) {
            string = keyContainer.getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(Key key) returns " + string));
        }
        return string;
    }

    public Certificate getCertificate(Key key) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + key + ")"));
        }
        Certificate certificate = null;
        if (key != null && (keyContainer = (KeyContainer)this.fKey2Container.get(key)) != null) {
            certificate = keyContainer.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(Key key) returns " + certificate));
        }
        return certificate;
    }

    public Certificate getCertificate(String string) throws KeyLocatorException {
        KeyContainer keyContainer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + string + ")"));
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        Certificate certificate = null;
        if (string != null && (keyContainer = (KeyContainer)this.fName2Container.get(string)) != null) {
            certificate = keyContainer.getCertificate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + certificate));
        }
        return certificate;
    }

    public static String encodedName(String string) throws KeyLocatorException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("encodedName(" + string + ")"));
        }
        if ((string2 = KeyInfo.X509Data.encodeDName((String)string)) == null) {
            String string3 = "security.wssecurity.KeyStoreKeyLocator.malformedname";
            Tr.error((TraceComponent)tc, (String)string3, (Object)new Object[]{string});
            throw new KeyLocatorException(MessageFormat.format(ConfigUtil.getMessage((String)string3), string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encodedName(String dn) returns " + string2));
        }
        return string2;
    }

    public String getName(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getName(" + string + ")"));
        }
        string = string != null ? KeyStoreKeyLocator.encodedName(string) : this.fDefaultName;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getName(String name) returns " + string));
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class KeyContainer {
        private String fName;
        private Key fKey;
        private Certificate fCertificate;

        KeyContainer(X509Certificate x509Certificate) throws KeyLocatorException {
            this(x509Certificate.getSubjectDN().getName(), x509Certificate);
        }

        KeyContainer(String string, X509Certificate x509Certificate) throws KeyLocatorException {
            this(string, x509Certificate.getPublicKey(), x509Certificate);
        }

        KeyContainer(String string, Key key, Certificate certificate) throws KeyLocatorException {
            this.fName = KeyStoreKeyLocator.encodedName(string);
            this.fKey = key;
            this.fCertificate = certificate;
        }

        String getName() {
            return this.fName;
        }

        Key getKey() {
            return this.fKey;
        }

        Certificate getCertificate() {
            return this.fCertificate;
        }
    }
}

