/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.plugins.RegistryResolver;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;

public class PluginRegistryModel {
    private Map plugins = new HashMap(30);
    private Map fragments = new HashMap(30);
    private boolean readOnly = false;
    private boolean resolved = false;

    public void addFragment(PluginFragmentModel fragment) {
        this.assertIsWriteable();
        String key = fragment.getId();
        PluginFragmentModel[] list = this.getFragments(key);
        if (list == null) {
            list = new PluginFragmentModel[]{fragment};
            this.fragments.put(key, list);
        } else {
            PluginFragmentModel[] newList = new PluginFragmentModel[list.length + 1];
            System.arraycopy(list, 0, newList, 0, list.length);
            newList[list.length] = fragment;
            this.fragments.put(key, newList);
        }
    }

    public void addPlugin(PluginDescriptorModel plugin) {
        this.assertIsWriteable();
        String key = plugin.getId();
        PluginDescriptorModel[] pluginList = this.getPlugins(key);
        if (pluginList == null) {
            pluginList = new PluginDescriptorModel[]{plugin};
            this.plugins.put(key, pluginList);
        } else {
            int i = 0;
            while (i < pluginList.length) {
                if (pluginList[i].getVersion().equals(plugin.getVersion())) {
                    pluginList[i] = plugin;
                    return;
                }
                ++i;
            }
            PluginDescriptorModel[] newPluginList = new PluginDescriptorModel[pluginList.length + 1];
            System.arraycopy(pluginList, 0, newPluginList, 0, pluginList.length);
            newPluginList[pluginList.length] = plugin;
            this.plugins.put(key, newPluginList);
        }
    }

    protected void assertIsWriteable() {
        Assert.isTrue(!this.isReadOnly(), "Model is read-only");
    }

    public PluginFragmentModel getFragment(String id) {
        PluginFragmentModel[] result = (PluginFragmentModel[])this.fragments.get(id);
        return result == null ? null : result[0];
    }

    public PluginFragmentModel getFragment(String id, String version) {
        PluginFragmentModel[] list = this.getFragments(id);
        if (list == null || list.length == 0) {
            return null;
        }
        if (version == null) {
            return list[0];
        }
        int i = 0;
        while (i < list.length) {
            PluginFragmentModel element = list[i];
            if (element.getVersion().equals(version)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public PluginFragmentModel[] getFragments() {
        ArrayList<PluginFragmentModel> result = new ArrayList<PluginFragmentModel>(this.fragments.size());
        Iterator i = this.fragments.values().iterator();
        while (i.hasNext()) {
            PluginFragmentModel[] entries = (PluginFragmentModel[])i.next();
            int j = 0;
            while (j < entries.length) {
                result.add(entries[j]);
                ++j;
            }
        }
        return result.toArray(new PluginFragmentModel[result.size()]);
    }

    public PluginFragmentModel[] getFragments(String id) {
        return (PluginFragmentModel[])this.fragments.get(id);
    }

    public PluginDescriptorModel getPlugin(String pluginId) {
        PluginDescriptorModel[] result = (PluginDescriptorModel[])this.plugins.get(pluginId);
        return result == null ? null : result[0];
    }

    public PluginDescriptorModel getPlugin(String pluginId, String version) {
        PluginDescriptorModel[] list = this.getPlugins(pluginId);
        if (list == null || list.length == 0) {
            return null;
        }
        if (version == null) {
            return list[0];
        }
        int i = 0;
        while (i < list.length) {
            PluginDescriptorModel element = list[i];
            if (element.getVersion().equals(version)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public PluginDescriptorModel[] getPlugins() {
        ArrayList<PluginDescriptorModel> result = new ArrayList<PluginDescriptorModel>(this.plugins.size());
        Iterator i = this.plugins.values().iterator();
        while (i.hasNext()) {
            PluginDescriptorModel[] entries = (PluginDescriptorModel[])i.next();
            int j = 0;
            while (j < entries.length) {
                result.add(entries[j]);
                ++j;
            }
        }
        return result.toArray(new PluginDescriptorModel[result.size()]);
    }

    public PluginDescriptorModel[] getPlugins(String pluginId) {
        return (PluginDescriptorModel[])this.plugins.get(pluginId);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void markReadOnly() {
        int i;
        PluginModel[] list;
        this.readOnly = true;
        Iterator it = this.plugins.values().iterator();
        while (it.hasNext()) {
            list = (PluginDescriptorModel[])it.next();
            i = 0;
            while (i < list.length) {
                list[i].markReadOnly();
                ++i;
            }
        }
        it = this.fragments.values().iterator();
        while (it.hasNext()) {
            list = (PluginFragmentModel[])it.next();
            i = 0;
            while (i < list.length) {
                list[i].markReadOnly();
                ++i;
            }
        }
    }

    public void markResolved() {
        this.resolved = true;
    }

    public void removeFragment(String id, String version) {
        this.assertIsWriteable();
        PluginFragmentModel[] list = this.getFragments(id);
        if (list == null || list.length == 0) {
            return;
        }
        int removedCount = 0;
        int i = 0;
        while (i < list.length) {
            if (version.equals(list[i].getVersion())) {
                list[i] = null;
                ++removedCount;
            }
            ++i;
        }
        if (removedCount == list.length) {
            this.removeFragments(id);
        } else {
            PluginFragmentModel[] newList = new PluginFragmentModel[list.length - removedCount];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2] != null) {
                    newList[index++] = list[i2];
                }
                ++i2;
            }
            this.fragments.put(id, newList);
        }
    }

    public void removeFragments(String id) {
        this.assertIsWriteable();
        this.fragments.remove(id);
    }

    public void removePlugin(String pluginId, String version) {
        this.assertIsWriteable();
        PluginDescriptorModel[] plugins = this.getPlugins(pluginId);
        if (plugins == null || plugins.length == 0) {
            return;
        }
        int removedCount = 0;
        int i = 0;
        while (i < plugins.length) {
            if (version.equals(plugins[i].getVersion())) {
                plugins[i] = null;
                ++removedCount;
            }
            ++i;
        }
        if (removedCount == plugins.length) {
            this.removePlugins(pluginId);
        } else {
            PluginDescriptorModel[] newList = new PluginDescriptorModel[plugins.length - removedCount];
            int index = 0;
            int i2 = 0;
            while (i2 < plugins.length) {
                if (plugins[i2] != null) {
                    newList[index++] = plugins[i2];
                }
                ++i2;
            }
            this.plugins.put(pluginId, newList);
        }
    }

    public void removePlugins(String pluginId) {
        this.assertIsWriteable();
        this.plugins.remove(pluginId);
    }

    public IStatus resolve(boolean trimDisabledPlugins, boolean doCrossLinking) {
        RegistryResolver resolver = new RegistryResolver();
        resolver.setTrimPlugins(trimDisabledPlugins);
        resolver.setCrossLink(doCrossLinking);
        return resolver.resolve(this);
    }
}

