/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.commons.logging;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import org.apache.commons.logging.Log;

public final class TrLog
implements Log {
    private TraceComponent tc = null;
    private static final String ibm = "IBM";
    private static final String webSphere = "WebSphere";
    private static final String method = "";
    private static String component = null;

    public TrLog(String string, String string2) {
        component = string2;
        this.tc = Tr.register(string, string2, null);
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.trace(5, object.toString());
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.trace(5, object.toString());
            this.trace(5, throwable);
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.trace(2, object.toString());
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.trace(2, object.toString());
            this.trace(2, throwable);
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.log(11, object.toString());
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(11, object.toString());
            this.log(11, throwable);
        }
    }

    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.log(10, object.toString());
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(10, object.toString());
            this.log(10, throwable);
        }
    }

    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.log(4, object.toString());
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(4, object.toString());
            this.log(4, throwable);
        }
    }

    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.log(8, object.toString());
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.log(8, object.toString());
            this.log(8, throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.tc.isEventEnabled();
    }

    public boolean isDebugEnabled() {
        return this.tc.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    private void log(int n, String string) {
        try {
            MessageEvent messageEvent = new MessageEvent(n, this.tc, string, null, null, ibm, webSphere, component, this.tc.getName(), method, null);
            Tr.logJrasEvent(messageEvent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void log(int n, Throwable throwable) {
        try {
            String string = "com.ibm.ejs.resources.RasMessages";
            String string2 = RasHelper.throwableToString(throwable);
            MessageEvent messageEvent = new MessageEvent(n, this.tc, "MSG_EXCEPTION_LOGGED", string, string2, ibm, webSphere, component, this.tc.getName(), method, string2);
            Tr.logJrasEvent(messageEvent);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private void trace(int n, String string) {
        try {
            TraceEvent traceEvent = new TraceEvent(n, this.tc, string, null, ibm, webSphere, component, this.tc.getName(), method, null);
            Tr.logJrasEvent(traceEvent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void trace(int n, Throwable throwable) {
        try {
            String string = RasHelper.throwableToString(throwable);
            TraceEvent traceEvent = new TraceEvent(n, this.tc, "The following exception was logged", (Object)string, ibm, webSphere, component, this.tc.getName(), method, string);
            Tr.logJrasEvent(traceEvent);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }
}

