/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class StartupSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long options_offset;
    private long options_end;
    private TraceFile traceFile;

    public StartupSection(TraceFile traceFile, int n) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.options_offset = traceFile.getFilePointer();
        this.options_end = n + this.length;
        Util.Debug.println("StartupSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("StartupSection: length:            " + this.length);
        Util.Debug.println("StartupSection: version:           " + this.version);
        Util.Debug.println("StartupSection: modification:      " + this.modification);
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        this.traceFile.seek(this.options_offset);
        byte[] byArray = new byte[(int)(this.options_end - this.options_offset)];
        Util.Debug.println("StartupSection: options_offset:        " + this.options_offset);
        Util.Debug.println("StartupSection: options_end:           " + this.options_end);
        bufferedWriter.write("JVM Start-up Params :");
        bufferedWriter.newLine();
        int n = 0;
        this.traceFile.read(byArray);
        for (n = 0; n < byArray.length; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            while (byArray[n] != 0) {
                stringBuffer.append((char)byArray[n]);
                ++n;
            }
            if (stringBuffer.length() == 0) break;
            bufferedWriter.write("        ");
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
    }
}

