/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;

public abstract class Reference {
    private Object referent;
    ReferenceQueue queue;
    Reference next;
    private static Reference processing = null;
    private static Lock lock = new Lock();
    private static Reference pending = null;

    private static native void initForReset();

    private static native Reference process(Object var0);

    public Object get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != ReferenceQueue.NULL && this.next != null;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    private void constructReference(Object object, ReferenceQueue referenceQueue) {
        this.referent = object;
        if (object == null) {
            this.queue = ReferenceQueue.NULL;
            this.next = this;
        } else {
            this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
            this.next = null;
        }
    }

    Reference(Object object) {
        this.constructReference(object, null);
    }

    Reference(Object object, ReferenceQueue referenceQueue) {
        if (referenceQueue == null) {
            throw new NullPointerException("Reference queue cannot be null");
        }
        this.constructReference(object, referenceQueue);
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        public void run() {
            Reference.initForReset();
            while (true) {
                Reference reference;
                if ((reference = Reference.process(lock)) == null) {
                    continue;
                }
                if (reference instanceof Cleaner) {
                    ((Cleaner)reference).clean();
                    continue;
                }
                ReferenceQueue referenceQueue = reference.queue;
                if (referenceQueue == ReferenceQueue.NULL) continue;
                referenceQueue.enqueue(reference);
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

