/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.ExtendedSystem;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;

class BreakDictionary {
    private char[] reverseColumnMap = null;
    private static int supportedVersion = 0;
    private int version;
    private CompactByteArray columnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public static void main(String[] stringArray) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String string = stringArray[0];
        BreakDictionary breakDictionary = new BreakDictionary(new FileInputStream(string));
        String string2 = "";
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        PrintWriter printWriter = null;
        if (string2.length() != 0) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UnicodeLittle"));
        }
        breakDictionary.printWordList("", 0, printWriter);
    }

    public void printWordList(String string, int n, PrintWriter printWriter) throws IOException {
        if (n == -1) {
            System.out.println(string);
            if (printWriter != null) {
                printWriter.println(string);
            }
        } else {
            for (int i = 0; i < this.numCols; ++i) {
                if (this.at(n, i) == 0) continue;
                this.printWordList(string + this.reverseColumnMap[i], this.at(n, i), printWriter);
            }
        }
    }

    public BreakDictionary(InputStream inputStream) throws IOException {
        this.readDictionaryFile(new DataInputStream(inputStream));
    }

    public void readDictionaryFile(DataInputStream dataInputStream) throws IOException {
        char c;
        this.version = dataInputStream.readInt();
        if (this.version != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + this.version + ") is unsupported", dataInputStream.toString(), "");
        }
        int n = dataInputStream.readInt();
        short[] sArray = new short[n];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        for (c = '\u0000'; c < byArray.length; ++c) {
            byArray[c] = dataInputStream.readByte();
        }
        this.columnMap = new CompactByteArray(sArray, byArray);
        this.numCols = dataInputStream.readInt();
        this.numColGroups = dataInputStream.readInt();
        n = dataInputStream.readInt();
        this.rowIndex = (short[])ExtendedSystem.newArray(Short.TYPE, n, this);
        for (c = '\u0000'; c < this.rowIndex.length; ++c) {
            this.rowIndex[c] = dataInputStream.readShort();
        }
        n = dataInputStream.readInt();
        this.rowIndexFlagsIndex = (short[])ExtendedSystem.newArray(Short.TYPE, n, this);
        for (c = '\u0000'; c < this.rowIndexFlagsIndex.length; ++c) {
            this.rowIndexFlagsIndex[c] = dataInputStream.readShort();
        }
        n = dataInputStream.readInt();
        this.rowIndexFlags = (int[])ExtendedSystem.newArray(Integer.TYPE, n, this);
        for (c = '\u0000'; c < this.rowIndexFlags.length; ++c) {
            this.rowIndexFlags[c] = dataInputStream.readInt();
        }
        n = dataInputStream.readInt();
        this.rowIndexShifts = (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
        for (c = '\u0000'; c < this.rowIndexShifts.length; ++c) {
            this.rowIndexShifts[c] = dataInputStream.readByte();
        }
        n = dataInputStream.readInt();
        this.table = new short[n];
        for (c = '\u0000'; c < this.table.length; ++c) {
            this.table[c] = dataInputStream.readShort();
        }
        this.reverseColumnMap = (char[])ExtendedSystem.newArray(Character.TYPE, this.numCols, this);
        for (c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            byte by = this.columnMap.elementAt(c);
            if (by == 0) continue;
            this.reverseColumnMap[by] = c;
        }
        dataInputStream.close();
    }

    public final short at(int n, char c) {
        byte by = this.columnMap.elementAt(c);
        return this.at(n, by);
    }

    public final short at(int n, int n2) {
        if (this.cellIsPopulated(n, n2)) {
            return this.internalAt(this.rowIndex[n], n2 + this.rowIndexShifts[n]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int n, int n2) {
        if (this.rowIndexFlagsIndex[n] < 0) {
            return n2 == -this.rowIndexFlagsIndex[n];
        }
        int n3 = this.rowIndexFlags[this.rowIndexFlagsIndex[n] + (n2 >> 5)];
        return (n3 & 1 << (n2 & 0x1F)) != 0;
    }

    private final short internalAt(int n, int n2) {
        return this.table[n * this.numCols + n2];
    }
}

