/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable {
    private transient Calendar cal = null;
    private transient long fastTime;
    private static Calendar staticCal = null;
    private static Calendar utcCal = null;
    private static int defaultCenturyStart = 0;
    private static final long serialVersionUID = 7523967970034938905L;
    private static SoftReference simpleFormatter = null;
    private static SoftReference gmtFormatter = null;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this.fastTime = l;
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        if (staticCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTimeZone(TimeZone.getDefault());
            staticCal.clear();
            staticCal.set(n + 1900, n2, n3, n4, n5, n6);
            this.fastTime = staticCal.getTimeInMillis();
        }
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (date.cal != null) {
                date.cal = (Calendar)date.cal.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        if (utcCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = utcCal;
        synchronized (calendar) {
            utcCal.clear();
            utcCal.set(n + 1900, n2, n3, n4, n5, n6);
            return utcCal.getTimeInMillis();
        }
    }

    public static long parse(String string) {
        block45: {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            int n = Integer.MIN_VALUE;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int n10 = -1;
            int n11 = -1;
            int n12 = -1;
            int n13 = 0;
            if (string != null) {
                int n14 = string.length();
                block0: while (n9 < n14) {
                    int n15;
                    n8 = string.charAt(n9);
                    ++n9;
                    if (n8 <= 32 || n8 == 44) continue;
                    if (n8 == 40) {
                        n15 = 1;
                        while (n9 < n14) {
                            n8 = string.charAt(n9);
                            ++n9;
                            if (n8 == 40) {
                                ++n15;
                                continue;
                            }
                            if (n8 != 41 || --n15 > 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (48 <= n8 && n8 <= 57) {
                        n10 = n8 - 48;
                        while (n9 < n14) {
                            char c = string.charAt(n9);
                            n8 = c;
                            if ('0' > c || n8 > 57) break;
                            n10 = n10 * 10 + n8 - 48;
                            ++n9;
                        }
                        if (n13 == 43 || n13 == 45 && n != Integer.MIN_VALUE) {
                            n10 = n10 < 24 ? (n10 *= 60) : n10 % 100 + n10 / 100 * 60;
                            if (n13 == 43) {
                                n10 = -n10;
                            }
                            if (n12 != 0 && n12 != -1) break block45;
                            n12 = n10;
                        } else if (n10 >= 70) {
                            if (n != Integer.MIN_VALUE || n8 > 32 && n8 != 44 && n8 != 47 && n9 < n14) break block45;
                            n = n10;
                        } else if (n8 == 58) {
                            if (n4 < 0) {
                                n4 = (byte)n10;
                            } else {
                                if (n5 >= 0) break block45;
                                n5 = (byte)n10;
                            }
                        } else if (n8 == 47) {
                            if (n2 < 0) {
                                n2 = (byte)(n10 - 1);
                            } else {
                                if (n3 >= 0) break block45;
                                n3 = (byte)n10;
                            }
                        } else {
                            if (n9 < n14 && n8 != 44 && n8 > 32 && n8 != 45) break block45;
                            if (n4 >= 0 && n5 < 0) {
                                n5 = (byte)n10;
                            } else if (n5 >= 0 && n6 < 0) {
                                n6 = (byte)n10;
                            } else if (n3 < 0) {
                                n3 = (byte)n10;
                            } else {
                                if (n != Integer.MIN_VALUE || n2 < 0 || n3 < 0) break block45;
                                n = n10;
                            }
                        }
                        n13 = 0;
                        continue;
                    }
                    if (n8 == 47 || n8 == 58 || n8 == 43 || n8 == 45) {
                        n13 = n8;
                        continue;
                    }
                    n15 = n9 - 1;
                    while (n9 < n14 && (65 <= (n8 = (int)string.charAt(n9)) && n8 <= 90 || 97 <= n8 && n8 <= 122)) {
                        ++n9;
                    }
                    if (n9 <= n15 + 1) break block45;
                    int n16 = wtb.length;
                    while (--n16 >= 0) {
                        if (!wtb[n16].regionMatches(true, 0, string, n15, n9 - n15)) continue;
                        int n17 = ttb[n16];
                        if (n17 == 0) break;
                        if (n17 == 1) {
                            if (n4 <= 12 && n4 >= 1) {
                                if (n4 >= 12) break;
                                n4 += 12;
                                break;
                            }
                            break block45;
                        }
                        if (n17 == 14) {
                            if (n4 <= 12 && n4 >= 1) {
                                if (n4 != 12) break;
                                n4 = 0;
                                break;
                            }
                            break block45;
                        }
                        if (n17 <= 13) {
                            if (n2 < 0) {
                                n2 = (byte)(n17 - 2);
                                break;
                            }
                            break block45;
                        }
                        n12 = n17 - 10000;
                        break;
                    }
                    if (n16 >= 0) {
                        n13 = 0;
                        continue;
                    }
                    break block45;
                }
                if (n != Integer.MIN_VALUE && n2 >= 0 && n3 >= 0) {
                    if (n < 100 && (n += defaultCenturyStart / 100 * 100) < defaultCenturyStart) {
                        n += 100;
                    }
                    n -= 1900;
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n12 == -1) {
                        return new Date(n, n2, n3, n4, n5, n6).getTime();
                    }
                    return Date.UTC(n, n2, n3, n4, n5, n6) + (long)(n12 * 60000);
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public int getYear() {
        return this.getField(1) - 1900;
    }

    public void setYear(int n) {
        this.setField(1, n + 1900);
    }

    public int getMonth() {
        return this.getField(2);
    }

    public void setMonth(int n) {
        this.setField(2, n);
    }

    public int getDate() {
        return this.getField(5);
    }

    public void setDate(int n) {
        this.setField(5, n);
    }

    public int getDay() {
        return this.getField(7) - 1;
    }

    public int getHours() {
        return this.getField(11);
    }

    public void setHours(int n) {
        this.setField(11, n);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public void setMinutes(int n) {
        this.setField(12, n);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    public void setSeconds(int n) {
        this.setField(13, n);
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        return this.cal == null ? this.fastTime : this.cal.getTimeInMillis();
    }

    public void setTime(long l) {
        if (this.cal == null) {
            this.fastTime = l;
        } else {
            this.cal.setTimeInMillis(l);
        }
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int compareTo(Date date) {
        long l;
        long l2 = this.getTime();
        return l2 < (l = date.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DateFormat dateFormat = null;
        if (simpleFormatter != null) {
            dateFormat = (DateFormat)simpleFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            simpleFormatter = new SoftReference(dateFormat);
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setTimeZone(TimeZone.getDefault());
            return dateFormat.format(this);
        }
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(this);
    }

    public String toGMTString() {
        DateFormat dateFormat = null;
        if (gmtFormatter != null) {
            dateFormat = (DateFormat)gmtFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            gmtFormatter = new SoftReference(dateFormat);
        }
        return dateFormat.format(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimezoneOffset() {
        int n;
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.getTime());
                n = staticCal.get(15) + staticCal.get(16);
            }
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            if (!timeZone.equals(this.cal.getTimeZone())) {
                long l = this.cal.getTimeInMillis();
                this.cal.setTimeZone(TimeZone.getDefault());
                this.cal.setTimeInMillis(l);
            }
            n = this.cal.get(15) + this.cal.get(16);
        }
        return -(n / 1000 / 60);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTimeImpl());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getField(int n) {
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.fastTime);
                return staticCal.get(n);
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        if (!timeZone.equals(this.cal.getTimeZone())) {
            long l = this.cal.getTimeInMillis();
            this.cal.setTimeZone(TimeZone.getDefault());
            this.cal.setTimeInMillis(l);
        }
        return this.cal.get(n);
    }

    private final void setField(int n, int n2) {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
            this.cal.setTimeInMillis(this.fastTime);
        }
        this.cal.set(n, n2);
    }

    private static synchronized void makeStaticCalendars() {
        if (staticCal == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            utcCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            defaultCenturyStart = gregorianCalendar.get(1) - 80;
            staticCal = gregorianCalendar;
        }
    }
}

