/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd = null;
    int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress = null;
    private int cachedSenderPort = 0;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static int ST_UNCONNECTED;
    private static int ST_CONNECTED;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private SocketOpts.IP options = null;
    private DatagramSocket socket = null;
    private SocketAddress sender;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ST_UNCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            SocketAddress socketAddress;
            ByteBuffer byteBuffer2;
            int n;
            block30: {
                SocketAddress socketAddress2;
                block29: {
                    SocketAddress socketAddress3;
                    block27: {
                        block28: {
                            this.ensureOpen();
                            if (!this.isBound()) {
                                return null;
                            }
                            n = 0;
                            byteBuffer2 = null;
                            try {
                                this.begin();
                                if (!this.isOpen()) {
                                    socketAddress3 = null;
                                    Object var9_7 = null;
                                    if (byteBuffer2 == null) break block27;
                                    break block28;
                                }
                                SecurityManager securityManager = System.getSecurityManager();
                                this.readerThread = NativeThread.current();
                                if (this.isConnected() || securityManager == null) {
                                    while ((n = this.receive(this.fd, byteBuffer)) == -3 && this.isOpen()) {
                                    }
                                    if (n == -2) {
                                        socketAddress2 = null;
                                        break block29;
                                    }
                                } else {
                                    byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
                                    while (true) {
                                        if ((n = this.receive(this.fd, byteBuffer2)) == -3 && this.isOpen()) {
                                            continue;
                                        }
                                        if (n == -2) {
                                            socketAddress = null;
                                            Object var9_9 = null;
                                            if (byteBuffer2 != null) {
                                                Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                            }
                                            this.readerThread = 0L;
                                            this.end(n > 0 || n == -2);
                                            if (!$assertionsDisabled && !IOStatus.check(n)) {
                                                throw new AssertionError();
                                            }
                                            return socketAddress;
                                        }
                                        socketAddress = (InetSocketAddress)this.sender;
                                        try {
                                            securityManager.checkAccept(((InetSocketAddress)socketAddress).getAddress().getHostAddress(), ((InetSocketAddress)socketAddress).getPort());
                                        }
                                        catch (SecurityException securityException) {
                                            byteBuffer2.clear();
                                            n = 0;
                                            continue;
                                        }
                                        break;
                                    }
                                    byteBuffer2.flip();
                                    byteBuffer.put(byteBuffer2);
                                }
                                socketAddress = this.sender;
                                break block30;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                if (byteBuffer2 != null) {
                                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                                }
                                this.readerThread = 0L;
                                this.end(n > 0 || n == -2);
                                if (!$assertionsDisabled && !IOStatus.check(n)) {
                                    throw new AssertionError();
                                }
                                throw throwable;
                            }
                        }
                        Util.releaseTemporaryDirectBuffer(byteBuffer2);
                    }
                    this.readerThread = 0L;
                    this.end(n > 0 || n == -2);
                    if (!$assertionsDisabled && !IOStatus.check(n)) {
                        throw new AssertionError();
                    }
                    return socketAddress3;
                }
                Object var9_8 = null;
                if (byteBuffer2 != null) {
                    Util.releaseTemporaryDirectBuffer(byteBuffer2);
                }
                this.readerThread = 0L;
                this.end(n > 0 || n == -2);
                if (!$assertionsDisabled && !IOStatus.check(n)) {
                    throw new AssertionError();
                }
                return socketAddress2;
            }
            Object var9_10 = null;
            if (byteBuffer2 != null) {
                Util.releaseTemporaryDirectBuffer(byteBuffer2);
            }
            this.readerThread = 0L;
            this.end(n > 0 || n == -2);
            if (!$assertionsDisabled && !IOStatus.check(n)) {
                throw new AssertionError();
            }
            return socketAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (byteBuffer instanceof DirectBuffer && n > 0) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer, n, n2);
        }
        int n5 = Math.max(n, 1);
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n5);
            int n6 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2, n5, 0);
            byteBuffer2.flip();
            if (n6 > 0 && n > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n7 = n6;
            return n7;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n, int n2) throws IOException {
        int n3 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, this.isConnected());
        if (n3 > 0) {
            byteBuffer.position(n2 + n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block25: {
                boolean bl;
                int n3;
                block24: {
                    this.ensureOpen();
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    if (inetAddress == null) {
                        throw new IOException("Target address not resolved");
                    }
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        if (!this.isConnected()) {
                            if (socketAddress == null) {
                                throw new NullPointerException();
                            }
                            SecurityManager securityManager = System.getSecurityManager();
                            if (securityManager != null) {
                                if (inetAddress.isMulticastAddress()) {
                                    securityManager.checkMulticast(inetSocketAddress.getAddress());
                                } else {
                                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                                }
                            }
                        } else if (socketAddress == null) {
                            socketAddress = this.remoteAddress;
                        } else if (!socketAddress.equals(this.remoteAddress)) {
                            throw new IllegalArgumentException("Connected address not equal to  target address");
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var10_11 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block24;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = this.send(this.fd, byteBuffer, socketAddress)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            Object var10_12 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n;
        }
    }

    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, socketAddress);
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n);
        int n4 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, socketAddress);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = this.send0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, socketAddress);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.readerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.readerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            Object var6_8 = null;
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            long l;
            long l2;
            block15: {
                boolean bl;
                long l3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l2 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_7 = null;
                            this.readerThread = 0L;
                            bl = l2 > 0L || l2 == -2L;
                            break block14;
                        }
                        this.readerThread = NativeThread.current();
                        while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.readerThread = 0L;
                        this.end(l2 > 0L || l2 == -2L);
                        if (!$assertionsDisabled && !IOStatus.check(l2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl);
                if (!$assertionsDisabled && !IOStatus.check(l2)) {
                    throw new AssertionError();
                }
                return l3;
            }
            Object var8_8 = null;
            this.readerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            if (!$assertionsDisabled && !IOStatus.check(l2)) {
                throw new AssertionError();
            }
            return l;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int n2;
            block15: {
                boolean bl;
                int n3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_7 = null;
                            this.writerThread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.writerThread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        if (!$assertionsDisabled && !IOStatus.check(n2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            Object var6_8 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            long l;
            long l2;
            block15: {
                boolean bl;
                long l3;
                block14: {
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.ensureOpen();
                        if (!this.isConnected()) {
                            throw new NotYetConnectedException();
                        }
                    }
                    l2 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_7 = null;
                            this.writerThread = 0L;
                            bl = l2 > 0L || l2 == -2L;
                            break block14;
                        }
                        this.writerThread = NativeThread.current();
                        while ((l2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.writerThread = 0L;
                        this.end(l2 > 0L || l2 == -2L);
                        if (!$assertionsDisabled && !IOStatus.check(l2)) {
                            throw new AssertionError();
                        }
                        throw throwable;
                    }
                }
                this.end(bl);
                if (!$assertionsDisabled && !IOStatus.check(l2)) {
                    throw new AssertionError();
                }
                return l3;
            }
            Object var8_8 = null;
            this.writerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            if (!$assertionsDisabled && !IOStatus.check(l2)) {
                throw new AssertionError();
            }
            return l;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n, n2));
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n) throws IOException {
                        return Net.getIntOption(DatagramChannelImpl.this.fd, n);
                    }

                    void setInt(int n, int n2) throws IOException {
                        Net.setIntOption(DatagramChannelImpl.this.fd, n, n2);
                    }
                };
                this.options = new SocketOptsImpl.IP(dispatcher);
            }
            return this.options;
        }
    }

    public boolean isBound() {
        return Net.localPortNumber(this.fd) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            SecurityManager securityManager;
            if (this.isConnected() && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localAddress;
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ST_CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != ST_UNCONNECTED) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        int n = 0;
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n2;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n2 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n)) <= 0) {
                        throw new Error();
                    }
                    this.state = ST_CONNECTED;
                    this.remoteAddress = socketAddress;
                    this.sender = inetSocketAddress;
                    this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                    this.cachedSenderPort = inetSocketAddress.getPort();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    DatagramChannelImpl.disconnect0(this.fd);
                    this.remoteAddress = null;
                    this.state = ST_UNCONNECTED;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l = this.readerThread;
            if (l != 0L) {
                NativeThread.signal(l);
            }
            if ((l = this.writerThread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.interestOps();
        int n4 = selectionKeyImpl.readyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.readyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0) {
            n5 |= 1;
        }
        if ((n & 4) != 0 && (n3 & 4) != 0) {
            n5 |= 4;
        }
        selectionKeyImpl.readyOps(n5);
        return (n5 & ~n4) != 0;
    }

    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.readyOps(), selectionKeyImpl);
    }

    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(FileDescriptor var1, long var2, int var4, SocketAddress var5) throws IOException;

    static {
        $assertionsDisabled = !DatagramChannelImpl.class.desiredAssertionStatus();
        nd = new DatagramDispatcher();
        ST_UNCONNECTED = 0;
        ST_CONNECTED = 1;
        Util.load();
        DatagramChannelImpl.initIDs();
    }
}

