/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.ThrowableLogEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BinaryFormattedLogEntry
extends FormattedLogEntry {
    private boolean headerEntry = false;
    private int level;
    private long timestamp;
    private String message;
    private int classType;
    private static final Vector classes = new Vector();

    BinaryFormattedLogEntry() {
    }

    BinaryFormattedLogEntry(LogEntry logEntry) {
        if (logEntry.getLevel().contains(Level.LEVEL_DUMP)) {
            this.setHeader();
        } else {
            this.level = logEntry.getLevel().intValue();
            this.timestamp = logEntry.getTimeStamp();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(logEntry.getMethodName());
            stringBuffer.append(": \"");
            stringBuffer.append(logEntry.getMessage());
            stringBuffer.append("\" ");
            Object[] objectArray = logEntry.getData();
            if (objectArray != null) {
                stringBuffer.append("\n");
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(objectArray[n]);
                    stringBuffer.append(" ");
                    ++n;
                }
            }
            this.message = stringBuffer.toString();
            try {
                Class<?> clazz = Class.forName(logEntry.getClassName());
                this.classType = clazz.hashCode();
                classes.add(clazz);
            }
            catch (Exception exception) {
                this.classType = 0;
            }
        }
    }

    BinaryFormattedLogEntry(ThrowableLogEntry throwableLogEntry) {
        this.level = throwableLogEntry.getLevel().intValue();
        this.timestamp = throwableLogEntry.getTimeStamp();
        this.classType = 0;
        this.message = this.getStackTrace(throwableLogEntry.getThrowable());
    }

    public void writeEntry(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeBoolean(this.headerEntry);
        dataOutputStream.writeInt(this.level);
        dataOutputStream.writeLong(this.timestamp);
        dataOutputStream.writeInt(this.classType);
        if (this.message != null) {
            dataOutputStream.writeInt(this.message.length());
            dataOutputStream.writeChars(this.message);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    public void readEntry(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = (DataInputStream)inputStream;
        this.headerEntry = dataInputStream.readBoolean();
        this.level = dataInputStream.readInt();
        this.timestamp = dataInputStream.readLong();
        this.classType = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        this.message = new String(cArray);
    }

    private void setHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = classes.elements();
        Class clazz = null;
        while (enumeration.hasMoreElements()) {
            clazz = (Class)enumeration.nextElement();
            stringBuffer.append(clazz.hashCode());
            stringBuffer.append(" ");
            stringBuffer.append(clazz.getName());
            stringBuffer.append(" ");
        }
        this.level = 0x1000000;
        this.headerEntry = true;
        this.classType = 0;
        this.message = stringBuffer.toString();
        this.timestamp = System.currentTimeMillis();
    }

    public static StringBuffer translate(BinaryFormattedLogEntry[] binaryFormattedLogEntryArray) {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < binaryFormattedLogEntryArray.length) {
            if (binaryFormattedLogEntryArray[n].headerEntry) {
                object = new StringTokenizer(binaryFormattedLogEntryArray[n].message);
                try {
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        hashtable.put(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        object = new StringBuffer();
        int n2 = 0;
        while (n2 < binaryFormattedLogEntryArray.length) {
            if (!binaryFormattedLogEntryArray[n2].headerEntry) {
                ((StringBuffer)object).append(new Level(binaryFormattedLogEntryArray[n2].level));
                ((StringBuffer)object).append(" ");
                ((StringBuffer)object).append(new Date(binaryFormattedLogEntryArray[n2].timestamp));
                ((StringBuffer)object).append(" ");
                ((StringBuffer)object).append(hashtable.get(Integer.toString(binaryFormattedLogEntryArray[n2].classType)));
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(binaryFormattedLogEntryArray[n2].message);
                ((StringBuffer)object).append("\n");
            }
            ++n2;
        }
        return object;
    }
}

