/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Handler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;

public class FileHandler
extends Handler
implements FilenameFilter,
Comparator {
    private static final String YEARLY = "yearly";
    private static final String MONTHLY = "monthly";
    private static final String DAILY = "daily";
    private static final String NONE = "none";
    private static final String YEARLY_FORMAT = "yyyy";
    private static final String MONTHLY_FORMAT = "yyyyMM";
    private static final String DAILY_FORMAT = "yyyyMMdd";
    private String rotate = "none";
    private int keep = Integer.MAX_VALUE;
    private OutputStream out = null;
    private boolean configured = false;
    private String fullFileName = null;
    private String fileName = null;
    protected File outputFile = null;
    private SimpleDateFormat stampFormat = null;
    private static final Calendar calendar = Calendar.getInstance(TimeZone.getDefault());

    public FileHandler() {
    }

    FileHandler(String string) {
        this.setFile(string);
    }

    public void setFile(String string) {
        this.fullFileName = string;
        this.fileName = string.substring(string.lastIndexOf("/") + 1);
        if ("".equals(this.fileName)) {
            this.fileName = new String(this.fullFileName);
        }
    }

    public void setRotate(String string) {
        if (string.equalsIgnoreCase(DAILY)) {
            this.rotate = DAILY;
            this.stampFormat = new SimpleDateFormat(DAILY_FORMAT);
        } else if (string.equalsIgnoreCase(MONTHLY)) {
            this.rotate = MONTHLY;
            this.stampFormat = new SimpleDateFormat(MONTHLY_FORMAT);
        } else if (string.equalsIgnoreCase(YEARLY)) {
            this.rotate = YEARLY;
            this.stampFormat = new SimpleDateFormat(YEARLY_FORMAT);
        } else {
            this.rotate = NONE;
            this.stampFormat = null;
        }
    }

    public void setKeep(String string) {
        try {
            this.keep = Integer.parseInt(string);
            if (this.keep < 0) {
                this.keep = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.keep = Integer.MAX_VALUE;
        }
    }

    private void configure() {
        if (this.fullFileName == null) {
            return;
        }
        try {
            if (this.stampFormat != null) {
                this.fullFileName = this.fullFileName.concat(".");
                this.fullFileName = this.fullFileName.concat(this.stampFormat.format(calendar.getTime()));
                this.fullFileName = this.fullFileName.concat(".log");
            }
            this.outputFile = new File(this.fullFileName).getAbsoluteFile();
            File file = this.outputFile.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.stampFormat != null) {
                this.cleanupOldLogs(file);
            }
            this.out = new FileOutputStream(this.fullFileName, true);
            this.configured = true;
        }
        catch (IOException iOException) {
            this.configured = false;
        }
    }

    private void cleanupOldLogs(File file) {
        File[] fileArray = file.listFiles(this);
        Arrays.sort(fileArray, this);
        int n = fileArray.length - 1;
        while (n >= this.keep) {
            fileArray[n].delete();
            --n;
        }
    }

    public boolean accept(File file, String string) {
        return string.startsWith(this.fileName + ".") && string.endsWith(".log") && !this.outputFile.getAbsolutePath().equals(file.getAbsolutePath().concat(File.separator + string));
    }

    public int compare(Object object, Object object2) {
        return (int)(((File)object2).lastModified() - ((File)object).lastModified());
    }

    protected void output(FormattedLogEntry formattedLogEntry) {
        try {
            if (this.out == null) {
                this.configure();
            }
            if (this.configured) {
                formattedLogEntry.writeEntry(this.out);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void stop() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

