/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Formatter;
import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.SimpleBinaryFormatter;
import com.ibm.storage.ess.logging.SimpleFormatter;

public abstract class Handler {
    Formatter formatter = new SimpleFormatter();
    protected Level level = Level.LEVEL_ALL;

    void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    boolean validate() {
        return this.level != null && this.formatter != null;
    }

    synchronized void handle(LogEntry logEntry) {
        if (this.level.contains(logEntry.getLevel())) {
            this.output(this.formatter.format(logEntry));
        }
    }

    void stopLogging() {
        this.stop();
    }

    protected abstract void output(FormattedLogEntry var1);

    protected void stop() {
    }

    StringBuffer decode() {
        if (this.formatter instanceof SimpleBinaryFormatter) {
            return this.decodeLog();
        }
        return null;
    }

    protected StringBuffer decodeLog() {
        return null;
    }
}

