/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

public class Level
implements Comparable {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int THROWABLE = 2;
    public static final int WARNING = 16;
    public static final int TRACE = 256;
    public static final int DEBUG_GENERAL = 4096;
    public static final int DEBUG_DETAILED = 65536;
    public static final int DUMP = 0x1000000;
    public static final int ALL = -1;
    static final Level LEVEL_NONE = new Level(0);
    static final Level LEVEL_ERROR = new Level(1);
    static final Level LEVEL_THROWABLE = new Level(2);
    static final Level LEVEL_WARNING = new Level(16);
    static final Level LEVEL_TRACE = new Level(256);
    static final Level LEVEL_DEBUG_GENERAL = new Level(4096);
    static final Level LEVEL_DEBUG_DETAILED = new Level(65536);
    static final Level LEVEL_DUMP = new Level(0x1000000);
    static final Level LEVEL_ALL = new Level(-1);
    private int level = -1;

    Level(int n) {
        this.level = n;
    }

    int intValue() {
        return this.level;
    }

    boolean containsAll(Level level) {
        return (level.level & this.level) == this.level;
    }

    boolean contains(Level level) {
        return (level.level & this.level) > 0;
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.level - ((Level)object).level;
    }

    public boolean equals(Object object) {
        if (object instanceof Level) {
            return ((Level)object).level == this.level;
        }
        return false;
    }

    public String toString() {
        if (this.level == -1) {
            return "ALL";
        }
        if (this.level == 0) {
            return "NONE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contains(LEVEL_ERROR)) {
            stringBuffer.append("ERROR ");
        }
        if (this.contains(LEVEL_WARNING)) {
            stringBuffer.append("WARNING ");
        }
        if (this.contains(LEVEL_TRACE)) {
            stringBuffer.append("TRACE ");
        }
        if (this.contains(LEVEL_DEBUG_GENERAL)) {
            stringBuffer.append("DEBUG_GENERAL ");
        }
        if (this.contains(LEVEL_DEBUG_DETAILED)) {
            stringBuffer.append("DEBUG_DETAILED ");
        }
        if (this.contains(LEVEL_THROWABLE)) {
            stringBuffer.append("THROWABLE");
        }
        if (this.contains(LEVEL_DUMP)) {
            stringBuffer.append("DUMP");
        }
        return stringBuffer.toString().trim();
    }
}

