/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.Logger;

public class LogEntry {
    private Level level;
    private Logger logger;
    private long timeStamp;
    private String className;
    private String methodName;
    private String message;
    private Object[] data;

    LogEntry(Level level, Logger logger, long l, String string, String string2, String string3, Object[] objectArray) {
        this.level = level;
        this.logger = logger;
        this.timeStamp = l;
        this.className = string;
        this.methodName = string2;
        this.message = string3;
        this.data = objectArray;
        if (this.className == null || this.methodName == null) {
            this.setClassAndMethodNames();
        }
    }

    private void setClassAndMethodNames() {
        this.className = "";
        this.methodName = "";
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            String string = "";
            int n = 0;
            while (n < stackTraceElementArray.length) {
                string = stackTraceElementArray[n].getClassName();
                if (string.indexOf("Exception") == -1 && string.indexOf("Throwable") == -1 && !string.startsWith("com.ibm.storage.ess.logging")) {
                    this.className = string;
                    this.methodName = stackTraceElementArray[n].getMethodName();
                    break;
                }
                ++n;
            }
        }
    }

    public Level getLevel() {
        return this.level;
    }

    Logger getLogger() {
        return this.logger;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        return this.message;
    }

    public Object[] getData() {
        if (this.data == null) {
            this.data = new Object[0];
        }
        return this.data;
    }
}

