/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FileHandler;
import com.ibm.storage.ess.logging.Filter;
import com.ibm.storage.ess.logging.Formatter;
import com.ibm.storage.ess.logging.Handler;
import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.LogProcessor;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.logging.SimpleFormatter;
import com.ibm.storage.ess.logging.TriggeredHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogManager {
    private static LogManager lm = null;
    private Hashtable loggers;
    private static Hashtable handlers;
    private Hashtable names;
    private LogProcessor lp;
    private Properties configRules = null;
    private boolean loggingStopped = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$storage$ess$logging$Level;

    public static LogManager getLogManager() {
        if (lm == null) {
            lm = new LogManager();
            lm.configure();
        }
        return lm;
    }

    public static LogManager getLogManager(InputStream inputStream) {
        if (lm == null) {
            lm = new LogManager();
            lm.setConfigurationStream(inputStream);
            lm.configure();
        }
        return lm;
    }

    static LogProcessor getLogProcessor() {
        return LogManager.lm.lp;
    }

    private LogManager() {
    }

    private void setConfigurationStream(InputStream inputStream) {
        this.configRules = new Properties();
        try {
            this.configRules.load(inputStream);
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void configure() {
        String string;
        this.loggers = new Hashtable();
        this.names = new Hashtable();
        handlers = new Hashtable();
        if (this.configRules == null) {
            this.loadConfiguration();
        }
        if ((string = (String)this.configRules.remove("com.ibm.storage.ess.logging.LogProcessor.on")) != null && string.equalsIgnoreCase("false")) {
            Logger.setProcessorOn(false);
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    lm.stopLogging();
                }
            });
            this.lp = new LogProcessor();
            this.lp.start();
            Logger.setProcessorOn(true);
        }
        this.configureDefaultLogger();
        this.configureLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        this.configRules = new Properties();
        FileInputStream fileInputStream = null;
        try {
            String string = System.getProperty("com.ibm.storage.ess.logging", "logger.properties");
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            fileInputStream = new FileInputStream(string);
            this.configRules.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
    }

    private void configureDefaultLogger() {
        Logger logger = Logger.newLoggerInstance(null);
        FileHandler fileHandler = new FileHandler("java.log");
        fileHandler.setLevel(Level.LEVEL_ALL);
        fileHandler.setFormatter(new SimpleFormatter());
        logger.setHandlers(new Handler[]{fileHandler});
        logger.setLevel(Level.LEVEL_ALL);
        logger.logWithParent(false);
        this.loggers.put("default", logger);
    }

    private void configureLoggers() {
        Set<Object> set = this.configRules.keySet();
        String string = null;
        Object var3_3 = null;
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            int n = string.lastIndexOf(46);
            if (n < 0) {
                this.processNewHandler(string);
                continue;
            }
            this.storeName(string, n);
        }
        this.processHandlers();
        this.processLoggers();
        this.validateLoggers();
    }

    private void processHandlers() {
        Set set = handlers.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        Handler handler = null;
        Vector vector = null;
        String string2 = null;
        String string3 = null;
        Method method = null;
        StringBuffer stringBuffer = null;
        Class<?> clazz = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            handler = (Handler)handlers.get(string);
            vector = (Vector)this.names.remove(string);
            if (handler == null || vector == null) continue;
            int n = vector.size();
            try {
                int n2 = 0;
                while (n2 < n) {
                    string3 = (String)vector.get(n2);
                    string2 = (String)this.configRules.remove(string + "." + string3);
                    if (string3.equalsIgnoreCase("level")) {
                        handler.setLevel(LogManager.buildLevelObject(string2));
                    } else if (string3.equalsIgnoreCase("formatter")) {
                        handler.setFormatter((Formatter)this.getNewInstance(string2));
                    } else if (string3.equalsIgnoreCase("Handlers")) {
                        ((TriggeredHandler)handler).setHandlers(string2);
                    } else if (string3.equalsIgnoreCase("TriggerLevel")) {
                        ((TriggeredHandler)handler).setTriggerLevel(string2);
                    } else {
                        clazz = handler.getClass();
                        stringBuffer = new StringBuffer("set");
                        stringBuffer.append(string3.substring(0, 1).toUpperCase());
                        stringBuffer.append(string3.substring(1));
                        method = clazz.getMethod(stringBuffer.toString(), class$java$lang$String == null ? LogManager.class$("java.lang.String") : class$java$lang$String);
                        method.invoke((Object)handler, string2);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                handlers.remove(string);
            }
        }
    }

    static Level buildLevelObject(String string) throws IllegalAccessException, NoSuchFieldException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            Field field = (class$com$ibm$storage$ess$logging$Level == null ? LogManager.class$("com.ibm.storage.ess.logging.Level") : class$com$ibm$storage$ess$logging$Level).getField(stringTokenizer.nextToken().toUpperCase());
            n |= field.getInt(null);
        }
        return new Level(n);
    }

    private void processLoggers() {
        String string = null;
        Vector vector = null;
        String string2 = null;
        String string3 = null;
        Logger logger = null;
        Logger logger2 = null;
        String string4 = null;
        Vector vector2 = new Vector(this.names.keySet());
        Collections.sort(vector2);
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            string = (String)vector2.get(n2);
            if (!string.equalsIgnoreCase("default")) {
                string4 = this.findParentLoggerName(string);
                logger2 = (Logger)this.loggers.get(string4);
                logger = Logger.newLoggerInstance(logger2);
                if (string4.equals("default")) {
                    logger.logWithParent(false);
                }
                this.loggers.put(string, logger);
                vector = (Vector)this.names.get(string);
                int n3 = vector.size();
                int n4 = 0;
                while (n4 < n3) {
                    string2 = (String)vector.get(n4);
                    string3 = this.configRules.getProperty(string + "." + string2);
                    if (string2.equals("level")) {
                        try {
                            logger.setLevel(LogManager.buildLevelObject(string3));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string2.equals("handlers")) {
                        this.addHandlersToLogger(logger, string3);
                    } else if (string2.equals("filter")) {
                        try {
                            logger.setFilter((Filter)this.getNewInstance(string3));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string2.equals("logWithParent")) {
                        logger.logWithParent(Boolean.valueOf(string3));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void validateLoggers() {
        Enumeration enumeration = this.loggers.keys();
        String string = null;
        Logger logger = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            logger = (Logger)this.loggers.get(string);
            if (logger.validate()) continue;
            Logger logger2 = this.getLogger(this.findParentLoggerName(string));
            logger2.error("The LogManager had an error while processing the logger " + string + " and will not use that logger.");
            this.loggers.remove(string);
        }
    }

    private String findParentLoggerName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string;
        while (n > 0) {
            if (this.loggers.containsKey(string2 = string2.substring(0, n))) {
                return string2;
            }
            n = string2.lastIndexOf(46);
        }
        return "default";
    }

    private Vector findChildLoggers(String string) {
        Iterator iterator = this.loggers.keySet().iterator();
        String string2 = null;
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            vector.add(this.loggers.get(string2));
        }
        return vector;
    }

    private void addHandlersToLogger(Logger logger, String string) {
        Handler[] handlerArray = LogManager.buildHandlerList(string);
        logger.setHandlers(handlerArray);
    }

    static Handler[] buildHandlerList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        String string2 = null;
        int n = stringTokenizer.countTokens();
        Handler handler = null;
        Handler[] handlerArray = new Handler[n];
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            handler = (Handler)handlers.get(string2);
            if (handler != null) {
                handlerArray[n2] = handler;
            }
            ++n2;
        }
        return handlerArray;
    }

    private void processNewHandler(String string) {
        try {
            String string2 = this.configRules.getProperty(string);
            Handler handler = (Handler)this.getNewInstance(string2);
            handlers.put(string, handler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void storeName(String string, int n) {
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (!this.names.containsKey(string2)) {
            this.names.put(string2, new Vector());
        }
        ((Vector)this.names.get(string2)).add(string3);
    }

    private Object getNewInstance(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Class.forName(string).newInstance();
    }

    public Logger getLogger(String string) {
        Logger logger = (Logger)this.loggers.get(string);
        if (logger == null) {
            String string2 = this.findParentLoggerName(string);
            logger = (Logger)this.loggers.get(string2);
        }
        return logger;
    }

    public Logger[] getAllLoggers() {
        Collection collection = this.loggers.values();
        return collection.toArray(new Logger[0]);
    }

    synchronized void stopLogging() {
        if (!this.loggingStopped) {
            this.loggingStopped = true;
            if (this.lp != null) {
                this.lp.stopProcessing();
            }
            Iterator iterator = handlers.keySet().iterator();
            while (iterator.hasNext()) {
                ((Handler)handlers.get(iterator.next())).stopLogging();
            }
            iterator = this.loggers.keySet().iterator();
            while (iterator.hasNext()) {
                ((Logger)this.loggers.get(iterator.next())).stopLogging();
            }
        }
    }

    public static void main(String[] stringArray) {
        LogManager logManager = LogManager.getLogManager();
        Iterator iterator = logManager.loggers.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
        }
        Logger logger = logManager.getLogger("default");
        Logger logger2 = logManager.getLogger("logger1");
        Logger logger3 = logManager.getLogger("logger2");
        Logger logger4 = logManager.getLogger("logger2.l2");
        logger4.error("This is a warning");
        logManager.stopLogging();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

