/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.LogEntry;
import java.util.LinkedList;

public class LogProcessor
extends Thread {
    private LinkedList queue = new LinkedList();
    private boolean running;

    LogProcessor() {
        super("LogProcessor");
        this.setPriority(1);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        LogEntry logEntry = null;
        while (this.running) {
            LogProcessor logProcessor = this;
            synchronized (logProcessor) {
                if (this.queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (!this.queue.isEmpty()) {
                    logEntry = (LogEntry)this.queue.removeFirst();
                    logEntry.getLogger().log(logEntry);
                }
            }
        }
    }

    synchronized void enqueueMessage(LogEntry logEntry) {
        this.queue.addLast(logEntry);
        this.notify();
    }

    synchronized void stopProcessing() {
        this.running = false;
        this.notify();
        LogEntry logEntry = null;
        while (!this.queue.isEmpty()) {
            logEntry = (LogEntry)this.queue.removeFirst();
            logEntry.getLogger().log(logEntry);
        }
    }
}

