/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.Filter;
import com.ibm.storage.ess.logging.Handler;
import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.LogManager;
import com.ibm.storage.ess.logging.LogProcessor;
import com.ibm.storage.ess.logging.LoggerInterface;
import com.ibm.storage.ess.logging.ThrowableLogEntry;

public abstract class Logger
extends LoggerInterface {
    private static LogProcessor processor = null;
    private Level level = null;
    private Filter filter = null;
    private Handler[] handlers = null;
    private Logger parent = null;
    private boolean logWithParent = true;
    private static Class loggerClassType = class$com$ibm$storage$ess$logging$Logger$ProcessLogger == null ? (class$com$ibm$storage$ess$logging$Logger$ProcessLogger = Logger.class$("com.ibm.storage.ess.logging.Logger$ProcessLogger")) : class$com$ibm$storage$ess$logging$Logger$ProcessLogger;
    static /* synthetic */ Class class$com$ibm$storage$ess$logging$Logger$ProcessLogger;
    static /* synthetic */ Class class$com$ibm$storage$ess$logging$Logger$DirectLogger;
    static /* synthetic */ Class class$com$ibm$storage$ess$logging$Logger;

    static void setProcessorOn(boolean bl) {
        if (bl) {
            loggerClassType = class$com$ibm$storage$ess$logging$Logger$ProcessLogger == null ? (class$com$ibm$storage$ess$logging$Logger$ProcessLogger = Logger.class$("com.ibm.storage.ess.logging.Logger$ProcessLogger")) : class$com$ibm$storage$ess$logging$Logger$ProcessLogger;
            processor = LogManager.getLogProcessor();
        } else {
            loggerClassType = class$com$ibm$storage$ess$logging$Logger$DirectLogger == null ? (class$com$ibm$storage$ess$logging$Logger$DirectLogger = Logger.class$("com.ibm.storage.ess.logging.Logger$DirectLogger")) : class$com$ibm$storage$ess$logging$Logger$DirectLogger;
        }
    }

    static Logger newLoggerInstance(Logger logger) {
        Logger logger2 = null;
        try {
            logger2 = (Logger)loggerClassType.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        logger2.setParent(logger);
        if (logger != null) {
            logger2.setLevel(logger.level);
            logger2.setHandlers(logger.handlers);
            logger2.setFilter(logger.filter);
        }
        return logger2;
    }

    protected Logger() {
    }

    void setHandlers(Handler[] handlerArray) {
        this.handlers = handlerArray;
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    void setParent(Logger logger) {
        this.parent = logger;
    }

    void logWithParent(boolean bl) {
        this.logWithParent = bl;
    }

    void stopLogging() {
        this.level = Level.LEVEL_NONE;
        this.handlers = new Handler[0];
        this.filter = null;
    }

    private void log(Level level, long l, String string, String string2, String string3, Object[] objectArray) {
        LogEntry logEntry = new LogEntry(level, this, l, string, string2, string3, objectArray);
        if (this.filter == null || this.filter.isLoggable(logEntry)) {
            this.handleLogEntry(logEntry);
        }
    }

    private void log(Throwable throwable, long l) {
        ThrowableLogEntry throwableLogEntry = new ThrowableLogEntry(Level.LEVEL_THROWABLE, this, l, throwable);
        if (this.filter == null || this.filter.isLoggable(throwableLogEntry)) {
            this.handleLogEntry(throwableLogEntry);
        }
    }

    void log(LogEntry logEntry) {
        int n = 0;
        while (n < this.handlers.length) {
            this.handlers[n].handle(logEntry);
            ++n;
        }
        if (this.logWithParent) {
            this.parent.logFromChild(logEntry);
        }
    }

    private void logFromChild(LogEntry logEntry) {
        if (this.level.contains(logEntry.getLevel()) && (this.filter == null || this.filter.isLoggable(logEntry))) {
            this.log(logEntry);
        }
    }

    boolean validate() {
        boolean bl = this.handlers != null && this.level != null;
        int n = 0;
        while (bl && n < this.handlers.length) {
            bl = this.handlers[n].validate();
            ++n;
        }
        return bl;
    }

    protected abstract void handleLogEntry(LogEntry var1);

    public void error(String string, String string2, String string3, Object[] objectArray) {
        if (this.errorLoggingEnabled()) {
            this.log(Level.LEVEL_ERROR, System.currentTimeMillis(), string2, string3, string, objectArray);
        }
    }

    public void warning(String string, String string2, String string3, Object[] objectArray) {
        if (this.warningLoggingEnabled()) {
            this.log(Level.LEVEL_WARNING, System.currentTimeMillis(), string2, string3, string, objectArray);
        }
    }

    public void trace(String string, String string2, String string3, Object[] objectArray) {
        if (this.traceLoggingEnabled()) {
            this.log(Level.LEVEL_TRACE, System.currentTimeMillis(), string2, string3, string, objectArray);
        }
    }

    public void debug_general(String string, String string2, String string3, Object[] objectArray) {
        if (this.debug_generalLoggingEnabled()) {
            this.log(Level.LEVEL_DEBUG_GENERAL, System.currentTimeMillis(), string2, string3, string, objectArray);
        }
    }

    public void debug_detailed(String string, String string2, String string3, Object[] objectArray) {
        if (this.debug_detailedLoggingEnabled()) {
            this.log(Level.LEVEL_DEBUG_DETAILED, System.currentTimeMillis(), string2, string3, string, objectArray);
        }
    }

    public void throwable(Throwable throwable) {
        if (this.throwableLoggingEnabled()) {
            this.log(throwable, System.currentTimeMillis());
        }
    }

    public boolean errorLoggingEnabled() {
        return this.level.contains(Level.LEVEL_ERROR);
    }

    public boolean warningLoggingEnabled() {
        return this.level.contains(Level.LEVEL_WARNING);
    }

    public boolean traceLoggingEnabled() {
        return this.level.contains(Level.LEVEL_TRACE);
    }

    public boolean debug_generalLoggingEnabled() {
        return this.level.contains(Level.LEVEL_DEBUG_GENERAL);
    }

    public boolean debug_detailedLoggingEnabled() {
        return this.level.contains(Level.LEVEL_DEBUG_DETAILED);
    }

    public void dump() {
        this.log(Level.LEVEL_DUMP, System.currentTimeMillis(), (class$com$ibm$storage$ess$logging$Logger == null ? (class$com$ibm$storage$ess$logging$Logger = Logger.class$("com.ibm.storage.ess.logging.Logger")) : class$com$ibm$storage$ess$logging$Logger).getName(), "dump", null, null);
    }

    public boolean throwableLoggingEnabled() {
        return this.level.contains(Level.LEVEL_THROWABLE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class DirectLogger
    extends Logger {
        DirectLogger() {
        }

        protected void handleLogEntry(LogEntry logEntry) {
            this.log(logEntry);
        }
    }

    static final class ProcessLogger
    extends Logger {
        ProcessLogger() {
        }

        protected void handleLogEntry(LogEntry logEntry) {
            processor.enqueueMessage(logEntry);
        }
    }
}

