/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Formatter;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.StringFormattedLogEntry;
import com.ibm.storage.ess.logging.ThrowableLogEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleFormatter
implements Formatter {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:S");

    public FormattedLogEntry format(LogEntry logEntry) {
        if (logEntry instanceof ThrowableLogEntry) {
            return new StringFormattedLogEntry(this.format((ThrowableLogEntry)logEntry));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(logEntry.getLevel()).append("]");
        stringBuffer.append(" [").append(sdf.format(new Date(logEntry.getTimeStamp())));
        stringBuffer.append("] ");
        stringBuffer.append(" ").append(logEntry.getClassName()).append(".");
        stringBuffer.append(logEntry.getMethodName()).append("()");
        stringBuffer.append("\t").append("\"").append(logEntry.getMessage()).append("\"");
        Object[] objectArray = logEntry.getData();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                stringBuffer.append(" ").append(objectArray[n].getClass().getName()).append(": ");
                stringBuffer.append(objectArray[n]);
            }
            ++n;
        }
        return new StringFormattedLogEntry(stringBuffer.toString());
    }

    private String format(ThrowableLogEntry throwableLogEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(throwableLogEntry.getLevel()).append("]");
        stringBuffer.append(" [").append(sdf.format(new Date(throwableLogEntry.getTimeStamp())));
        stringBuffer.append("] ");
        stringBuffer.append("UNCAUGHT THROWABLE\n");
        stringBuffer.append(this.getStackTrace(throwableLogEntry.getThrowable()));
        return stringBuffer.toString();
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

