/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Handler;
import com.ibm.storage.ess.logging.Level;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.LogManager;
import com.ibm.storage.ess.logging.Logger;
import java.nio.CharBuffer;
import java.util.Vector;

public class TriggeredHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1024;
    private static final int DEFAULT_MESSAGE_LENGTH = 256;
    private LogEntry[] buffer = null;
    private int head = 0;
    private int tail = 0;
    private Handler[] handlers = new Handler[0];
    private Level triggerLevel = Level.LEVEL_DUMP;
    private int maxMessageLength = 256;

    TriggeredHandler() {
        this.buffer = new LogEntry[1024];
    }

    void setBufferSize(String string) {
        try {
            int n = Integer.parseInt(string);
            this.buffer = new LogEntry[n];
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected void output(FormattedLogEntry formattedLogEntry) {
    }

    void setTriggerLevel(String string) {
        Level level = null;
        try {
            level = LogManager.buildLevelObject(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (level != null) {
            this.triggerLevel = level;
        }
    }

    void setHandlers(String string) {
        this.handlers = LogManager.buildHandlerList(string);
    }

    public void setMaxMessageLength(String string) {
        try {
            this.maxMessageLength = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.maxMessageLength = 256;
        }
    }

    protected synchronized void handle(LogEntry logEntry) {
        Level level = logEntry.getLevel();
        if (this.level.contains(level)) {
            LogEntry[] logEntryArray = this.breakupLogEntries(logEntry);
            int n = 0;
            while (n < logEntryArray.length) {
                if (logEntryArray[n] != null) {
                    this.buffer[this.head] = logEntryArray[n];
                    this.incrementPointers();
                }
                ++n;
            }
        }
        if (this.triggerLevel.contains(level)) {
            this.dumpLogs();
        }
    }

    private LogEntry[] breakupLogEntries(LogEntry logEntry) {
        String string = logEntry.getMessage();
        LogEntry[] logEntryArray = null;
        int n = string.length() / this.maxMessageLength;
        if (string.length() % this.maxMessageLength != 0) {
            ++n;
        }
        if (n > 1) {
            Vector<LogEntry> vector = new Vector<LogEntry>();
            String string2 = logEntry.getClassName();
            String string3 = logEntry.getMethodName();
            Object[] objectArray = logEntry.getData();
            long l = logEntry.getTimeStamp();
            Logger logger = logEntry.getLogger();
            Level level = logEntry.getLevel();
            CharBuffer charBuffer = CharBuffer.wrap(string);
            char[] cArray = new char[this.maxMessageLength];
            int n2 = 0;
            while (n2 < n) {
                if (cArray.length > charBuffer.remaining()) {
                    cArray = new char[charBuffer.remaining()];
                }
                charBuffer.get(cArray);
                String string4 = new String(cArray);
                vector.add(new LogEntry(level, logger, l, string2, string3, string4, null));
                ++n2;
            }
            if (objectArray != null && objectArray.length > 0) {
                vector.add(new LogEntry(level, logger, l, string2, string3, "data", objectArray));
            }
            logEntryArray = vector.toArray(new LogEntry[0]);
        } else {
            logEntryArray = new LogEntry[]{logEntry};
        }
        return logEntryArray;
    }

    private void dumpLogs() {
        int n = this.tail > this.head ? this.head + this.buffer.length : this.head;
        int n2 = this.tail;
        while (n2 < n) {
            int n3 = n2 % this.buffer.length;
            if (this.buffer[n3] != null) {
                int n4 = 0;
                while (n4 < this.handlers.length) {
                    this.handlers[n4].handle(this.buffer[n3]);
                    ++n4;
                }
            }
            this.buffer[n3] = null;
            ++n2;
        }
        this.tail = n % this.buffer.length;
    }

    private void incrementPointers() {
        ++this.head;
        this.head %= this.buffer.length;
        if (this.head == this.tail) {
            ++this.tail;
            this.tail %= this.buffer.length;
        }
    }
}

