/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPBody;
import com.ibm.trl.soap.SOAPBodyEntry;
import com.ibm.trl.soap.SOAPFault;
import com.ibm.trl.soapimpl.SOAPBodyEntryImpl;
import com.ibm.trl.soapimpl.SOAPElementImpl;
import com.ibm.trl.soapimpl.SOAPFaultImpl;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.trl.util.xml.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    private static final QName QNAME_SOAP_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");

    SOAPBodyImpl(Element element) {
        super(element);
    }

    public SOAPBodyImpl(Document document) {
        super(document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body"));
    }

    public void setFault(SOAPFault sOAPFault) {
        Element element = this.getDOMEntity();
        this.removeFault();
        sOAPFault.ownedBy(element);
        element.appendChild(sOAPFault.getDOMEntity());
    }

    public SOAPFault getFault() {
        NodeList nodeList = this.getElementsNamed("Fault");
        if (nodeList.getLength() == 0) {
            return null;
        }
        return new SOAPFaultImpl((Element)nodeList.item(0));
    }

    public void removeFault() {
        Element element = this.getDOMEntity();
        NodeList nodeList = this.getElementsNamed("Fault");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            element.removeChild(nodeList.item(i));
        }
    }

    public boolean containsFault() {
        return this.getElementsNamed("Fault").getLength() != 0;
    }

    public int getBodyEntryCount() {
        return this.getEntryCount();
    }

    public SOAPBodyEntry getBodyEntry(int n) {
        return this.createBodyEntry(this.getEntries()[n]);
    }

    public SOAPBodyEntry[] getBodyEntries() {
        Element[] elementArray = this.getEntries();
        SOAPBodyEntry[] sOAPBodyEntryArray = new SOAPBodyEntry[elementArray.length];
        for (int i = 0; i < sOAPBodyEntryArray.length; ++i) {
            sOAPBodyEntryArray[i] = this.createBodyEntry(elementArray[i]);
        }
        return sOAPBodyEntryArray;
    }

    public void addBodyEntry(SOAPBodyEntry sOAPBodyEntry) {
        Element element = this.getDOMEntity();
        sOAPBodyEntry.ownedBy(element);
        element.appendChild(sOAPBodyEntry.getDOMEntity());
    }

    public void removeBodyEntry(SOAPBodyEntry sOAPBodyEntry) {
        this.getDOMEntity().removeChild(sOAPBodyEntry.getDOMEntity());
    }

    private SOAPBodyEntry createBodyEntry(Element element) {
        if (DOMHandler.isNodeNamedNS(element, QNAME_SOAP_FAULT)) {
            return new SOAPFaultImpl(element);
        }
        return new SOAPBodyEntryImpl(element);
    }
}

