/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util.xml;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.ErrorHandlerImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMConverter {
    static Document parse(String string) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandlerImpl());
            Logger.normal("Parsing the URL '" + string + "'...", 0);
            documentBuilder.parse(string);
            Logger.normal("Done.", 0);
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    static Document parse(Reader reader) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandlerImpl());
            Logger.normal("Parsing an XML stream...", 0);
            documentBuilder.parse(new InputSource(reader));
            Logger.normal("Done.", 0);
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    private DOMConverter() {
    }

    public static Document toDOM(String string) throws SAXException {
        try {
            StringReader stringReader = new StringReader(string);
            StringWriter stringWriter = new StringWriter();
            Document document = DOMConverter.parse(stringReader);
            stringReader.close();
            stringWriter.close();
            return document;
        }
        catch (IOException iOException) {
            throw new UnknownError(iOException.getMessage());
        }
    }

    public static Document toDOM(String string, boolean bl) throws SAXException, IOException {
        return bl ? DOMConverter.parse(string) : DOMConverter.toDOM(string);
    }

    public static Document toDOM(Reader reader) throws IOException, SAXException {
        return DOMConverter.parse(reader);
    }

    public static String toString(Node node) {
        return DOMConverter.toString(node, null);
    }

    public static String toString(Node node, String string) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (string != null) {
                transformer.setOutputProperty("encoding", string);
            }
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(node);
            switch (node.getNodeType()) {
                case 9: {
                    transformer.transform(dOMSource, streamResult);
                    break;
                }
                case 1: {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(dOMSource, streamResult);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported node type: " + node.getNodeType());
                }
            }
            stringWriter.flush();
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new UnknownError(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new UnknownError(transformerException.getMessage());
        }
    }
}

