/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util.xml;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMHandler {
    private static final String XMLNS_ = "xmlns:";

    private DOMHandler() {
    }

    public static Document createDocument() {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            document = null;
            StringWriter stringWriter = new StringWriter();
            parserConfigurationException.printStackTrace(new PrintWriter(stringWriter));
            Logger.fatal(stringWriter.toString());
        }
        return document;
    }

    public static String getNodeValue(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            stringBuffer.append(nodeList.item(i).getNodeValue());
        }
        return stringBuffer.toString();
    }

    public static String getPrefixForNamespaceURI(Node node, String string) {
        Object object;
        if (node.getNodeType() == 1) {
            object = ((Element)node).getAttributes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)object.item(i);
                String string2 = attr.getName();
                if (!string2.startsWith(XMLNS_) || !attr.getValue().equals(string)) continue;
                if (string2.length() <= XMLNS_.length()) {
                    throw new DOMException(4, "xmlns: attribute does not have prefix part");
                }
                return attr.getName().substring(XMLNS_.length());
            }
        }
        if ((object = node.getParentNode()) != null) {
            return DOMHandler.getPrefixForNamespaceURI((Node)object, string);
        }
        throw new DOMException(14, "There is no namespace prefix for the namespace URI: " + string);
    }

    public static boolean isNodeNamedNS(Node node, QName qName) {
        if (node == null || qName == null) {
            return false;
        }
        return qName.getNamespaceURI().equals(node.getNamespaceURI()) && qName.getLocalName().equals(node.getLocalName());
    }
}

