/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import com.ibm.xml.dsig.IDResolver;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPIDResolver
implements IDResolver {
    private final Hashtable idTypeAttrTable = new Hashtable();

    public SOAPIDResolver() {
        this(null);
    }

    public SOAPIDResolver(QName[] qNameArray) {
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.addIDTypeAttr(qNameArray[i]);
            }
        }
    }

    public void addIDTypeAttr(QName qName) {
        this.idTypeAttrTable.put(qName, qName);
    }

    public void removeIDTypeAttr(QName qName) {
        this.idTypeAttrTable.remove(qName);
    }

    public Element resolveID(Document document, String string) {
        Logger.normal("Resolving ID: " + string + ", id type attributes: " + this.idTypeAttrTable, 0);
        if (document == null) {
            return null;
        }
        Element element = this.resolveID(document.getDocumentElement(), string);
        return element;
    }

    private Element resolveID(Element element, String string) {
        if (this.hasID(element, string)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element2 = this.resolveID((Element)node, string)) == null) continue;
            return element2;
        }
        return null;
    }

    private boolean hasID(Element element, String string) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getNamespaceURI();
            string2 = string2 == null ? "" : string2;
            String string3 = attr.getLocalName();
            String string4 = string3 = string3 == null ? attr.getName() : string3;
            if (this.idTypeAttrTable.get(new QName(string2, string3)) == null || !string.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }
}

