/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.trl.util.xml.QName;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import com.ibm.xml.soap.security.util.SwingPasswordHandler;
import com.ibm.xml.soap.security.util.UnknownAliasException;
import java.io.Reader;
import java.io.Writer;
import java.rmi.server.UID;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class SOAPSigner
extends SOAPSignatureHandler {
    private static final String ELEM_VALUEOFTS = "ValueOfTimestamp";
    private static final String ELEM_VALUEOFNONCE = "ValueOfNonce";
    private static final String ELEM_TS = "timestamp";
    private static final String ELEM_NONCE = "nonce";
    private static final String XPATH_CONFIG = "/" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPSignerConfig");
    private static final String XPATH_ACTOR = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPActor");
    private static final String XPATH_KEYSTORE = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_POLICY = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Policy");
    private static final String XPATH_PRIVATEKEY = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PrivateKey");
    private static final String XPATH_PUBLICKEY = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PublicKey");
    private static final String XPATH_INCLUDEKEYNAME = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeKeyName");
    private static final String XPATH_INCLUDEKEYVALUE = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeKeyValue");
    private static final String XPATH_INCLUDEX509DATA = XPATH_PUBLICKEY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "IncludeX509Data");
    private static final String XPATH_TEMPLATE = XPATH_POLICY + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Template");
    private static final String XPATH_TEMPLATE1 = XPATH_TEMPLATE + "/*[position()=1]";
    private static final String XPATH_SIGNATURE = XPATH_TEMPLATE + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Signature");
    private static final String XPATH_KEYINFO = XPATH_SIGNATURE + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final QName QNAME_VALUEOFTS = new QName("http://www.ibm.com/xml/soap/#SOAPSignature", "ValueOfTimestamp");
    private static final QName QNAME_VALUEOFNONCE = new QName("http://www.ibm.com/xml/soap/#SOAPSignature", "ValueOfNonce");
    private SwingPasswordHandler passwordHandler = new SwingPasswordHandler();
    private Key privateKey;
    private KeyInfo keyInfo;
    private Element template;
    private String verifierActorURI;

    public void initialize(InputSource inputSource) throws SOAPException {
        Document document = this.loadDocument(inputSource, false);
        this.verifierActorURI = this.getActorURI(document);
        Logger.normal("Verifier actor URI: " + this.verifierActorURI, 3);
        KeyStore keyStore = this.getKeyStore((Element)SOAPSigner.processXPath(document, XPATH_KEYSTORE).item(0));
        this.privateKey = this.getPrivateKey(document, keyStore);
        this.keyInfo = this.getKeyInfo(document, keyStore);
        this.template = this.getTemplate(document);
    }

    private String getActorURI(Document document) throws SOAPException {
        NodeList nodeList = SOAPSigner.processXPath(document, XPATH_ACTOR);
        if (nodeList == null || nodeList.getLength() < 1) {
            return "";
        }
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return "";
        }
        return element.getAttribute("URI");
    }

    private Key getPrivateKey(Document document, KeyStore keyStore) throws SOAPException {
        Element element = (Element)SOAPSigner.processXPath(document, XPATH_PRIVATEKEY).item(0);
        String string = element.getAttribute("alias");
        char[] cArray = element.getAttribute("keypass").toCharArray();
        if (cArray.length == 0) {
            try {
                cArray = this.passwordHandler.query(string);
            }
            catch (UnknownAliasException unknownAliasException) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key from the key store: alias='" + string + "': Please check the key password", unknownAliasException);
            }
        }
        Logger.normal("Key alias: " + string, 3);
        Logger.normal("Key password: " + new String(cArray), 3);
        try {
            return keyStore.getKey(string, cArray);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key from the key store: alias='" + string + "': Please check the key password", unrecoverableKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Encountered unknown algorithm while loading a key", noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a key(alias='" + string + "') from the key store due to a key store exception", keyStoreException);
        }
    }

    private KeyInfo getKeyInfo(Document document, KeyStore keyStore) throws SOAPException {
        if (SOAPSigner.processXPath(document, XPATH_KEYINFO).item(0) != null) {
            return null;
        }
        Element element = null;
        element = (Element)SOAPSigner.processXPath(document, XPATH_PRIVATEKEY).item(0);
        String string = element.getAttribute("alias");
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Couldn't get a certificate(alias='" + string + "') from the key store due to a key store exception", keyStoreException);
        }
        if (certificate == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "No such key alias: " + string);
        }
        KeyInfo keyInfo = null;
        if (SOAPSigner.evalFlag(document, XPATH_INCLUDEKEYNAME)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include KeyName", 3);
            keyInfo.setKeyNames(new String[]{string});
        }
        if (SOAPSigner.evalFlag(document, XPATH_INCLUDEKEYVALUE)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include KeyValue", 3);
            keyInfo.setKeyValue(certificate.getPublicKey());
        }
        if (SOAPSigner.evalFlag(document, XPATH_INCLUDEX509DATA)) {
            if (keyInfo == null) {
                keyInfo = new KeyInfo();
            }
            Logger.normal("Include X509Data", 3);
            KeyInfo.X509Data x509Data = new KeyInfo.X509Data();
            x509Data.setCertificate((X509Certificate)certificate);
            keyInfo.setX509Data(new KeyInfo.X509Data[]{x509Data});
        }
        return keyInfo;
    }

    private Element getTemplate(Document document) throws SOAPException {
        Element element = (Element)SOAPSigner.processXPath(document, XPATH_TEMPLATE1).item(0);
        Logger.normal("Raw Template:\n" + new String(XPathCanonicalizer.serializeSubset(element, true)), 3);
        return element;
    }

    public void edit(Reader reader, Writer writer) throws SOAPException {
        try {
            SOAPDocumentImpl sOAPDocumentImpl = new SOAPDocumentImpl(this.loadDocument(new InputSource(reader), false));
            Element element = (Element)sOAPDocumentImpl.getDocument().importNode(this.template, true);
            this.processTimestamp(element);
            this.soapSignature.sign(sOAPDocumentImpl, element, this.privateKey, this.keyInfo, this.verifierActorURI);
            XPathCanonicalizer.serializeAll(sOAPDocumentImpl.getDocument(), true, writer);
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "An exception occured while processing the signature", exception);
        }
    }

    private void processTimestamp(Element element) {
        Element element2;
        while ((element2 = this.findElement(element, QNAME_VALUEOFTS)) != null) {
            this.replacedBy(element2, this.createTimestamp(element2.getOwnerDocument()));
        }
    }

    private void processNonce(Element element) {
        Element element2;
        while ((element2 = this.findElement(element, QNAME_VALUEOFNONCE)) != null) {
            this.replacedBy(element2, this.createNonce(element2.getOwnerDocument()));
        }
    }

    private Element createTimestamp(Document document) {
        Element element = document.createElementNS("http://www.ibm.com/xml/soap/#SOAPSignature", ELEM_TS);
        String string = new Date().toString();
        Logger.normal("Timestamp: " + string, 3);
        element.appendChild(document.createTextNode(string));
        return element;
    }

    private Element createNonce(Document document) {
        Element element = document.createElementNS("http://www.ibm.com/xml/soap/#SOAPSignature", ELEM_NONCE);
        element.appendChild(document.createTextNode(new UID().toString()));
        return element;
    }

    private Element findElement(Node node, QName qName) {
        if (DOMHandler.isNodeNamedNS(node, qName)) {
            return (Element)node;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = this.findElement(nodeList.item(i), qName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private void replacedBy(Element element, Element element2) {
        element.getParentNode().replaceChild(element2, element);
    }
}

