/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.util;

import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.XSignatureException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class CertificateUtil {
    public static X509DataUtil[] getX509Data(Element element) throws XSignatureException {
        try {
            KeyInfo keyInfo = CertificateUtil.getKeyInfo(element);
            KeyInfo.X509Data[] x509DataArray = keyInfo.getX509Data();
            if (x509DataArray == null || x509DataArray.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key key = keyInfo.getKeyValue();
            X509DataUtil[] x509DataUtilArray = new X509DataUtil[x509DataArray.length];
            for (int i = 0; i < x509DataArray.length; ++i) {
                x509DataUtilArray[i] = new X509DataUtil(x509DataArray[i], key);
            }
            return x509DataUtilArray;
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new XSignatureException(signatureStructureException);
        }
    }

    private static KeyInfo getKeyInfo(Element element) throws SignatureStructureException, XSignatureException {
        Element element2 = KeyInfo.searchForKeyInfo(element);
        if (element2 == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        return new KeyInfo(element2);
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x509Data, Key key) {
            this.x5data = x509Data;
            this.publicKey = key;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            X509Certificate[] x509CertificateArray = this.x5data.getCertificates();
            if (x509CertificateArray != null) {
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    vector.addElement(x509CertificateArray[i]);
                }
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(vector));
        }

        public Key validate(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            return this.validateAndGetCert(pKIXBuilderParameters).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters pKIXBuilderParameters) throws XSignatureException {
            CertPath certPath;
            Object object;
            List<CertStore> list = pKIXBuilderParameters.getCertStores();
            ArrayList<CertStore> arrayList = new ArrayList<CertStore>((list == null ? 0 : list.size()) + 1);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            try {
                arrayList.add(this.createCertStore());
                pKIXBuilderParameters.setCertStores(arrayList);
                object = CertPathBuilder.getInstance("PKIX");
                CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
                certPath = ((CertPathBuilder)object).build(pKIXBuilderParameters).getCertPath();
                certPathValidator.validate(certPath, pKIXBuilderParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(invalidAlgorithmParameterException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(noSuchAlgorithmException);
            }
            catch (CertPathBuilderException certPathBuilderException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                pKIXBuilderParameters.setCertStores(list);
                throw new XSignatureException(certPathValidatorException);
            }
            object = certPath.getCertificates();
            return object.isEmpty() ? null : (X509Certificate)object.get(0);
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] x509CertificateArray;
            Object[] objectArray;
            Object[] objectArray2;
            X509CertSelector x509CertSelector = new X509CertSelector();
            String[] stringArray = this.x5data.getIssuerNames();
            if (stringArray != null && stringArray.length > 0) {
                objectArray2 = this.x5data.getSerialNumbers();
                x509CertSelector.setIssuer(stringArray[0]);
                x509CertSelector.setSerialNumber((BigInteger)objectArray2[0]);
            }
            if ((objectArray2 = this.x5data.getSubjectNames()) != null && objectArray2.length > 0) {
                x509CertSelector.setSubject((String)objectArray2[0]);
            } else {
                objectArray = this.x5data.getCertificates();
                if (objectArray != null && objectArray.length > 0) {
                    x509CertSelector.setSubject(((X509Certificate)objectArray[0]).getSubjectDN().getName());
                }
            }
            objectArray = this.x5data.getSKIs();
            if (objectArray != null && objectArray.length > 0) {
                x509CertSelector.setSubjectKeyIdentifier((byte[])objectArray[0]);
            }
            if ((x509CertificateArray = this.x5data.getCertificates()) != null && x509CertificateArray.length == 1) {
                x509CertSelector.setCertificate(x509CertificateArray[0]);
            }
            if (this.publicKey != null) {
                x509CertSelector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            return x509CertSelector;
        }
    }
}

