/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.lucene.demo.html.Entities;
import org.apache.lucene.demo.html.HTMLParserConstants;
import org.apache.lucene.demo.html.HTMLParserTokenManager;
import org.apache.lucene.demo.html.ParseException;
import org.apache.lucene.demo.html.ParserThread;
import org.apache.lucene.demo.html.SimpleCharStream;
import org.apache.lucene.demo.html.Token;

public class HTMLParser
implements HTMLParserConstants {
    public static int SUMMARY_LENGTH = 200;
    StringBuffer title = new StringBuffer(SUMMARY_LENGTH);
    StringBuffer summary = new StringBuffer(SUMMARY_LENGTH * 2);
    int length = 0;
    boolean titleComplete = false;
    boolean inTitle = false;
    boolean inMetaTag = false;
    boolean inScript = false;
    boolean afterTag = false;
    boolean afterSpace = false;
    String eol = System.getProperty("line.separator");
    PipedReader pipeIn = null;
    PipedWriter pipeOut;
    public HTMLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[15];
    private final int[] jj_la1_0 = new int[]{5758, 5758, 8192, 458752, 16384, 65536, 131072, 262144, 483328, 483328, 483328, 483328, 0x1000000, 0x4000000, 48};
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public HTMLParser(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public String getTitle() throws IOException, InterruptedException {
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.titleComplete || this.length > SUMMARY_LENGTH) {
                    break;
                }
                this.wait(10L);
            }
        }
        return this.title.toString().trim();
    }

    public String getSummary() throws IOException, InterruptedException {
        String tit;
        String sum;
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.summary.length() >= SUMMARY_LENGTH) {
                    break;
                }
                this.wait(10L);
            }
        }
        if (this.summary.length() > SUMMARY_LENGTH) {
            this.summary.setLength(SUMMARY_LENGTH);
        }
        if ((sum = this.summary.toString().trim()).startsWith(tit = this.getTitle())) {
            return sum.substring(tit.length());
        }
        return sum;
    }

    public Reader getReader() throws IOException {
        if (this.pipeIn == null) {
            this.pipeIn = new PipedReader();
            this.pipeOut = new PipedWriter(this.pipeIn);
            ParserThread thread = new ParserThread(this);
            thread.start();
        }
        return this.pipeIn;
    }

    void addToSummary(String text) {
        if (this.summary.length() < SUMMARY_LENGTH) {
            this.summary.append(text);
            if (this.summary.length() >= SUMMARY_LENGTH) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.notifyAll();
                }
            }
        }
    }

    void addText(String text) throws IOException {
        if (this.inScript) {
            return;
        }
        if (this.inTitle) {
            this.title.append(text);
        } else {
            this.addToSummary(text);
            if (!this.titleComplete && !this.title.equals("")) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.titleComplete = true;
                    this.notifyAll();
                }
            }
        }
        this.length += text.length();
        this.pipeOut.write(text);
        this.afterSpace = false;
    }

    void addSpace() throws IOException {
        if (this.inScript) {
            return;
        }
        if (!this.afterSpace) {
            if (this.inTitle) {
                this.title.append(" ");
            } else {
                this.addToSummary(" ");
            }
            String space = this.afterTag ? this.eol : " ";
            this.length += space.length();
            this.pipeOut.write(space);
            this.afterSpace = true;
        }
    }

    public final void HTMLDocument() throws ParseException, IOException {
        block14: {
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 12: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.Tag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 2: {
                        Token t = this.Decl();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 3: {
                        this.XMLDecl();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 4: 
                    case 5: {
                        this.CommentTag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 6: {
                        Token t = this.jj_consume_token(6);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 9: {
                        Token t = this.jj_consume_token(9);
                        this.addText(Entities.decode(t.image));
                        this.afterTag = false;
                        continue block13;
                    }
                    case 12: {
                        Token t = this.jj_consume_token(12);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        this.addSpace();
                        this.afterTag = false;
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public final void Tag() throws ParseException, IOException {
        boolean inImg = false;
        boolean metaKeywords = false;
        Token t1 = this.jj_consume_token(1);
        this.inTitle = t1.image.equalsIgnoreCase("<title");
        this.inMetaTag = t1.image.equalsIgnoreCase("<meta");
        inImg = t1.image.equalsIgnoreCase("<img");
        this.inScript = this.inScript ? !t1.image.equalsIgnoreCase("</script") : t1.image.equalsIgnoreCase("<script");
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            t1 = this.jj_consume_token(13);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: 
                        case 17: 
                        case 18: {
                            Token t2 = this.ArgValue();
                            if (inImg && t1.image.equalsIgnoreCase("alt") && t2 != null) {
                                this.addText("[" + t2.image + "]");
                            }
                            if (this.inMetaTag && (t1.image.equalsIgnoreCase("name") || t1.image.equalsIgnoreCase("HTTP-EQUIV")) && "keywords".equalsIgnoreCase(t2.image)) {
                                metaKeywords = true;
                            }
                            if (!this.inMetaTag || !metaKeywords || !t1.image.equalsIgnoreCase("content") || t2 == null) continue block9;
                            this.addText(t2.image);
                            continue block9;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    continue block9;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        this.jj_consume_token(15);
    }

    public final Token ArgValue() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                t = this.jj_consume_token(16);
                return t;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(17);
            this.jj_consume_token(21);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                t = this.jj_consume_token(20);
                this.jj_consume_token(21);
                return t;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(18);
            this.jj_consume_token(23);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                t = this.jj_consume_token(22);
                this.jj_consume_token(23);
                return t;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void XMLDecl() throws ParseException {
        block9: {
            this.jj_consume_token(3);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        continue block8;
                    }
                    case 16: 
                    case 17: 
                    case 18: {
                        this.ArgValue();
                        continue block8;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(15);
    }

    public final Token Decl() throws ParseException {
        Token t;
        block9: {
            t = this.jj_consume_token(2);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        continue block8;
                    }
                    case 16: 
                    case 17: 
                    case 18: {
                        this.ArgValue();
                        continue block8;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(15);
        return t;
    }

    public final void CommentTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(24);
                }
                this.jj_consume_token(25);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 26: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(26);
                }
                this.jj_consume_token(27);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public HTMLParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public HTMLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public HTMLParser(HTMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(HTMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 15) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        int i = 0;
        while (i < 28) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 15) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, HTMLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

