/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.servlets.ManagerServlet;

public final class HTMLManagerServlet
extends ManagerServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        String war = request.getParameter("war");
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            response.sendRedirect(request.getRequestURI() + "/list");
        } else if (command.equals("/install")) {
            this.install(writer, path, war);
        } else if (command.equals("/list")) {
            this.list(writer);
        } else if (command.equals("/reload")) {
            this.reload(writer, path);
        } else if (command.equals("/remove")) {
            this.remove(writer, path);
        } else if (command.equals("/sessions")) {
            this.sessions(writer, path);
        } else if (command.equals("/start")) {
            this.start(writer, path);
        } else if (command.equals("/stop")) {
            this.stop(writer, path);
        } else {
            writer.println(ManagerServlet.sm.getString("managerServlet.unknownCommand", (Object)command));
        }
        writer.flush();
        writer.close();
    }

    public void list(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        writer.print("<html>\n<head>\n<title>");
        writer.print("Listed applications for virtual host ");
        writer.print(this.deployer.getName() + "</title>\n</head>\n");
        writer.print("<body bgcolor=\"#FFFFFF\">\n");
        writer.print("<form method=\"get\" action=\"install\">");
        writer.print("<table cellspacing=\"0\"");
        writer.print("cellpadding=\"3\" align=\"center\">\n");
        writer.print("<tr><td colspan=\"3\"><font size=\"+2\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Listed applications for virtual host ");
        writer.print(this.deployer.getName() + "</strong>\n</font></td>\n</tr>\n");
        writer.print("<tr bgcolor=\"#CCCCCC\">\n");
        writer.print("<td align=\"left\"><font size=\"+1\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Path</strong></font>\n</td>");
        writer.print("<td align=\"center\"><font size=\"+1\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Status</strong></font></td>\n");
        writer.print("<td align=\"right\"><font size=\"+1\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Sessions</strong></font></td>\n");
        writer.print("<td align=\"right\"><font size=\"+1\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Reload</strong></font></td>\n");
        writer.print("<td align=\"right\"><font size=\"+1\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("<strong>Remove</strong></font></td>\n</tr>\n");
        String[] contextPaths = this.deployer.findDeployedApps();
        int i = 0;
        while (i < contextPaths.length) {
            Context context = this.deployer.findDeployedApp(contextPaths[i]);
            String displayPath = contextPaths[i];
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context != null) {
                writer.print("<tr bgcolor=\"#FFFFFF\">\n");
                writer.print("<td align=\"left\"><font size=\"1\"");
                writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
                writer.print(displayPath + "</font>\n</td>");
                writer.print("<td align=\"center\"><font size=\"1\"");
                writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
                if (context.getAvailable()) {
                    writer.print("running / <a href=\"stop?path=" + displayPath);
                    writer.print("\">stop</a>");
                } else {
                    writer.print("<a href=\"start?path=" + displayPath);
                    writer.print("\">start</a> / stopped");
                }
                writer.print("</font></td>\n");
                writer.print("<td align=\"right\"><font size=\"1\"");
                writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
                writer.print("<a href=\"sessions?path=" + displayPath + "\">");
                writer.print(context.getManager().findSessions().length);
                writer.print("</a></font></td>\n");
                writer.print("<td align=\"right\"><font size=\"1\"");
                writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
                if (context.getAvailable()) {
                    writer.print("<a href=\"reload?path=" + displayPath + "\">");
                    writer.print("Reload &#187;");
                    writer.print("</a></font></td>\n");
                } else {
                    writer.print("-</font></td>");
                }
                writer.print("<td align=\"right\"><font size=\"1\"");
                writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
                writer.print("<a href=\"remove?path=" + displayPath + "\">");
                writer.print("Remove &#187;");
                writer.print("</a></font></td>\n</tr>\n");
            }
            ++i;
        }
        writer.print("<tr><td colspan=\"5\">&nbsp;</td></tr>");
        writer.print("<tr><td>");
        writer.print("<font size=\"2\"");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">");
        writer.print("<b>Install a webapp</b></font></td>\n");
        writer.print("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
        writer.print("Path:&nbsp;</font>");
        writer.print("<input type=\"text\" name=\"path\" size=\"25\"></td>");
        writer.print("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
        writer.print("War-URL:&nbsp;</font>");
        writer.print("<input type=\"text\" name=\"war\" size=\"25\"></td>");
        writer.print("<td colspan=\"2\">");
        writer.print("&nbsp;<input type=\"submit\" value=\"install\"></td></tr>\n");
        writer.print("<tr><td colspan=\"5\" bgcolor=\"#CCCCCC\"><font size=\"-1\" ");
        writer.print(" face=\"Arial, Helvetica, sans-serif\">\n");
        writer.print("Apache Tomcat/4.0.6</font></td>\n</tr>\n");
        writer.print("</table>\n</form>\n</body>\n</html>");
    }

    protected void reload(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(ManagerServlet.sm.getString("managerServlet.invalidPath", (Object)path));
            this.list(writer);
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(ManagerServlet.sm.getString("managerServlet.noContext", (Object)displayPath));
                this.list(writer);
                return;
            }
            context.reload();
            this.list(writer);
        }
        catch (Throwable t) {
            this.getServletContext().log("ManagerServlet.reload[" + displayPath + "]", t);
            writer.println(ManagerServlet.sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void remove(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("remove: Removing web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(ManagerServlet.sm.getString("managerServlet.invalidPath", (Object)path));
            this.list(writer);
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(ManagerServlet.sm.getString("managerServlet.noContext", (Object)displayPath));
                this.list(writer);
                return;
            }
            this.deployer.remove(path);
            this.list(writer);
        }
        catch (Throwable t) {
            this.getServletContext().log("ManagerServlet.remove[" + displayPath + "]", t);
            writer.println(ManagerServlet.sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    public void start(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(ManagerServlet.sm.getString("managerServlet.invalidPath", (Object)path));
            this.list(writer);
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(ManagerServlet.sm.getString("managerServlet.noContext", (Object)displayPath));
                this.list(writer);
                return;
            }
            this.deployer.start(path);
            this.list(writer);
        }
        catch (Throwable t) {
            this.getServletContext().log("ManagerServlet.start[" + displayPath + "]", t);
            writer.println(ManagerServlet.sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void stop(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(ManagerServlet.sm.getString("managerServlet.invalidPath", (Object)path));
            this.list(writer);
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(ManagerServlet.sm.getString("managerServlet.noContext", (Object)displayPath));
                this.list(writer);
                return;
            }
            this.deployer.stop(path);
            this.list(writer);
        }
        catch (Throwable t) {
            this.getServletContext().log("ManagerServlet.stop[" + displayPath + "]", t);
            writer.println(ManagerServlet.sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }
}

