/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.autoupdater;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JavawsFactory;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.util.GeneralUtil;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class UpdateChecker {
    private static final String COMP_NAME_PREFIX = "auto-update";
    private static final String NAME_SUFFIX = "name";
    private static final String NEW_VERSION_SUFFIX = "new-version";
    private static final String DOWNLOAD_URL_SUFFIX = "url";
    private static final String CURRENT_VERSION_SUFFIX = "current-version";
    private static final String OS_NAME_SUFFIX = "os";
    private static final String ARCH_SUFFIX = "arch";
    private static final String LOCALE_SUFFIX = "locale";
    private static final char DOT = '.';

    private Properties doRead() {
        Properties properties;
        block10: {
            properties = null;
            ConfigProperties configProperties = ConfigProperties.getInstance();
            String string = configProperties.getAutoUpdateURL();
            BufferedInputStream bufferedInputStream = null;
            try {
                HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
                bufferedInputStream = httpRequest.doGetRequest(new URL(string)).getInputStream();
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Debug.ignoredException(fileNotFoundException);
                    return null;
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
                return null;
            }
            if (bufferedInputStream == null) break block10;
            try {
                properties = new Properties();
                properties.load(bufferedInputStream);
                if (Globals.TraceAutoUpdater) {
                    properties.list(System.err);
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
                return null;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private boolean isMatch(String string, String string2, String string3, String string4, String string5) {
        if (string == null || !string.equalsIgnoreCase(Globals.getComponentName())) {
            return false;
        }
        VersionID versionID = new VersionID(Globals.getBuildID());
        if (string2 == null || !VersionString.contains(string2, Globals.getBuildID())) {
            return false;
        }
        String[] stringArray = GeneralUtil.getStringList(string3);
        String[] stringArray2 = GeneralUtil.getStringList(string4);
        String[] stringArray3 = GeneralUtil.getStringList(string5);
        return GeneralUtil.prefixMatchStringList(stringArray, Globals.getOperatingSystemID()) && GeneralUtil.prefixMatchStringList(stringArray2, Globals.getArchitectureID()) && GeneralUtil.matchLocale(stringArray3, Globals.getLocale());
    }

    private String[] findUpdateRecord(Properties properties) {
        int n = 0;
        String string = null;
        do {
            String string2 = "auto-update." + n + '.';
            string = properties.getProperty(string2 + NAME_SUFFIX);
            String string3 = properties.getProperty(string2 + CURRENT_VERSION_SUFFIX);
            String string4 = properties.getProperty(string2 + OS_NAME_SUFFIX);
            String string5 = properties.getProperty(string2 + ARCH_SUFFIX);
            String string6 = properties.getProperty(string2 + LOCALE_SUFFIX);
            String string7 = properties.getProperty(string2 + NEW_VERSION_SUFFIX);
            String string8 = properties.getProperty(string2 + DOWNLOAD_URL_SUFFIX);
            if (this.isMatch(string, string3, string4, string5, string6)) {
                String[] stringArray = new String[2];
                if (string8 != null && string7 != null) {
                    stringArray[0] = string8;
                    stringArray[1] = string7;
                    return stringArray;
                }
            }
            ++n;
        } while (string != null);
        return null;
    }

    String[] isUpdateAvailable() {
        Properties properties = this.doRead();
        if (properties == null) {
            return null;
        }
        return this.findUpdateRecord(properties);
    }
}

