/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.JavawsHttpsCertStore;
import com.sun.javaws.util.BASE64Encoder;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DiskCache {
    private static final int BUF_SIZE = 32768;
    public static final char DIRECTORY_TYPE = 'D';
    public static final char TEMP_TYPE = 'X';
    public static final char VERSION_TYPE = 'V';
    public static final char INDIRECT_TYPE = 'I';
    public static final char RESOURCE_TYPE = 'R';
    public static final char APPLICATION_TYPE = 'A';
    public static final char EXTENSION_TYPE = 'E';
    public static final char MUFFIN_TYPE = 'P';
    private File _baseDir;
    public static final char MAIN_FILE_TAG = 'M';
    public static final char NATIVELIB_FILE_TAG = 'N';
    public static final char TIMESTAMP_FILE_TAG = 'T';
    public static final char CERTIFICATE_FILE_TAG = 'C';
    public static final char LAP_FILE_TAG = 'L';
    public static final char MAPPED_IMAGE_FILE_TAG = 'B';
    public static final char MUFFIN_ATTR_FILE_TAG = 'U';
    public static final int MUFFIN_TAG_INDEX = 0;
    public static final int MUFFIN_MAXSIZE_INDEX = 1;
    private static final String LAST_ACCESS_FILE = "lastAccessed";
    private static final String ORPHAN_LIST_FILE = "orphans";
    private static final String BEGIN_CERT_MARK = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT_MARK = "-----END CERTIFICATE-----";

    public DiskCache(File file) {
        this._baseDir = file;
    }

    long getLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        return file.lastModified();
    }

    private void recordLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {}
    }

    public String getBaseDirForHost(URL uRL) {
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "");
            String string = this.keyToFileLocation('R', 'M', uRL2, null);
            int n = string.lastIndexOf(File.separator);
            return string.substring(0, n);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.shouldNotReachHere();
            return null;
        }
    }

    private void removeEmptyDirs(URL uRL) {
        String string = this.getBaseDirForHost(uRL);
        if (string != null) {
            this.removeEmptyDirs(new File(string));
        }
    }

    private void removeEmptyDirs(File file) {
        block6: {
            if (!file.isDirectory()) break block6;
            File[] fileArray = file.listFiles();
            boolean bl = false;
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    this.removeEmptyDirs(fileArray[n]);
                    if (fileArray[n].exists()) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    Debug.ignoredException(exception);
                }
            }
        }
    }

    private File getOrphanFileForHost(URL uRL) {
        try {
            return new File(this.getBaseDirForHost(uRL), ORPHAN_LIST_FILE);
        }
        catch (Exception exception) {
            Debug.ignoredException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void removeOrphans(URL var1_1) {
        var2_2 = this.getOrphanFileForHost(var1_1);
        if (var2_2 != null && var2_2.exists()) {
            block27: {
                var3_3 = null;
                var4_4 = null;
                var5_5 = false;
                var6_6 = new ArrayList<String>();
                try {
                    var7_7 = new FileInputStream(var2_2);
                    var3_3 = new BufferedReader(new InputStreamReader(var7_7));
                    while ((var8_11 = var3_3.readLine()) != null) {
                        var6_6.add(var8_11);
                    }
                    var9_12 = var6_6.size() - 1;
                    while (var9_12 >= 0) {
                        var10_13 = new File((String)var6_6.get(var9_12));
                        var10_13.delete();
                        if (!var10_13.exists()) {
                            var5_5 = true;
                            var6_6.remove(var9_12);
                        }
                        --var9_12;
                    }
                    var12_14 = null;
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var11_18) {
                    var12_15 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var13_17) {
                            Debug.ignoredException(var13_17);
                        }
                    }
                    throw var11_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var13_16) {
                        Debug.ignoredException(var13_16);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block27;
                    catch (IOException var7_8) {
                        Debug.ignoredException(var7_8);
                        var12_14 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var13_16) {
                                Debug.ignoredException(var13_16);
                            }
                        }
                    }
                }
            }
            if (var5_5) {
                try {
                    block28: {
                        try {
                            if (var6_6.isEmpty()) {
                                if (Globals.TraceDiskCache) {
                                    Debug.println("emptying orphans file");
                                }
                                var2_2.delete();
                                break block28;
                            }
                            var4_4 = new PrintStream(new FileOutputStream(var2_2));
                            var7_9 = 0;
                            while (var7_9 < var6_6.size()) {
                                if (Globals.TraceDiskCache) {
                                    Debug.println("Remaining orphan: " + var6_6.get(var7_9));
                                }
                                var4_4.println((String)var6_6.get(var7_9));
                                ++var7_9;
                            }
                        }
                        catch (Exception var7_10) {
                            Debug.ignoredException(var7_10);
                            var15_20 = null;
                            if (var4_4 != null) {
                                var4_4.close();
                            }
                        }
                    }
                    var15_19 = null;
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                }
                catch (Throwable var14_22) {
                    var15_21 = null;
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw var14_22;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphan(URL uRL, File file) {
        if (Globals.TraceDiskCache) {
            Debug.println("addOrphan: " + file);
        }
        File file2 = this.getOrphanFileForHost(uRL);
        PrintStream printStream = null;
        if (file2 != null) {
            try {
                try {
                    printStream = new PrintStream(new FileOutputStream(file2.getPath(), true));
                    printStream.println(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    Debug.ignoredException(exception);
                    Object var7_6 = null;
                    if (printStream != null) {
                        printStream.close();
                    }
                }
                Object var7_5 = null;
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (printStream != null) {
                    printStream.close();
                }
                throw throwable;
            }
        }
    }

    public File getTempCacheFile(URL uRL, String string) throws IOException {
        String string2 = this.keyToFileLocation('X', 'M', uRL, string);
        File file = null;
        int n = 0;
        do {
            String string3 = string2 + new Date().getTime();
            file = new File(string3);
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                file = null;
            }
            Thread.yield();
        } while (file == null && ++n < 50);
        if (file == null) {
            throw new IOException("Unable to create temp. file for: " + uRL);
        }
        return file;
    }

    File createNativeLibDir(URL uRL, String string) throws IOException {
        File file = this.getFileFromCache('R', 'N', uRL, string, false);
        file.mkdirs();
        return file;
    }

    public void insertMuffinEntry(URL uRL, File file, int n, long l) throws IOException {
        File file2 = this.getFileFromCache('P', 'M', uRL, null, false);
        if (file2.exists()) {
            file.delete();
            throw new IOException("insert failed in cache: target already exixts");
        }
        if (!file.renameTo(file2)) {
            throw new IOException("rename failed in cache");
        }
        this.putMuffinAttributes(uRL, n, l);
    }

    public long getMuffinSize(URL uRL) throws IOException {
        long l = 0L;
        File file = this.getFileFromCache('P', 'M', uRL, null, true);
        if (file != null && file.exists()) {
            l += file.length();
        }
        return l;
    }

    void insertEntry(char c, URL uRL, String string, File file, long l) throws IOException {
        this.putTimeStamp(c, uRL, string, l);
        this.putFileInCache(c, 'M', uRL, string, file);
        this.recordLastUpdate();
    }

    public File putMappedImage(URL uRL, String string, File file) throws IOException {
        Object object;
        if (file.getPath().endsWith(".ico") && !((String)(object = uRL.getFile())).endsWith(".ico")) {
            object = (String)object + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)object);
        }
        object = this.putFileInCache('R', 'B', uRL, string, file);
        this.recordLastUpdate();
        return object;
    }

    public File getMappedImage(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        String string2;
        File file = this.getFileFromCache(c, c2, uRL, string, bl);
        if (!(file != null && file.exists() || (string2 = uRL.getFile()).endsWith(".ico"))) {
            string2 = string2 + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            file = this.getFileFromCache(c, c2, uRL, string, bl);
        }
        return file;
    }

    public void putLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF8");
        this.storeAtomic(c, 'M', uRL, string, byArray);
        this.putTimeStamp(c, uRL, string, new Date().getTime());
    }

    public String getLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = this.getEntryContent(c, 'M', uRL, string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        PrintStream printStream = new PrintStream(this.getOutputStream('P', 'U', uRL, null));
        try {
            printStream.println(n);
            printStream.println(l);
            Object var7_5 = null;
            if (printStream != null) {
                printStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (printStream != null) {
                printStream.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putTimeStamp(char c, URL uRL, String string, long l) throws IOException {
        if (l == 0L) {
            l = new Date().getTime();
        }
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'T', uRL, string));
        try {
            printStream.println(l);
            printStream.println("# " + new Date(l));
            Object var8_6 = null;
            printStream.close();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            printStream.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getMuffinAttributes(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        try {
            InputStream inputStream = this.getInputStream('P', 'U', uRL, null);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            try {
                l = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            string = bufferedReader.readLine();
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            Object var11_9 = null;
            if (bufferedReader == null) return new long[]{l, l2};
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return new long[]{l, l2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    long getTimeStamp(char c, URL uRL, String string) {
        BufferedReader bufferedReader = null;
        InputStream inputStream = this.getInputStream(c, 'T', uRL, string);
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        long l = Long.parseLong(string2);
        Object var11_11 = null;
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return l;
        {
            catch (NumberFormatException numberFormatException) {
                long l2 = 0L;
                Object var11_12 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                return l2;
                catch (IOException iOException) {
                    long l3;
                    try {
                        l3 = 0L;
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException iOException2) {
                            Debug.ignoredException(iOException2);
                        }
                        throw throwable;
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException3) {
                        Debug.ignoredException(iOException3);
                    }
                    return l3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCertificateChain(char c, URL uRL, String string, Certificate[] certificateArray) throws IOException {
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'C', uRL, string));
        try {
            block5: {
                try {
                    if (certificateArray == null) break block5;
                    int n = 0;
                    while (n < certificateArray.length) {
                        BASE64Encoder bASE64Encoder = new BASE64Encoder();
                        byte[] byArray = certificateArray[n].getEncoded();
                        printStream.println(BEGIN_CERT_MARK);
                        bASE64Encoder.encodeBuffer(byArray, (OutputStream)printStream);
                        printStream.println(END_CERT_MARK);
                        ++n;
                    }
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    Debug.ignoredException(certificateEncodingException);
                    Object var10_11 = null;
                    printStream.close();
                }
            }
            Object var10_10 = null;
            printStream.close();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            printStream.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate[] getCertificateChain(char c, URL uRL, String string) throws IOException {
        Certificate[] certificateArray;
        ArrayList<Certificate> arrayList;
        block7: {
            File file = this.getFileFromCache(c, 'C', uRL, string, false);
            if (!file.exists()) {
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            arrayList = new ArrayList<Certificate>();
            try {
                try {
                    certificateArray = CertificateFactory.getInstance("X.509");
                    byte[] byArray = new byte[dataInputStream.available()];
                    dataInputStream.readFully(byArray);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    while (byteArrayInputStream.available() > 0) {
                        arrayList.add(certificateArray.generateCertificate(byteArrayInputStream));
                    }
                }
                catch (CertificateException certificateException) {
                    Debug.ignoredException(certificateException);
                    Object var11_12 = null;
                    dataInputStream.close();
                    break block7;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                dataInputStream.close();
                throw throwable;
            }
            dataInputStream.close();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        certificateArray = new Certificate[arrayList.size()];
        return arrayList.toArray(certificateArray);
    }

    public DiskCacheEntry getMuffinEntry(char c, URL uRL) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, null, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'U', uRL, null, true);
        return new DiskCacheEntry(c, uRL, null, file, -1L, null, null, null, file2);
    }

    public DiskCacheEntry getCacheEntry(char c, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, string, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'N', uRL, string, true);
        File file3 = this.getMappedImage(c, 'B', uRL, string, true);
        File file4 = this.getFileFromCache(c, 'C', uRL, string, false);
        Certificate[] certificateArray = this.getCertificateChain(c, uRL, string);
        long l = this.getTimeStamp(c, uRL, string);
        DiskCacheEntry diskCacheEntry = new DiskCacheEntry(c, uRL, string, file, l, file4, file2, file3, null);
        diskCacheEntry.setCertificateChain(certificateArray);
        return diskCacheEntry;
    }

    public DiskCacheEntry[] getCacheEntries(char c, URL uRL, String string, boolean bl) throws IOException {
        DiskCacheEntry[] diskCacheEntryArray;
        if (string == null) {
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, null);
            if (diskCacheEntry == null) {
                return new DiskCacheEntry[0];
            }
            return new DiskCacheEntry[]{diskCacheEntry};
        }
        ArrayList arrayList = this.getCacheEntries(c, uRL);
        VersionString versionString = new VersionString(string);
        DiskCacheEntry[] diskCacheEntryArray2 = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            diskCacheEntryArray = (DiskCacheEntry[])iterator.next();
            String string2 = diskCacheEntryArray.getVersionId();
            if (string2 == null) {
                iterator.remove();
                continue;
            }
            if (versionString.contains(string2)) continue;
            if (diskCacheEntryArray2 == null && versionString.containsGreaterThan(string2)) {
                diskCacheEntryArray2 = diskCacheEntryArray;
            }
            iterator.remove();
        }
        if (!bl && arrayList.size() == 0 && diskCacheEntryArray2 != null) {
            arrayList.add(diskCacheEntryArray2);
        }
        diskCacheEntryArray = new DiskCacheEntry[arrayList.size()];
        return arrayList.toArray(diskCacheEntryArray);
    }

    public void removeMuffinEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'U', uRL, string);
    }

    public void removeEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        this.removeOrphans(uRL);
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'T', uRL, string);
        this.deleteEntry(c, 'C', uRL, string);
        this.deleteEntry(c, 'N', uRL, string);
        this.deleteEntry(c, 'B', uRL, string);
        this.deleteEntry(c, 'L', uRL, string);
        if (c == 'R') {
            this.deleteEntry('I', 'M', uRL, string);
        }
        this.removeEmptyDirs(uRL);
    }

    private void deleteEntry(char c, char c2, URL uRL, String string) {
        File file = null;
        try {
            file = c2 == 'B' ? this.getMappedImage(c, c2, uRL, string, false) : this.getFileFromCache(c, c2, uRL, string, false);
            this.deleteFile(file);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        if (file != null && file.exists() && c == 'R' && c2 == 'M') {
            this.addOrphan(uRL, file);
        }
    }

    public DiskCacheEntry getCacheEntryFromFile(File file) throws IOException {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        if (diskCacheEntry.getType() == 'P') {
            return this.getMuffinEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation());
        }
        return this.getCacheEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation(), diskCacheEntry.getVersionId());
    }

    public boolean isMainMuffinFile(File file) throws IOException {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        return file.equals(this.getFileFromCache('P', 'M', diskCacheEntry.getLocation(), null, false));
    }

    private ArrayList getCacheEntries(char c, URL uRL) throws IOException {
        Object object;
        Object object2;
        ArrayList<DiskCacheEntry> arrayList = new ArrayList<DiskCacheEntry>();
        String string = this.keyToFileLocation(c, 'M', uRL, "MATCH");
        int n = string.indexOf(File.separator + 'V' + "MATCH" + File.separator);
        Debug.jawsAssert(n != -1, "Must be found");
        String string2 = string.substring(0, n);
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            String string3 = fileArray[n2].getName();
            if (string3.length() > 0 && string3.charAt(0) == 'V' && (object2 = this.getFileFromCache(c, 'M', uRL, (String)(object = string3.substring(1)), true)) != null) {
                DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, (String)object);
                arrayList.add(diskCacheEntry);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        if (n3 > 1) {
            object = new DiskCacheEntry[n3];
            object = arrayList.toArray((T[])object);
            Arrays.sort(object, new Comparator(){

                public int compare(Object object, Object object2) {
                    VersionID versionID;
                    DiskCacheEntry diskCacheEntry = (DiskCacheEntry)object;
                    DiskCacheEntry diskCacheEntry2 = (DiskCacheEntry)object2;
                    VersionID versionID2 = new VersionID(diskCacheEntry.getVersionId());
                    return versionID2.isGreaterThan(versionID = new VersionID(diskCacheEntry2.getVersionId())) ? -1 : 1;
                }
            });
            int n4 = 0;
            while (n4 < n3) {
                arrayList.set(n4, object[n4]);
                ++n4;
            }
        }
        if ((object = this.getFileFromCache(c, 'M', uRL, null, true)) != null) {
            object2 = this.getCacheEntry(c, uRL, null);
            arrayList.add((DiskCacheEntry)object2);
        }
        return arrayList;
    }

    void visitDiskCache(char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        this.visitDiskCacheHelper(this._baseDir, 0, c, diskCacheVisitor);
    }

    private void visitDiskCacheHelper(File file, int n, char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        String string = file.getName();
        if (file.isDirectory() && (string.length() <= 2 || file.getName().charAt(1) != 'N')) {
            File[] fileArray = file.listFiles();
            int n2 = 0;
            while (n2 < fileArray.length) {
                this.visitDiskCacheHelper(fileArray[n2], n + 1, c, diskCacheVisitor);
                ++n2;
            }
        } else if (string.length() > 2 && n > 3) {
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            if (c2 == c && c3 == 'M') {
                DiskCacheEntry diskCacheEntry = this.getCacheEntryFromFile(file);
                Debug.jawsAssert(diskCacheEntry != null, "should never return null");
                diskCacheVisitor.visitEntry(diskCacheEntry);
            }
        }
    }

    public File getMuffinFileForURL(URL uRL) {
        try {
            return this.getFileFromCache('P', 'M', uRL, null, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL[] getAccessibleMuffins(URL uRL) throws IOException {
        MuffinAccessVisitor muffinAccessVisitor = new MuffinAccessVisitor(this, uRL);
        this.visitDiskCache('P', muffinAccessVisitor);
        return muffinAccessVisitor.getAccessibleMuffins();
    }

    public long getCacheSize() throws IOException {
        if (Globals.TraceDiskCache) {
            Debug.println("Computing diskcache size: " + this._baseDir.getAbsoluteFile());
        }
        SizeVisitor sizeVisitor = new SizeVisitor(this);
        this.visitDiskCache('R', sizeVisitor);
        return sizeVisitor.getSize();
    }

    public void uninstallCache() {
        this.deleteFile(this._baseDir);
        if (this._baseDir.exists()) {
            this.recordLastUpdate();
        }
    }

    private void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                this.deleteFile(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    private OutputStream getOutputStream(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, false);
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.recordLastUpdate();
        return new FileOutputStream(file);
    }

    private InputStream getInputStream(char c, char c2, URL uRL, String string) throws IOException {
        return new FileInputStream(this.getFileFromCache(c, c2, uRL, string, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getEntryContent(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, true);
        if (file == null) {
            return null;
        }
        long l = file.length();
        if (l > 0x40000000L) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        byte[] byArray = new byte[32768];
        try {
            int n = bufferedInputStream.read(byArray);
            while (n >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            byteArrayOutputStream.close();
            bufferedInputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
        bufferedInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeAtomic(char c, char c2, URL uRL, String string, byte[] byArray) throws IOException {
        File file = this.getTempCacheFile(uRL, string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray2 = new byte[32768];
        try {
            int n = byteArrayInputStream.read(byArray2);
            while (n >= 0) {
                bufferedOutputStream.write(byArray2, 0, n);
                n = byteArrayInputStream.read(byArray2);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            bufferedOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
            throw throwable;
        }
        bufferedOutputStream.close();
        ((InputStream)byteArrayInputStream).close();
        this.putFileInCache(c, c2, uRL, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File putFileInCache(char c, char c2, URL uRL, String string, File file) throws IOException {
        File file2;
        File file3 = new File(this.keyToFileLocation(c, c2, uRL, string));
        this.removeOrphans(uRL);
        file3.delete();
        if (!file.renameTo(file3)) {
            this.deleteEntry(c, c2, uRL, string);
            if (c == 'R' && c2 == 'M') {
                PrintStream printStream = new PrintStream(this.getOutputStream('I', 'M', uRL, string));
                try {
                    printStream.println(file.getCanonicalPath());
                    Object var9_9 = null;
                    printStream.close();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    printStream.close();
                    throw throwable;
                }
                return file;
            }
            throw new IOException("rename failed in cache to: " + file3);
        }
        if (c == 'R' && c2 == 'M' && (file2 = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
            this.deleteEntry(c, c2, uRL, string);
            this.deleteEntry('I', c2, uRL, string);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getFileFromCache(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        block10: {
            File file;
            BufferedReader bufferedReader = null;
            if (c == 'R' && c2 == 'M' && (file = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
                File file2;
                try {
                    try {
                        File file3;
                        InputStream inputStream = this.getInputStream('I', 'M', uRL, string);
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string2 = bufferedReader.readLine();
                        file2 = file3 = new File(string2);
                        Object var13_15 = null;
                        if (bufferedReader == null) return file2;
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            File file4 = null;
                            Object var13_16 = null;
                            if (bufferedReader == null) return file4;
                            bufferedReader.close();
                            return file4;
                        }
                        Object var13_17 = null;
                        if (bufferedReader == null) break block10;
                        bufferedReader.close();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (bufferedReader == null) throw throwable;
                    bufferedReader.close();
                    throw throwable;
                }
                bufferedReader.close();
                return file2;
            }
        }
        File file = new File(this.keyToFileLocation(c, c2, uRL, string));
        if (!bl || file.exists()) return file;
        return null;
    }

    private DiskCacheEntry fileToEntry(File file) {
        Object object;
        String string;
        if (Globals.TraceDiskCache) {
            Debug.println("FileToEntry: " + file);
        }
        char c = '\u0000';
        URL uRL = null;
        String string2 = null;
        long l = 0L;
        String string3 = file.getAbsolutePath();
        if (!string3.startsWith(string = this._baseDir.getAbsolutePath())) {
            return null;
        }
        string3 = string3.substring(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.separator, false);
        try {
            object = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string4.length() < 1) {
                return null;
            }
            string4 = string4.substring(1);
            String string5 = stringTokenizer.nextToken();
            if (string5.length() < 1) {
                return null;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string5.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                String string6 = stringTokenizer.nextToken();
                if ((string6 = DiskCache.removeEscapes(string6)).length() < 1) {
                    return null;
                }
                c = string6.charAt(0);
                if (c == 'V') {
                    string2 = string6.substring(1);
                    continue;
                }
                stringBuffer.append('/');
                stringBuffer.append(string6.substring(2));
            }
            uRL = new URL((String)object, string4, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        object = new DiskCacheEntry(c, uRL, string2, file, 0L);
        if (Globals.TraceDiskCache) {
            Debug.println("Returning: " + object);
        }
        return object;
    }

    private static String removeEscapes(String string) {
        if (string == null || string.indexOf(38) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length() - 1) {
            char c = string.charAt(n);
            char c2 = string.charAt(n + 1);
            if (c == '&' && c2 == 'p') {
                ++n;
                stringBuffer.append('%');
            } else if (c == '&' && c2 == 'c') {
                ++n;
                stringBuffer.append(':');
            } else if (c != '&' || c2 != '&') {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    private String keyToFileLocation(char c, char c2, URL uRL, String string) {
        StringBuffer stringBuffer = new StringBuffer(uRL.toString().length() + (string == null ? 0 : string.length()) * 2);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append('D');
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(File.separatorChar);
        String string2 = null;
        string2 = uRL.getPort() == -1 && uRL.getProtocol().equals("http") ? "P80" : "P" + new Integer(uRL.getPort()).toString();
        stringBuffer.append(string2);
        stringBuffer.append(File.separatorChar);
        if (string != null) {
            stringBuffer.append('V');
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.convertURLfile(c, c2, uRL.getFile()));
        return this._baseDir.getAbsolutePath() + File.separator + stringBuffer.toString();
    }

    private String convertURLfile(char c, char c2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '/') {
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('D');
                stringBuffer.append('M');
                n = stringBuffer.length();
            } else if (string.charAt(n2) == ':') {
                stringBuffer.append("&c");
            } else if (string.charAt(n2) == '&') {
                stringBuffer.append("&&");
            } else if (string.charAt(n2) == '%') {
                stringBuffer.append("&p");
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        if (n == -1) {
            stringBuffer.insert(0, c);
            stringBuffer.insert(1, c2);
        } else {
            stringBuffer.setCharAt(n - 2, c);
            stringBuffer.setCharAt(n - 1, c2);
        }
        return stringBuffer.toString();
    }

    private static class SizeVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        long _size = 0L;

        SizeVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
            this._size = new File(JavawsHttpsCertStore.getJavawsHttpsFilename()).length();
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            if (diskCacheEntry.getDirectory() != null && diskCacheEntry.getDirectory().exists()) {
                File[] fileArray = diskCacheEntry.getDirectory().listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    this._size += fileArray[n].length();
                    ++n;
                }
            } else {
                this._size += diskCacheEntry.getFile().length();
            }
        }

        public long getSize() {
            return this._size;
        }
    }

    private static class DeleteVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;

        DeleteVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            this._diskCache.removeEntry(diskCacheEntry);
        }
    }

    private static class MuffinAccessVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        private URL _theURL;
        private URL[] _urls = new URL[255];
        private int _counter = 0;

        MuffinAccessVisitor(DiskCache diskCache, URL uRL) {
            this._diskCache = diskCache;
            this._theURL = uRL;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            URL uRL = diskCacheEntry.getLocation();
            if (uRL == null) {
                return;
            }
            if (uRL.getHost().equals(this._theURL.getHost())) {
                this._urls[this._counter++] = uRL;
            }
        }

        public URL[] getAccessibleMuffins() {
            return this._urls;
        }
    }

    public static interface DiskCacheVisitor {
        public void visitEntry(DiskCacheEntry var1);
    }
}

